/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.tools;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.talend.sdk.component.tools.DocBaseGenerator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DitaDocumentationGenerator
extends DocBaseGenerator {
    private final boolean ignoreType;
    private final boolean ignoreFullPath;

    public DitaDocumentationGenerator(File[] classes, Locale locale, Object log, File output, boolean ignoreType, boolean ignoreFullPath) {
        super(classes, locale, log, output);
        this.ignoreType = ignoreType;
        this.ignoreFullPath = ignoreFullPath;
    }

    @Override
    public void doRun() {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        DocumentBuilderFactory builderFactory = this.newDocFactory();
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        HashSet directories = new HashSet();
        try (ZipOutputStream zip = new ZipOutputStream(buffer);){
            this.components().forEach(it -> {
                try {
                    this.addDita((DocBaseGenerator.ComponentDescription)it, builderFactory, transformerFactory, zip, directories);
                }
                catch (ParserConfigurationException e) {
                    throw new IllegalStateException(e);
                }
            });
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        this.ensureParentExists(this.output);
        try (OutputStream out = Files.newOutputStream(this.output.toPath(), StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);){
            out.write(buffer.toByteArray());
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        this.log.info("Generated " + this.output.getAbsolutePath());
    }

    @Override
    protected String emptyDefaultValue() {
        return null;
    }

    private void addDita(DocBaseGenerator.ComponentDescription componentDescription, DocumentBuilderFactory factory, TransformerFactory transformerFactory, ZipOutputStream zip, Collection<String> directories) throws ParserConfigurationException {
        String family = componentDescription.getFamily();
        String name = componentDescription.getName();
        String componentId = family + '-' + name;
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document xml = builder.newDocument();
        Element reference = xml.createElement("reference");
        reference.setAttribute("id", "connector_" + componentId);
        reference.setAttribute("id", "connector-" + family + '-' + name);
        reference.setAttribute("xml:lang", Optional.ofNullable(this.getLocale().getLanguage()).filter(it -> !it.isEmpty()).orElse("en-us"));
        xml.appendChild(reference);
        Element title = xml.createElement("title");
        title.setAttribute("id", "component_title_" + componentId);
        title.setTextContent(name + " parameters");
        reference.appendChild(title);
        Element shortdesc = xml.createElement("shortdesc");
        shortdesc.setTextContent(componentDescription.getDocumentation().trim());
        reference.appendChild(shortdesc);
        Element prolog = xml.createElement("prolog");
        Element metadata = xml.createElement("metadata");
        Element othermeta = xml.createElement("othermeta");
        othermeta.setAttribute("content", family);
        othermeta.setAttribute("name", "pageid");
        metadata.appendChild(othermeta);
        prolog.appendChild(metadata);
        reference.appendChild(prolog);
        Element body = xml.createElement("refbody");
        body.setAttribute("outputclass", "subscription");
        Map<String, Map<String, List<DocBaseGenerator.Param>>> parametersWithUInfo2 = componentDescription.getParametersWithUInfo();
        this.generateConfigurationSection(xml, body, family, name, reference.getAttribute("id"), parametersWithUInfo2.get("datastore"), "connection");
        this.generateConfigurationSection(xml, body, family, name, reference.getAttribute("id"), parametersWithUInfo2.get("dataset"), "dataset");
        this.generateConfigurationSection(xml, body, family, name, reference.getAttribute("id"), parametersWithUInfo2.get(""), "other");
        reference.appendChild(body);
        StringWriter writer = new StringWriter();
        StreamResult result = new StreamResult(writer);
        try {
            String ditaFolder;
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xalan}indent-amount", "2");
            transformer.transform(new DOMSource(xml), result);
            String rootDir = this.output.getName().replace(".zip", "");
            if (directories.add(rootDir)) {
                zip.putNextEntry(new ZipEntry(rootDir + '/'));
                zip.closeEntry();
            }
            if (directories.add(ditaFolder = rootDir + '/' + family)) {
                zip.putNextEntry(new ZipEntry(ditaFolder + '/'));
                zip.closeEntry();
            }
            String path = ditaFolder + '/' + name + ".dita";
            zip.putNextEntry(new ZipEntry(path));
            String content = writer.toString();
            int refIdx = content.indexOf("<reference");
            zip.write((content.substring(0, refIdx) + "<!DOCTYPE reference PUBLIC \"-//Talend//DTD DITA Composite//EN\" \"TalendDitabase.dtd\">\n" + content.substring(refIdx)).getBytes(StandardCharsets.UTF_8));
            zip.closeEntry();
        }
        catch (IOException | TransformerException e) {
            throw new IllegalStateException(e);
        }
    }

    private void generateConfigurationSection(Document xml, Element body, String family, String name, String id, Map<String, List<DocBaseGenerator.Param>> parameters, String sectionName) {
        if (parameters == null) {
            return;
        }
        String sectionId = "section_" + id + "_" + sectionName;
        Element section = xml.createElement("section");
        section.setAttribute("id", sectionId);
        section.setAttribute("outputclass", "subscription");
        body.appendChild(section);
        Element sectionTitle = xml.createElement("title");
        sectionTitle.setTextContent(sectionName.substring(0, 1).toUpperCase() + sectionName.substring(1) + " parameters for " + family + " " + name + " component.");
        section.appendChild(sectionTitle);
        this.generateConfigurationArray(xml, section, parameters.get("tcomp::ui::gridlayout::Main::value"), "", sectionId);
        this.generateConfigurationArray(xml, section, parameters.get("tcomp::ui::gridlayout::Advanced::value"), "Advanced parameters", sectionId);
    }

    private void generateConfigurationArray(Document xml, Element section, List<DocBaseGenerator.Param> params, String caption, String sectionId) {
        if (params != null && params.size() > 0) {
            boolean arrayIsNeeded;
            boolean bl = arrayIsNeeded = params.stream().filter(p -> !p.isComplex() || p.isSection()).collect(Collectors.toList()).size() > 0;
            if (!arrayIsNeeded) {
                return;
            }
            int columnNumber = 6 - Stream.of(this.ignoreType, this.ignoreFullPath).mapToInt(it -> it != false ? 1 : 0).sum();
            Element table = xml.createElement("table");
            table.setAttribute("colsep", "1");
            table.setAttribute("frame", "all");
            table.setAttribute("rowsep", "1");
            if (caption != null && !caption.trim().isEmpty()) {
                Element tCaption = xml.createElement("title");
                tCaption.setTextContent(caption);
                table.appendChild(tCaption);
            }
            Element tgroup = xml.createElement("tgroup");
            tgroup.setAttribute("cols", Integer.toString(columnNumber));
            table.appendChild(tgroup);
            IntStream.rangeClosed(1, columnNumber).forEach(col -> {
                Element colspec = xml.createElement("colspec");
                colspec.setAttribute("colname", "c" + col);
                colspec.setAttribute("colnum", Integer.toString(col));
                colspec.setAttribute("colwidth", "1*");
                tgroup.appendChild(colspec);
            });
            Element configurationHead = xml.createElement("thead");
            Element headRow = xml.createElement("row");
            this.appendColumn(xml, headRow, "Display Name");
            this.appendColumn(xml, headRow, "Description");
            this.appendColumn(xml, headRow, "Default Value");
            this.appendColumn(xml, headRow, "Enabled If");
            if (!this.ignoreFullPath) {
                this.appendColumn(xml, headRow, "Path");
            }
            if (!this.ignoreType) {
                this.appendColumn(xml, headRow, "Type");
            }
            configurationHead.appendChild(headRow);
            tgroup.appendChild(configurationHead);
            Element configurationBody = xml.createElement("tbody");
            params.forEach(param -> {
                Element row = xml.createElement("row");
                String from = null;
                String to = null;
                if (!param.isSection() && param.isComplex()) {
                    from = "c2";
                    to = "c4";
                }
                this.appendColumn(xml, row, param.getDisplayName(), "uicontrol");
                this.appendColumn(xml, row, param.getDocumentation(), null, from, to);
                if (!param.isComplex()) {
                    this.appendColumn(xml, row, param.getDefaultValue(), "userinput");
                    Element column = xml.createElement("entry");
                    this.renderConditions(xml, column, param.getConditions());
                    row.appendChild(column);
                    if (!this.ignoreFullPath) {
                        this.appendColumn(xml, row, param.getFullPath());
                    }
                    if (!this.ignoreType) {
                        this.appendColumn(xml, row, param.getType());
                    }
                } else if (param.isSection()) {
                    this.appendLink(xml, row, "#" + sectionId.substring(0, sectionId.lastIndexOf(95)) + "_" + param.getSectionName(), "See section " + param.getSectionName(), "c3", "c4");
                }
                configurationBody.appendChild(row);
            });
            tgroup.appendChild(configurationBody);
            section.appendChild(table);
        }
    }

    private void renderConditions(Document xml, Element container, DocBaseGenerator.Conditions conditions) {
        switch (conditions.getConditions().size()) {
            case 0: {
                container.setTextContent("Always enabled");
                break;
            }
            case 1: {
                this.renderCondition(xml, container, conditions.getConditions().iterator().next(), "or");
                break;
            }
            default: {
                Element listWrapper = xml.createElement("ul");
                Runnable conditionAppender = () -> conditions.getConditions().forEach(cond -> {
                    Element li = xml.createElement("li");
                    this.renderCondition(xml, li, (DocBaseGenerator.Condition)cond, conditions.getOperator());
                    listWrapper.appendChild(li);
                });
                switch (conditions.getOperator().toUpperCase(Locale.ROOT)) {
                    case "OR": {
                        container.setTextContent("One of these conditions is meet:");
                        conditionAppender.run();
                        break;
                    }
                    default: {
                        container.setTextContent("All of the following conditions are met:");
                        conditionAppender.run();
                    }
                }
                container.appendChild(listWrapper);
            }
        }
    }

    private void renderCondition(Document xml, Element container, DocBaseGenerator.Condition condition, String op) {
        Runnable valuesAppender = () -> {
            AtomicBoolean init = new AtomicBoolean();
            Stream.of(condition.getValue().split(",")).map(v -> {
                Element userinput = xml.createElement("userinput");
                userinput.setTextContent((String)v);
                return userinput;
            }).reduce(container, (wrapper, child) -> {
                if (!init.compareAndSet(false, true)) {
                    wrapper.appendChild(xml.createTextNode(" or "));
                }
                wrapper.appendChild((Node)child);
                return wrapper;
            });
        };
        Runnable appendPath = () -> {
            Element parmname = xml.createElement("parmname");
            parmname.setTextContent(condition.getPath());
            container.appendChild(parmname);
        };
        switch (Optional.ofNullable(condition.getStrategy()).orElse("default").toLowerCase(Locale.ROOT)) {
            case "length": {
                if (condition.isNegate()) {
                    if ("0".equals(condition.getValue())) {
                        appendPath.run();
                        container.appendChild(xml.createTextNode(" is not empty"));
                        break;
                    }
                    container.appendChild(xml.createTextNode("the length of "));
                    appendPath.run();
                    container.appendChild(xml.createTextNode(" is not "));
                    valuesAppender.run();
                    break;
                }
                if ("0".equals(condition.getValue())) {
                    appendPath.run();
                    container.appendChild(xml.createTextNode(" is empty"));
                    break;
                }
                container.appendChild(xml.createTextNode("the length of "));
                appendPath.run();
                container.appendChild(xml.createTextNode(" is "));
                valuesAppender.run();
                break;
            }
            case "contains": {
                appendPath.run();
                if (condition.isNegate()) {
                    container.appendChild(xml.createTextNode(" does not contain "));
                } else {
                    container.appendChild(xml.createTextNode(" contains "));
                }
                valuesAppender.run();
                break;
            }
            case "contains(lowercase=true)": {
                container.appendChild(xml.createTextNode("the lowercase value of "));
                appendPath.run();
                if (condition.isNegate()) {
                    container.appendChild(xml.createTextNode(" does not contain "));
                } else {
                    container.appendChild(xml.createTextNode(" contains "));
                }
                valuesAppender.run();
                break;
            }
            default: {
                appendPath.run();
                if (condition.isNegate()) {
                    container.appendChild(xml.createTextNode(" is not equal to "));
                } else {
                    container.appendChild(xml.createTextNode(" is equal to "));
                }
                valuesAppender.run();
            }
        }
    }

    private void appendColumn(Document xml, Element row, String value) {
        this.appendColumn(xml, row, value, null);
    }

    private void appendColumn(Document xml, Element row, String value, String childNode) {
        this.appendColumn(xml, row, value, childNode, null, null);
    }

    private void appendLink(Document xml, Element row, String href, String value, String spanFrom, String spanTo) {
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("href", href);
        this.appendColumn(xml, row, value, "link", attributes, spanFrom, spanTo);
    }

    private void appendColumn(Document xml, Element row, String value, String childNode, String spanFrom, String spanTo) {
        this.appendColumn(xml, row, value, childNode, Collections.emptyMap(), spanFrom, spanTo);
    }

    private void appendColumn(Document xml, Element row, String value, String childNode, Map<String, String> childAttributes, String spanFrom, String spanTo) {
        Element column = xml.createElement("entry");
        if (spanFrom != null && spanTo != null) {
            column.setAttribute("namest", spanFrom);
            column.setAttribute("nameend", spanTo);
        }
        if (value != null) {
            String content = value.trim();
            String string = content = content == null ? "" : content;
            if (childNode != null && !childNode.trim().isEmpty()) {
                Element control = xml.createElement(childNode);
                childAttributes.forEach((k, v) -> control.setAttribute((String)k, (String)v));
                control.setTextContent(content);
                column.appendChild(control);
            } else {
                column.setTextContent(content);
            }
        }
        row.appendChild(column);
    }

    private DocumentBuilderFactory newDocFactory() {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        }
        catch (ParserConfigurationException e) {
            throw new IllegalStateException(e);
        }
        return factory;
    }
}

