/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.tools.validator;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.apache.xbean.finder.AnnotationFinder;
import org.talend.sdk.component.api.configuration.ui.widget.Structure;
import org.talend.sdk.component.api.input.Emitter;
import org.talend.sdk.component.api.input.PartitionMapper;
import org.talend.sdk.component.api.processor.Processor;
import org.talend.sdk.component.api.standalone.DriverRunner;
import org.talend.sdk.component.runtime.manager.reflect.Constructors;
import org.talend.sdk.component.runtime.visitor.ModelListener;
import org.talend.sdk.component.runtime.visitor.ModelVisitor;
import org.talend.sdk.component.tools.validator.Validator;
import org.talend.sdk.component.tools.validator.Validators;

public class ModelValidator
implements Validator {
    private final boolean validateComponent;
    private final Validators.ValidatorHelper helper;

    public ModelValidator(boolean validateComponent, Validators.ValidatorHelper helper) {
        this.validateComponent = validateComponent;
        this.helper = helper;
    }

    @Override
    public Stream<String> validate(AnnotationFinder finder, List<Class<?>> components) {
        Stream<String> errorsAnnotations = components.stream().filter(this::containsIncompatibleAnnotation).map(i -> i + " has conflicting component annotations, ensure it has a single one").sorted();
        Stream<String> errorsParamConstructors = components.stream().filter(c -> this.countParameters(Constructors.findConstructor((Class)c).getParameters()) > 1).map(c -> "Component must use a single root option. '" + c.getName() + "'").sorted();
        ModelVisitor modelVisitor = new ModelVisitor();
        ModelListener noop = new ModelListener(){};
        Stream<String> errorsConfig = components.stream().map(c -> {
            try {
                modelVisitor.visit(c, noop, this.validateComponent);
                return null;
            }
            catch (RuntimeException re) {
                return re.getMessage();
            }
        }).filter(Objects::nonNull).sorted();
        Stream<String> errorStructure = finder.findAnnotatedFields(Structure.class).stream().filter(f -> !ParameterizedType.class.isInstance(f.getGenericType()) || !this.isListObject((Field)f)).map(f -> f.getDeclaringClass() + "#" + f.getName() + " uses @Structure but is not a List<String> nor a List<Object>").sorted();
        return Stream.of(errorsAnnotations, errorsParamConstructors, errorsConfig, errorStructure).reduce(Stream::concat).orElse(Stream.empty());
    }

    private boolean containsIncompatibleAnnotation(Class<?> clazz) {
        return Stream.of(PartitionMapper.class, Processor.class, Emitter.class, DriverRunner.class).filter(an -> clazz.isAnnotationPresent((Class<Annotation>)an)).count() > 1L;
    }

    private int countParameters(Parameter[] params) {
        return (int)Stream.of(params).filter(p -> !this.helper.isService((Parameter)p)).count();
    }

    private boolean isListObject(Field f) {
        ParameterizedType pt = (ParameterizedType)ParameterizedType.class.cast(f.getGenericType());
        return List.class == pt.getRawType() && pt.getActualTypeArguments().length == 1;
    }
}

