/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.tools;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import java.util.Scanner;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.apache.catalina.WebResourceRoot;
import org.apache.catalina.core.StandardServer;
import org.apache.catalina.webresources.StandardRoot;
import org.apache.meecrowave.Meecrowave;
import org.apache.meecrowave.configuration.Configuration;
import org.apache.meecrowave.runner.Cli;
import org.talend.sdk.component.tools.Browser;
import org.talend.sdk.component.tools.Log;
import org.talend.sdk.component.tools.ReflectiveLog;

public class WebServer
implements Runnable {
    private final Collection<String> serverArguments;
    private final Integer port;
    private final String componentGav;
    private final Log log;
    private final Collection<Consumer<Meecrowave.Builder>> onOpen = new ArrayList<Consumer<Meecrowave.Builder>>();

    public WebServer(Collection<String> serverArguments, Integer port, Object log, String gav) {
        this.serverArguments = serverArguments;
        this.port = port;
        try {
            this.log = Log.class.isInstance(log) ? (Log)Log.class.cast(log) : new ReflectiveLog(log);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(e);
        }
        this.componentGav = gav;
    }

    public WebServer onOpen(Consumer<Meecrowave.Builder> task) {
        this.onOpen.add(task);
        return this;
    }

    public WebServer openBrowserWhenReady() {
        return this.onOpen(builder -> Browser.open("http://localhost:" + builder.getHttpPort(), this.log));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        String originalCompSystProp = this.setSystemProperty("talend.component.server.component.coordinates", this.componentGav);
        String skipClasspathSystProp = this.setSystemProperty("component.manager.classpath.skip", "true");
        String skipCallersSystProp = this.setSystemProperty("component.manager.callers.skip", "true");
        AtomicReference ref = new AtomicReference();
        try {
            CountDownLatch latch = new CountDownLatch(1);
            new Thread(() -> {
                try (Meecrowave meecrowave = new Meecrowave((Configuration)Cli.create((String[])this.buildArgs()));){
                    meecrowave.start().deployClasspath(new Meecrowave.DeploymentMeta("", null, stdCtx -> stdCtx.setResources((WebResourceRoot)new StandardRoot(){

                        protected void registerURLStreamHandlerFactory() {
                        }
                    })));
                    ref.set(meecrowave);
                    latch.countDown();
                    this.onOpen.forEach(it -> it.accept(meecrowave.getConfiguration()));
                    meecrowave.getTomcat().getServer().await();
                }
                catch (RuntimeException re) {
                    latch.countDown();
                    this.log.error(re.getMessage());
                    throw re;
                }
            }, this.getClass().getName() + '_' + this.findPort()).start();
            try {
                latch.await(2L, TimeUnit.MINUTES);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                this.reset("talend.component.server.component.coordinates", originalCompSystProp);
                this.reset("component.manager.classpath.skip", skipClasspathSystProp);
                this.reset("component.manager.callers.skip", skipCallersSystProp);
                Optional.ofNullable((Meecrowave)ref.get()).ifPresent(mw -> ((StandardServer)StandardServer.class.cast(mw.getTomcat().getServer())).stopAwait());
                return;
            }
            this.log.info("\n\n  You can now access the UI at http://localhost:" + this.port + "\n\n");
            Scanner scanner = new Scanner(System.in);
            do {
                this.log.info("Enter 'exit' to quit");
            } while (!this.shouldQuit(scanner.nextLine()));
        }
        finally {
            this.reset("talend.component.server.component.coordinates", originalCompSystProp);
            this.reset("component.manager.classpath.skip", skipClasspathSystProp);
            this.reset("component.manager.callers.skip", skipCallersSystProp);
            Optional.ofNullable((Meecrowave)ref.get()).ifPresent(mw -> ((StandardServer)StandardServer.class.cast(mw.getTomcat().getServer())).stopAwait());
        }
    }

    private String setSystemProperty(String key, String value) {
        String old = System.getProperty(key);
        System.setProperty(key, value);
        return old;
    }

    private void reset(String key, String value) {
        if (value == null) {
            System.clearProperty(key);
        } else {
            System.setProperty(key, value);
        }
    }

    private boolean shouldQuit(String value) {
        return Stream.of("exit", "quit", "X").anyMatch(v -> v.equalsIgnoreCase(value));
    }

    private String[] buildArgs() {
        ArrayList<String> args = new ArrayList<String>();
        if (this.serverArguments != null) {
            args.addAll(this.serverArguments);
        }
        if (this.serverArguments != null && this.serverArguments.contains("--http")) {
            if (this.port != null) {
                this.log.info("port configuration ignored since serverArguments already defines it");
            }
        } else {
            args.add("--http");
            args.add(this.findPort());
        }
        if (!args.contains("--scanning-exclude")) {
            args.add("--scanning-exclude");
            args.add("animal-sniffer-annotations,checker-qual,component-form,component-server-model,error_prone_annotations,failureaccess,freemarker,j2objc-annotations,jib-core,jsr305,listenablefuture,talend-component-maven-plugin,avro,beam,paranamer,xz,component-api,component-spi,component-runtime-impl,component-runtime-manager,component-runtime-design-extension,container-core,component-runtime-beam");
        }
        if (!args.contains("--use-shutdown-hook")) {
            args.add("--use-shutdown-hook");
            args.add("false");
        }
        return args.toArray(new String[0]);
    }

    private String findPort() {
        return this.port == null ? "8080" : Integer.toString(this.port);
    }
}

