/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.tools;

import java.io.File;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Proxy;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Objects;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.stream.Stream;
import org.apache.xbean.finder.AnnotationFinder;
import org.apache.xbean.finder.archive.Archive;
import org.apache.xbean.finder.archive.ClasspathArchive;
import org.apache.xbean.finder.archive.CompositeArchive;
import org.talend.sdk.component.api.component.Components;
import org.talend.sdk.component.api.input.Emitter;
import org.talend.sdk.component.api.input.PartitionMapper;
import org.talend.sdk.component.api.processor.Processor;

abstract class BaseTask
implements Runnable {
    protected final File[] classes;

    protected Component asComponent(Annotation a) {
        return (Component)Component.class.cast(Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{Component.class}, (proxy, method, args) -> a.annotationType().getMethod(method.getName(), new Class[0]).invoke((Object)a, new Object[0])));
    }

    protected Stream<Class<? extends Annotation>> componentMarkers() {
        return Stream.of(PartitionMapper.class, Processor.class, Emitter.class);
    }

    protected AnnotationFinder newFinder() {
        return new AnnotationFinder((Archive)new CompositeArchive((Archive[])Stream.of(this.classes).map(c -> {
            try {
                return ClasspathArchive.archive((ClassLoader)Thread.currentThread().getContextClassLoader(), (URL)c.toURI().toURL());
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException(e);
            }
        }).toArray(Archive[]::new))){
            private final Map<Class<?>, List<Field>> fieldCache;
            private final Map<Class<?>, List<Class<?>>> classCache;
            {
                this.fieldCache = new HashMap();
                this.classCache = new HashMap();
            }

            public List<Field> findAnnotatedFields(Class<? extends Annotation> annotation) {
                return this.fieldCache.computeIfAbsent(annotation, a -> super.findAnnotatedFields(annotation));
            }

            public List<Class<?>> findAnnotatedClasses(Class<? extends Annotation> annotation) {
                return this.classCache.computeIfAbsent(annotation, a -> super.findAnnotatedClasses(annotation));
            }
        };
    }

    protected Optional<Component> components(Class<?> component) {
        return this.componentMarkers().map(component::getAnnotation).filter(Objects::nonNull).findFirst().map(this::asComponent);
    }

    protected String findFamily(Component c, Class<?> pckMarker) {
        return Optional.ofNullable(c).map(Component::family).filter(name -> !name.isEmpty()).orElseGet(() -> this.findPackageOrFail(pckMarker, Components.class).getAnnotation(Components.class).family());
    }

    protected Class<?> findPackageOrFail(Class<?> component, Class<? extends Annotation> api) {
        String pck;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        String string = pck = component.getPackage() == null ? null : component.getPackage().getName();
        if (pck != null) {
            String currentPackage = pck;
            while (true) {
                try {
                    Class<?> pckInfo = loader.loadClass(currentPackage + ".package-info");
                    if (pckInfo.isAnnotationPresent(api)) {
                        return pckInfo;
                    }
                }
                catch (ClassNotFoundException pckInfo) {
                    // empty catch block
                }
                int endPreviousPackage = currentPackage.lastIndexOf(46);
                if (endPreviousPackage < 0) break;
                currentPackage = currentPackage.substring(0, endPreviousPackage);
            }
        }
        throw new IllegalArgumentException("No @" + api.getName() + " for the component " + component + ", add it in package-info.java or disable this validation (which can have side effects in integrations/designers)");
    }

    protected ResourceBundle findResourceBundle(Class<?> component) {
        String baseName = Optional.ofNullable(component.getPackage()).map(p -> p.getName() + ".").orElse("") + "Messages";
        try {
            return ResourceBundle.getBundle(baseName, this.getLocale(), Thread.currentThread().getContextClassLoader());
        }
        catch (MissingResourceException mre) {
            return null;
        }
    }

    protected Locale getLocale() {
        return Locale.ENGLISH;
    }

    BaseTask(File[] classes) {
        this.classes = classes;
    }

    public static interface Component {
        public String family();

        public String name();
    }
}

