/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.tools;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.talend.sdk.component.api.component.Components;
import org.talend.sdk.component.api.input.Emitter;
import org.talend.sdk.component.api.input.PartitionMapper;
import org.talend.sdk.component.api.processor.Processor;

public class ComponentHelper {
    public static Stream<Class<? extends Annotation>> componentMarkers() {
        return Stream.of(PartitionMapper.class, Processor.class, Emitter.class);
    }

    public static Class<?> findPackageOrFail(Class<?> component, Predicate<Class<?>> tester, String api) {
        String pck;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        String string = pck = component.getPackage() == null ? null : component.getPackage().getName();
        if (pck != null) {
            String currentPackage = pck;
            while (true) {
                try {
                    Class<?> pckInfo = loader.loadClass(currentPackage + ".package-info");
                    if (tester.test(pckInfo)) {
                        return pckInfo;
                    }
                }
                catch (ClassNotFoundException pckInfo) {
                    // empty catch block
                }
                int endPreviousPackage = currentPackage.lastIndexOf(46);
                if (endPreviousPackage < 0) break;
                currentPackage = currentPackage.substring(0, endPreviousPackage);
            }
        }
        throw new IllegalArgumentException("No @" + api + " for the component " + component + ", add it in package-info.java or disable this validation (which can have side effects in integrations/designers)");
    }

    public static Optional<Component> components(Class<?> component) {
        return ComponentHelper.componentMarkers().map(component::getAnnotation).filter(Objects::nonNull).findFirst().map(ComponentHelper::asComponent);
    }

    public static String findFamily(Component c, Class<?> pckMarker) {
        return Optional.ofNullable(c).map(Component::family).filter(name -> !name.isEmpty()).orElseGet(() -> ComponentHelper.findPackageOrFail(pckMarker, clazz -> clazz.isAnnotationPresent(Components.class), Components.class.getName()).getAnnotation(Components.class).family());
    }

    public static Component asComponent(Annotation a) {
        String family = ComponentHelper.get(a, "family");
        String name = ComponentHelper.get(a, "name");
        return new Component(family, name);
    }

    private static String get(Annotation a, String methodName) {
        try {
            Method getter = a.annotationType().getMethod(methodName, new Class[0]);
            return (String)getter.invoke((Object)a, new Object[0]);
        }
        catch (ReflectiveOperationException ex) {
            throw new RuntimeException("Can' find " + methodName + " on annotation " + a.annotationType().getName(), ex);
        }
    }

    public static class Component {
        private final String family;
        private final String name;

        public String family() {
            return this.family;
        }

        public String name() {
            return this.name;
        }

        public Component(String family, String name) {
            this.family = family;
            this.name = name;
        }
    }
}

