/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.tools;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.xbean.finder.AnnotationFinder;
import org.apache.xbean.propertyeditor.PropertyEditorRegistry;
import org.talend.sdk.component.api.component.Components;
import org.talend.sdk.component.api.component.Icon;
import org.talend.sdk.component.api.component.Version;
import org.talend.sdk.component.api.configuration.Option;
import org.talend.sdk.component.api.configuration.action.Checkable;
import org.talend.sdk.component.api.configuration.action.Proposable;
import org.talend.sdk.component.api.configuration.action.Updatable;
import org.talend.sdk.component.api.configuration.type.DataSet;
import org.talend.sdk.component.api.configuration.type.DataStore;
import org.talend.sdk.component.api.configuration.ui.DefaultValue;
import org.talend.sdk.component.api.configuration.ui.widget.Structure;
import org.talend.sdk.component.api.input.Emitter;
import org.talend.sdk.component.api.input.PartitionMapper;
import org.talend.sdk.component.api.internationalization.Internationalized;
import org.talend.sdk.component.api.meta.Documentation;
import org.talend.sdk.component.api.processor.AfterGroup;
import org.talend.sdk.component.api.processor.ElementListener;
import org.talend.sdk.component.api.processor.Output;
import org.talend.sdk.component.api.processor.Processor;
import org.talend.sdk.component.api.service.ActionType;
import org.talend.sdk.component.api.service.Service;
import org.talend.sdk.component.api.service.asyncvalidation.AsyncValidation;
import org.talend.sdk.component.api.service.completion.DynamicValues;
import org.talend.sdk.component.api.service.completion.Suggestions;
import org.talend.sdk.component.api.service.configuration.LocalConfiguration;
import org.talend.sdk.component.api.service.healthcheck.HealthCheck;
import org.talend.sdk.component.api.service.http.Request;
import org.talend.sdk.component.api.service.schema.DiscoverSchema;
import org.talend.sdk.component.api.service.update.Update;
import org.talend.sdk.component.runtime.internationalization.ParameterBundle;
import org.talend.sdk.component.runtime.manager.ParameterMeta;
import org.talend.sdk.component.runtime.manager.reflect.Constructors;
import org.talend.sdk.component.runtime.manager.reflect.IconFinder;
import org.talend.sdk.component.runtime.manager.reflect.ParameterModelService;
import org.talend.sdk.component.runtime.manager.reflect.parameterenricher.BaseParameterEnricher;
import org.talend.sdk.component.runtime.manager.service.LocalConfigurationService;
import org.talend.sdk.component.runtime.manager.service.http.HttpClientFactoryImpl;
import org.talend.sdk.component.runtime.manager.xbean.registry.EnrichedPropertyEditorRegistry;
import org.talend.sdk.component.runtime.visitor.ModelListener;
import org.talend.sdk.component.runtime.visitor.ModelVisitor;
import org.talend.sdk.component.tools.BaseTask;
import org.talend.sdk.component.tools.Log;
import org.talend.sdk.component.tools.ReflectiveLog;
import org.talend.sdk.component.tools.SvgValidator;
import org.talend.sdk.component.tools.spi.ValidationExtension;

public class ComponentValidator
extends BaseTask {
    private final Configuration configuration;
    private final Log log;
    private final ParameterModelService parameterModelService = new ParameterModelService((PropertyEditorRegistry)new EnrichedPropertyEditorRegistry());
    private final SvgValidator validator = new SvgValidator();
    private final Map<Class<?>, List<ParameterMeta>> parametersCache = new HashMap();
    private final List<ValidationExtension> extensions;

    public ComponentValidator(Configuration configuration, File[] classes, Object log) {
        super(classes);
        this.configuration = configuration;
        try {
            this.log = Log.class.isInstance(log) ? (Log)Log.class.cast(log) : new ReflectiveLog(log);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(e);
        }
        this.extensions = StreamSupport.stream(ServiceLoader.load(ValidationExtension.class).spliterator(), false).collect(Collectors.toList());
    }

    @Override
    public void run() {
        final AnnotationFinder finder = this.newFinder();
        final List<Class<?>> components = this.componentMarkers().flatMap(a -> finder.findAnnotatedClasses(a).stream()).collect(Collectors.toList());
        components.forEach(c -> this.log.debug("Found component: " + c));
        LinkedHashSet<String> errors = new LinkedHashSet<String>();
        if (this.configuration.isValidateFamily()) {
            components.forEach(c -> {
                try {
                    Icon icon = this.findPackageOrFail((Class<?>)c, this.apiTester(Icon.class), Icon.class.getName()).getAnnotation(Icon.class);
                    Optional.ofNullable(this.validateIcon(icon, errors)).ifPresent(errors::add);
                }
                catch (IllegalArgumentException iae) {
                    IconFinder iconFinder = new IconFinder();
                    try {
                        this.findPackageOrFail((Class<?>)c, it -> iconFinder.findIndirectIcon((AnnotatedElement)it).isPresent(), Icon.class.getName());
                    }
                    catch (IllegalArgumentException iae2) {
                        errors.add(iae.getMessage());
                    }
                }
            });
        }
        if (this.configuration.isValidateSerializable()) {
            ArrayList copy = new ArrayList(components);
            copy.removeIf(this::isSerializable);
            errors.addAll(copy.stream().map(c -> c + " is not Serializable").sorted().collect(ComponentValidator.toSet()));
        }
        if (this.configuration.isValidateInternationalization()) {
            this.validateInternationalization(finder, components, errors);
        }
        if (this.configuration.isValidateHttpClient()) {
            this.validateHttpClient(finder, errors);
        }
        if (this.configuration.isValidateModel()) {
            this.validateModel(finder, components, errors);
        }
        if (this.configuration.isValidateMetadata()) {
            this.validateMetadata(components, errors);
        }
        if (this.configuration.isValidateDataStore()) {
            this.validateDataStore(finder, errors);
        }
        if (this.configuration.isValidateDataSet()) {
            this.validateDataSet(finder, components, errors);
        }
        if (this.configuration.isValidateActions()) {
            this.validateActions(finder, errors);
        }
        if (this.configuration.isValidateDocumentation()) {
            this.validateDocumentation(finder, components, errors);
        }
        if (this.configuration.isValidateLayout()) {
            this.validateLayout(components, errors);
        }
        if (this.configuration.isValidateOptionNames()) {
            this.validateOptionNames(finder, errors);
        }
        if (this.configuration.isValidateLocalConfiguration()) {
            this.validateLocalConfiguration(finder, Optional.of(this.configuration).map(Configuration::getPluginId).orElseGet(this::guessPluginId), errors);
        }
        if (this.configuration.isValidateOutputConnection()) {
            this.validateOutputConnection(components, errors);
        }
        if (this.configuration.isValidatePlaceholder()) {
            this.validatePlaceholders(components, errors);
        }
        if (this.configuration.isValidateNoFinalOption()) {
            this.validateNoFinalOption(finder, errors);
        }
        if (this.configuration.isValidateWording()) {
            if (this.configuration.isValidateDocumentation()) {
                this.validateDocumentationWording(finder, components, errors);
            }
            if (this.configuration.isValidateInternationalization()) {
                this.validateInternationalizationWording(finder, components, errors);
            }
        }
        if (!this.extensions.isEmpty()) {
            ValidationExtension.ValidationContext context = new ValidationExtension.ValidationContext(){

                @Override
                public AnnotationFinder finder() {
                    return finder;
                }

                @Override
                public List<Class<?>> components() {
                    return components;
                }

                @Override
                public List<ParameterMeta> parameters(Class<?> component) {
                    return ComponentValidator.this.buildOrGetParameters(component);
                }
            };
            errors.addAll(this.extensions.stream().map(extension -> extension.validate(context)).filter(result -> result.getErrors() != null).flatMap(result -> result.getErrors().stream()).filter(Objects::nonNull).collect(Collectors.toList()));
        }
        if (!errors.isEmpty()) {
            List<String> preparedErrors = errors.stream().map(it -> it.replace("java.lang.", "").replace("java.util.", "")).collect(Collectors.toList());
            preparedErrors.forEach(this.log::error);
            throw new IllegalStateException("Some error were detected:" + preparedErrors.stream().collect(Collectors.joining("\n- ", "\n- ", "")));
        }
        this.log.info("Validated components: " + components.stream().map(Class::getSimpleName).collect(Collectors.joining(", ")));
    }

    private String guessPluginId() {
        return (String)Optional.ofNullable(this.classes).flatMap(c -> Stream.of(c).map(f -> {
            if (!f.isDirectory()) {
                return null;
            }
            int iteration = 5;
            for (File current = f; iteration-- > 0 && current != null; current = current.getParentFile()) {
                File currentRef = current;
                if (Stream.of("classes", "target", "main", "java", "build").anyMatch(it -> it.equals(currentRef.getName()))) {
                    continue;
                }
                return current.getName();
            }
            return null;
        }).filter(Objects::nonNull).findFirst()).orElseThrow(() -> new IllegalArgumentException("No pluginId set"));
    }

    private void validatePlaceholders(List<Class<?>> components, Set<String> errors) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        errors.addAll(components.stream().map(this::buildOrGetParameters).flatMap(this::flatten).filter(this::isStringifiable).filter(p -> !this.hasPlaceholder(loader, (ParameterMeta)p, null)).map(p -> "No _placeholder set for " + p.getPath() + " in Messages.properties of packages: " + Arrays.asList(p.getI18nPackages())).collect(ComponentValidator.toSet()));
    }

    private String validateIcon(Icon annotation, Collection<String> errors) {
        if (this.classes.length == 0) {
            return null;
        }
        if (annotation.value() == Icon.IconType.CUSTOM) {
            String icon = annotation.custom();
            Set svgs = Stream.of(this.classes).map(it -> new File((File)it, "icons/" + icon + ".svg")).filter(File::exists).collect(ComponentValidator.toSet());
            if (svgs.isEmpty()) {
                this.log.error("No 'icons/" + icon + ".svg' found, this will run in degraded mode in Talend Cloud");
            } else if (this.configuration.isValidateSvg()) {
                errors.addAll(svgs.stream().flatMap(this::validateSvg).collect(ComponentValidator.toSet()));
            }
            if (Stream.of(this.classes).map(it -> new File((File)it, "icons/" + icon + "_icon32.png")).noneMatch(File::exists)) {
                return "No icon: '" + icon + "' found, did you create - or generated with svg2png - 'icons/" + icon + "_icon32.png' in resources?";
            }
        }
        return null;
    }

    private Stream<String> validateSvg(File file) {
        return this.validator.validate(file.toPath());
    }

    private void validateOutputConnection(List<Class<?>> components, Set<String> errors) {
        errors.addAll(components.stream().flatMap(c -> Stream.of(c.getMethods()).filter(m -> m.isAnnotationPresent(ElementListener.class))).filter(m -> Stream.of(m.getParameters()).noneMatch(p -> p.isAnnotationPresent(Output.class))).filter(m -> Stream.of(m.getParameters()).filter(p -> !p.isAnnotationPresent(Output.class)).count() > 1L).map(Method::getDeclaringClass).distinct().map(clazz -> "The Output component '" + clazz + "' must have only one single input branch parameter in its ElementListener method.").collect(Collectors.toList()));
    }

    private void validateLocalConfiguration(AnnotationFinder finder, String pluginId, Set<String> errors) {
        errors.addAll(Stream.of(this.classes).map(root -> new File((File)root, "TALEND-INF/local-configuration.properties")).filter(File::exists).flatMap(props -> {
            Properties properties = new Properties();
            try (BufferedInputStream stream = new BufferedInputStream(new FileInputStream((File)props));){
                properties.load(stream);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
            return properties.stringPropertyNames().stream().filter(it -> !it.toLowerCase(Locale.ROOT).startsWith(pluginId + ".")).map(it -> "'" + it + "' does not start with '" + pluginId + "', it is recommended to prefix all keys by the family");
        }).collect(ComponentValidator.toSet()));
        errors.addAll(Stream.concat(finder.findAnnotatedFields(DefaultValue.class).stream(), finder.findAnnotatedConstructorParameters(DefaultValue.class).stream()).map(d -> {
            DefaultValue annotation = d.getAnnotation(DefaultValue.class);
            if (annotation.value().startsWith("local_configuration:") && !annotation.value().toLowerCase(Locale.ROOT).startsWith("local_configuration:" + pluginId + ".")) {
                return d + " does not start with family name (followed by a dot): '" + pluginId + "'";
            }
            return null;
        }).filter(Objects::nonNull).collect(ComponentValidator.toSet()));
    }

    private void validateLayout(List<Class<?>> components, Set<String> errors) {
        components.stream().map(this::buildOrGetParameters).flatMap(this::toFlatNonPrimitiveConfig).collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue, (p1, p2) -> p1)).entrySet().forEach(c -> this.visitLayout((Map.Entry<String, ParameterMeta>)c, errors));
    }

    private void visitLayout(Map.Entry<String, ParameterMeta> config, Set<String> errors) {
        Set fieldsInGridLayout = config.getValue().getMetadata().entrySet().stream().filter(meta -> ((String)meta.getKey()).startsWith("tcomp::ui::gridlayout")).flatMap(meta -> Stream.of(((String)meta.getValue()).split("\\|"))).flatMap(s -> Stream.of(s.split(","))).filter(s -> !s.isEmpty()).sorted().collect(ComponentValidator.toSet());
        Set fieldsInOptionOrder = config.getValue().getMetadata().entrySet().stream().filter(meta -> ((String)meta.getKey()).startsWith("tcomp::ui::optionsorder")).flatMap(meta -> Stream.of(((String)meta.getValue()).split(","))).sorted().collect(ComponentValidator.toSet());
        if (fieldsInGridLayout.isEmpty() && fieldsInOptionOrder.isEmpty()) {
            return;
        }
        if (!fieldsInGridLayout.isEmpty() && !fieldsInOptionOrder.isEmpty()) {
            this.log.error("Concurrent layout found for '" + config.getKey() + "', the @OptionsOrder will be ignored.");
        }
        if (!fieldsInGridLayout.isEmpty()) {
            errors.addAll(fieldsInGridLayout.stream().filter(fieldInLayout -> ((ParameterMeta)config.getValue()).getNestedParameters().stream().map(ParameterMeta::getName).noneMatch(field -> field.equals(fieldInLayout))).map(fieldInLayout -> "Option '" + fieldInLayout + "' in @GridLayout doesn't exist in declaring class '" + (String)config.getKey() + "'").sorted().collect(ComponentValidator.toSet()));
            config.getValue().getNestedParameters().stream().filter(field -> !fieldsInGridLayout.contains(field.getName())).map(field -> "Field '" + field.getName() + "' in " + (String)config.getKey() + " is not declared in any layout.").forEach(this.log::error);
        } else {
            errors.addAll(fieldsInOptionOrder.stream().filter(fieldInLayout -> ((ParameterMeta)config.getValue()).getNestedParameters().stream().map(ParameterMeta::getName).noneMatch(field -> field.equals(fieldInLayout))).map(fieldInLayout -> "Option '" + fieldInLayout + "' in @OptionOrder doesn't exist in declaring class '" + (String)config.getKey() + "'").sorted().collect(ComponentValidator.toSet()));
            config.getValue().getNestedParameters().stream().filter(field -> !fieldsInOptionOrder.contains(field.getName())).map(field -> "Field '" + field.getName() + "' in " + (String)config.getKey() + " is not declared in any layout.").forEach(this.log::error);
        }
    }

    private boolean hasPlaceholder(ClassLoader loader, ParameterMeta parameterMeta, ParameterBundle parent) {
        return parameterMeta.findBundle(loader, Locale.ROOT).placeholder(parent).isPresent();
    }

    private List<ParameterMeta> buildOrGetParameters(Class<?> c) {
        return this.parametersCache.computeIfAbsent(c, k -> this.parameterModelService.buildParameterMetas((Executable)Constructors.findConstructor((Class)c), Optional.ofNullable(c.getPackage()).map(Package::getName).orElse(""), new BaseParameterEnricher.Context((LocalConfiguration)new LocalConfigurationService(Collections.emptyList(), "tools"))));
    }

    private boolean isStringifiable(ParameterMeta meta) {
        return ParameterMeta.Type.STRING.equals((Object)meta.getType()) || ParameterMeta.Type.ENUM.equals((Object)meta.getType());
    }

    private Stream<AbstractMap.SimpleEntry<String, ParameterMeta>> toFlatNonPrimitiveConfig(List<ParameterMeta> config) {
        if (config == null || config.isEmpty()) {
            return Stream.empty();
        }
        return config.stream().filter(Objects::nonNull).filter(p -> ParameterMeta.Type.OBJECT.equals((Object)p.getType()) || this.isArrayOfObject((ParameterMeta)p)).filter(p -> p.getNestedParameters() != null).flatMap(p -> Stream.concat(Stream.of(new AbstractMap.SimpleEntry<String, ParameterMeta>(this.toJavaType((ParameterMeta)p).getName(), (ParameterMeta)p)), this.toFlatNonPrimitiveConfig(p.getNestedParameters())));
    }

    private Class<?> toJavaType(ParameterMeta p) {
        if (p.getType().equals((Object)ParameterMeta.Type.OBJECT) || p.getType().equals((Object)ParameterMeta.Type.ENUM)) {
            if (Class.class.isInstance(p.getJavaType())) {
                return (Class)Class.class.cast(p.getJavaType());
            }
            throw new IllegalArgumentException("Unsupported type for parameter " + p.getPath() + " (from " + p.getSource().declaringClass() + "), ensure it is a Class<?>");
        }
        if (p.getType().equals((Object)ParameterMeta.Type.ARRAY) && ParameterizedType.class.isInstance(p.getJavaType())) {
            ParameterizedType parameterizedType = (ParameterizedType)ParameterizedType.class.cast(p.getJavaType());
            Type[] arguments = parameterizedType.getActualTypeArguments();
            if (arguments.length == 1 && Class.class.isInstance(arguments[0])) {
                return (Class)Class.class.cast(arguments[0]);
            }
            throw new IllegalArgumentException("Unsupported type for parameter " + p.getPath() + " (from " + p.getSource().declaringClass() + "), ensure it is a ParameterizedType with one argument");
        }
        throw new IllegalStateException("Parameter '" + p.getName() + "' is not an object.");
    }

    private boolean isArrayOfObject(ParameterMeta param) {
        return ParameterMeta.Type.ARRAY.equals((Object)param.getType()) && param.getNestedParameters() != null && param.getNestedParameters().stream().anyMatch(p -> ParameterMeta.Type.OBJECT.equals((Object)p.getType()) || ParameterMeta.Type.ENUM.equals((Object)p.getType()) || this.isArrayOfObject((ParameterMeta)p));
    }

    private void validateOptionNames(AnnotationFinder finder, Set<String> errors) {
        errors.addAll(this.findOptions(finder).filter(field -> {
            String name = field.getAnnotation(Option.class).value();
            return name.contains(".") || name.startsWith("$");
        }).distinct().map(field -> {
            String name = field.getAnnotation(Option.class).value();
            return "Option name `" + name + "` is invalid, you can't start an option name with a '$' and it can't contain a '.'. Please fix it on field `" + field.getDeclaringClass().getName() + "#" + field.getName() + "`";
        }).sorted().collect(ComponentValidator.toSet()));
    }

    private void validateNoFinalOption(AnnotationFinder finder, Set<String> errors) {
        errors.addAll(this.findOptions(finder).filter(field -> Modifier.isFinal(field.getModifiers())).distinct().map(field -> "@Option fields must not be final, found one field violating this rule: " + field).sorted().collect(ComponentValidator.toSet()));
    }

    private void validateDocumentation(AnnotationFinder finder, List<Class<?>> components, Set<String> errors) {
        errors.addAll(components.stream().filter(c -> !c.isAnnotationPresent(Documentation.class)).map(c -> "No @Documentation on '" + c.getName() + "'").sorted().collect(ComponentValidator.toSet()));
        errors.addAll(this.findOptions(finder).filter(field -> !field.isAnnotationPresent(Documentation.class) && !field.getType().isAnnotationPresent(Documentation.class)).map(field -> "No @Documentation on '" + field + "'").sorted().collect(ComponentValidator.toSet()));
    }

    private void validateDocumentationWording(AnnotationFinder finder, List<Class<?>> components, Set<String> errors) {
        Predicate<String> isIncorrectWording = s -> !s.matches("^[A-Z0-9]+.*\\.$");
        String error = "@Documentation on '%s' is empty or is not capitalized or ends not by a dot.";
        errors.addAll(components.stream().filter(c -> c.isAnnotationPresent(Documentation.class)).filter(c -> isIncorrectWording.test(c.getAnnotation(Documentation.class).value())).map(c -> String.format("@Documentation on '%s' is empty or is not capitalized or ends not by a dot.", c.getName())).sorted().collect(ComponentValidator.toSet()));
        errors.addAll(this.findOptions(finder).filter(field -> field.isAnnotationPresent(Documentation.class)).filter(c -> isIncorrectWording.test(c.getAnnotation(Documentation.class).value())).map(c -> String.format("@Documentation on '%s' is empty or is not capitalized or ends not by a dot.", c.getName())).sorted().collect(ComponentValidator.toSet()));
    }

    private void validateInternationalization(AnnotationFinder finder, List<Class<?>> components, Set<String> errors) {
        errors.addAll(components.stream().map(this::validateComponentResourceBundle).filter(Objects::nonNull).sorted().collect(ComponentValidator.toSet()));
        errors.addAll(this.findOptions(finder).map(Field::getType).filter(Class::isEnum).distinct().flatMap(enumType -> Stream.of(enumType.getFields()).filter(f -> Modifier.isStatic(f.getModifiers()) && Modifier.isFinal(f.getModifiers())).filter(f -> this.hasBundleEntry((Class<?>)enumType, (Field)f, "_displayName")).map(f -> "Missing key " + enumType.getSimpleName() + "." + f.getName() + "._displayName in " + enumType + " resource bundle")).sorted().collect(ComponentValidator.toSet()));
        List missingOptionTranslations = this.findOptions(finder).distinct().filter(field -> {
            ResourceBundle bundle = Optional.ofNullable(this.findResourceBundle(field.getDeclaringClass())).orElseGet(() -> this.findResourceBundle(field.getType()));
            String key = field.getDeclaringClass().getSimpleName() + "." + field.getName() + "._displayName";
            return bundle == null || !bundle.containsKey(key);
        }).map(f -> " " + f.getDeclaringClass().getSimpleName() + "." + f.getName() + "._displayName = <" + f.getName() + ">").sorted().collect(Collectors.toList());
        if (!missingOptionTranslations.isEmpty()) {
            errors.add(missingOptionTranslations.stream().distinct().collect(Collectors.joining("\n", "Missing resource bundle entries:\n", "")));
        }
        for (Class i : finder.findAnnotatedClasses(Internationalized.class)) {
            ResourceBundle resourceBundle = this.findResourceBundle(i);
            if (resourceBundle != null) {
                Collection keys = Stream.of(i.getMethods()).filter(m -> m.getDeclaringClass() != Object.class).map(m -> Arrays.asList(i.getName() + "." + m.getName(), i.getSimpleName() + "." + m.getName())).collect(Collectors.toSet());
                errors.addAll(keys.stream().filter(ks -> ks.stream().noneMatch(resourceBundle::containsKey)).map(k -> "Missing key " + (String)k.iterator().next() + " in " + i + " resource bundle").sorted().collect(ComponentValidator.toSet()));
                errors.addAll(resourceBundle.keySet().stream().filter(k -> (k.startsWith(i.getName() + ".") || k.startsWith(i.getSimpleName() + ".")) && keys.stream().noneMatch(ks -> ks.contains(k))).map(k -> "Key " + k + " from " + i + " is no more used").sorted().collect(ComponentValidator.toSet()));
                continue;
            }
            errors.add("No resource bundle for " + i);
        }
        errors.addAll(this.getActionsStream().flatMap(action -> finder.findAnnotatedMethods(action).stream()).map(action -> {
            String key;
            Annotation actionAnnotation = Stream.of(action.getAnnotations()).filter(a -> a.annotationType().isAnnotationPresent(ActionType.class)).findFirst().orElseThrow(() -> new IllegalArgumentException("No action annotation on " + action));
            try {
                Class<? extends Annotation> annotationType = actionAnnotation.annotationType();
                key = "${family}.actions." + annotationType.getAnnotation(ActionType.class).value() + "." + annotationType.getMethod("value", new Class[0]).invoke((Object)actionAnnotation, new Object[0]).toString() + "._displayName";
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                return null;
            }
            return this.validateFamilyI18nKey(action.getDeclaringClass(), key);
        }).filter(Objects::nonNull).collect(ComponentValidator.toSet()));
    }

    private void validateInternationalizationWording(AnnotationFinder finder, List<Class<?>> components, Set<String> errors) {
    }

    private void validateHttpClient(AnnotationFinder finder, Set<String> errors) {
        errors.addAll(finder.findAnnotatedClasses(Request.class).stream().map(Class::getDeclaringClass).distinct().flatMap(c -> HttpClientFactoryImpl.createErrors((Class)c).stream()).sorted().collect(ComponentValidator.toSet()));
    }

    private void validateModel(AnnotationFinder finder, List<Class<?>> components, Set<String> errors) {
        errors.addAll(components.stream().filter(c -> this.componentMarkers().filter(c::isAnnotationPresent).count() > 1L).map(i -> i + " has conflicting component annotations, ensure it has a single one").sorted().collect(ComponentValidator.toSet()));
        errors.addAll(components.stream().filter(c -> this.countParameters(Constructors.findConstructor((Class)c).getParameters()) > 1).map(c -> "Component must use a single root option. '" + c.getName() + "'").sorted().collect(ComponentValidator.toSet()));
        ModelVisitor modelVisitor = new ModelVisitor();
        ModelListener noop = new ModelListener(){};
        errors.addAll(components.stream().map(c -> {
            try {
                modelVisitor.visit(c, noop, this.configuration.isValidateComponent());
                return null;
            }
            catch (RuntimeException re) {
                return re.getMessage();
            }
        }).filter(Objects::nonNull).sorted().collect(ComponentValidator.toSet()));
        errors.addAll(finder.findAnnotatedFields(Structure.class).stream().filter(f -> !ParameterizedType.class.isInstance(f.getGenericType()) || !this.isListString((Field)f) && !this.isMapString((Field)f)).map(f -> f.getDeclaringClass() + "#" + f.getName() + " uses @Structure but is not a List<String> nor a Map<String, String>").sorted().collect(ComponentValidator.toSet()));
    }

    private Stream<Field> findOptions(AnnotationFinder finder) {
        return finder.findAnnotatedFields(Option.class).stream();
    }

    private boolean isMapString(Field f) {
        ParameterizedType pt = (ParameterizedType)ParameterizedType.class.cast(f.getGenericType());
        return Map.class == pt.getRawType() && pt.getActualTypeArguments().length == 2 && pt.getActualTypeArguments()[0] == String.class && pt.getActualTypeArguments()[1] == String.class;
    }

    private boolean isListString(Field f) {
        ParameterizedType pt = (ParameterizedType)ParameterizedType.class.cast(f.getGenericType());
        return (List.class == pt.getRawType() || Collection.class == pt.getRawType()) && pt.getActualTypeArguments().length == 1 && pt.getActualTypeArguments()[0] == String.class;
    }

    private void validateMetadata(List<Class<?>> components, Set<String> errors) {
        errors.addAll(components.stream().flatMap(component -> {
            ArrayList<String> messages = null;
            IconFinder iconFinder = new IconFinder();
            if (iconFinder.findDirectIcon((AnnotatedElement)component).isPresent()) {
                Icon icon = component.getAnnotation(Icon.class);
                messages = new ArrayList<String>();
                messages.add(this.validateIcon(icon, errors));
            } else if (!iconFinder.findIndirectIcon((AnnotatedElement)component).isPresent()) {
                messages = new ArrayList<String>(Collections.singleton("No @Icon on " + component));
            }
            if (!component.isAnnotationPresent(Version.class)) {
                if (messages == null) {
                    messages = new ArrayList();
                }
                messages.add("Component " + component + " should use @Icon and @Version");
            }
            return messages == null ? Stream.empty() : messages.stream();
        }).filter(Objects::nonNull).sorted().collect(ComponentValidator.toSet()));
    }

    private void validateDataStore(AnnotationFinder finder, Set<String> errors) {
        List datastoreClasses = finder.findAnnotatedClasses(DataStore.class);
        List datastores = datastoreClasses.stream().map(d -> d.getAnnotation(DataStore.class).value()).collect(Collectors.toList());
        HashSet uniqueDatastores = new HashSet(datastores);
        if (datastores.size() != uniqueDatastores.size()) {
            errors.add("Duplicated DataStore found : " + datastores.stream().collect(Collectors.groupingBy(Function.identity())).entrySet().stream().filter(e -> ((List)e.getValue()).size() > 1).map(Map.Entry::getKey).collect(Collectors.joining(", ")));
        }
        List checkableClasses = finder.findAnnotatedClasses(Checkable.class);
        errors.addAll(checkableClasses.stream().filter(d -> !d.isAnnotationPresent(DataStore.class)).map(c -> c.getName() + " has @Checkable but is not a @DataStore").sorted().collect(ComponentValidator.toSet()));
        Map<String, String> checkableDataStoresMap = checkableClasses.stream().filter(d -> d.isAnnotationPresent(DataStore.class)).collect(Collectors.toMap(d -> d.getAnnotation(DataStore.class).value(), d -> d.getAnnotation(Checkable.class).value()));
        Set healthchecks = finder.findAnnotatedMethods(HealthCheck.class).stream().filter(h -> h.getDeclaringClass().isAnnotationPresent(Service.class)).map(m -> m.getAnnotation(HealthCheck.class).value()).sorted().collect(ComponentValidator.toSet());
        errors.addAll(checkableDataStoresMap.entrySet().stream().filter(e -> !healthchecks.contains(e.getValue())).map(e -> "No @HealthCheck for dataStore: '" + (String)e.getKey() + "' with checkable: '" + (String)e.getValue() + "'").sorted().collect(ComponentValidator.toSet()));
        errors.addAll(datastoreClasses.stream().map(clazz -> this.validateFamilyI18nKey((Class<?>)clazz, "${family}.datastore." + clazz.getAnnotation(DataStore.class).value() + "._displayName")).filter(Objects::nonNull).collect(Collectors.toList()));
    }

    private void validateDataSet(AnnotationFinder finder, List<Class<?>> components, Set<String> errors) {
        List datasetClasses = finder.findAnnotatedClasses(DataSet.class);
        Map datasets = datasetClasses.stream().collect(Collectors.toMap(Function.identity(), d -> d.getAnnotation(DataSet.class).value()));
        HashSet<String> uniqueDatasets = new HashSet<String>(datasets.values());
        if (datasets.size() != uniqueDatasets.size()) {
            errors.add("Duplicated DataSet found : " + datasets.values().stream().collect(Collectors.groupingBy(Function.identity())).entrySet().stream().filter(e -> ((List)e.getValue()).size() > 1).map(Map.Entry::getKey).collect(Collectors.joining(", ")));
        }
        errors.addAll(datasets.entrySet().stream().map(entry -> this.validateFamilyI18nKey((Class)entry.getKey(), "${family}.dataset." + (String)entry.getValue() + "._displayName")).filter(Objects::nonNull).collect(Collectors.toList()));
        BaseParameterEnricher.Context context = new BaseParameterEnricher.Context((LocalConfiguration)new LocalConfigurationService(Collections.emptyList(), "tools"));
        Map componentNeedingADataSet = components.stream().filter(c -> this.isSource((Class<?>)c) || this.isOutput((Class<?>)c)).collect(Collectors.toMap(Function.identity(), c -> this.parameterModelService.buildParameterMetas((Executable)Constructors.findConstructor((Class)c), Optional.ofNullable(c.getPackage()).map(Package::getName).orElse(""), context)));
        Map<Class, Collection> inputs = componentNeedingADataSet.entrySet().stream().filter(it -> this.isSource((Class)it.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        errors.addAll(datasets.entrySet().stream().filter(dataset -> inputs.isEmpty() || inputs.entrySet().stream().allMatch(input -> {
            Collection allProps = this.flatten((Collection)input.getValue()).collect(Collectors.toList());
            Collection datasetProperties = this.findNestedDataSets(allProps, (String)dataset.getValue()).collect(Collectors.toList());
            return !datasetProperties.isEmpty() && allProps.stream().filter(it -> datasetProperties.stream().noneMatch(dit -> it.getPath().equals(dit.getPath()) || it.getPath().startsWith(dit.getPath() + '.'))).anyMatch(this::isRequired);
        })).map(dataset -> "No source instantiable without adding parameters for @DataSet(\"" + (String)dataset.getValue() + "\") (" + ((Class)dataset.getKey()).getName() + "), please ensure at least a source using this dataset can be used just filling the dataset information.").sorted().collect(ComponentValidator.toSet()));
        errors.addAll(componentNeedingADataSet.entrySet().stream().filter(it -> this.flatten((Collection)it.getValue()).noneMatch(prop -> "dataset".equals(prop.getMetadata().get("tcomp::configurationtype::type")))).map(it -> "The component " + ((Class)it.getKey()).getName() + " is missing a dataset in its configuration (see @DataSet)").sorted().collect(ComponentValidator.toSet()));
        errors.addAll(datasetClasses.stream().map(ds -> {
            List dataset = this.parameterModelService.buildParameterMetas(Stream.of(new ParameterModelService.Param((Type)ds, ds.getAnnotations(), "dataset")), ds, Optional.ofNullable(ds.getPackage()).map(Package::getName).orElse(""), true, context);
            if (this.flatten(dataset).noneMatch(prop -> "datastore".equals(prop.getMetadata().get("tcomp::configurationtype::type")))) {
                return "The dataset " + ds.getName() + " is missing a datastore reference in its configuration (see @DataStore)";
            }
            return null;
        }).filter(Objects::nonNull).sorted().collect(ComponentValidator.toSet()));
    }

    private boolean hasBundleEntry(Class<?> enumType, Field f, String keyName) {
        ResourceBundle bundle = this.findBundleFor(enumType, f);
        String key = enumType.getSimpleName() + "." + f.getName() + "." + keyName;
        return bundle == null || !bundle.containsKey(key);
    }

    private ResourceBundle findBundleFor(Class<?> enumType, Field f) {
        return Optional.ofNullable(this.findResourceBundle(enumType)).orElseGet(() -> this.findResourceBundle(f.getDeclaringClass()));
    }

    private boolean isRequired(ParameterMeta parameterMeta) {
        return Boolean.parseBoolean(parameterMeta.getMetadata().getOrDefault("tcomp::validation::required", "false"));
    }

    private boolean isSource(Class<?> component) {
        return component.isAnnotationPresent(PartitionMapper.class) || component.isAnnotationPresent(Emitter.class);
    }

    private boolean isOutput(Class<?> component) {
        return component.isAnnotationPresent(Processor.class) && Stream.of(component.getMethods()).filter(it -> it.isAnnotationPresent(ElementListener.class) || it.isAnnotationPresent(AfterGroup.class)).allMatch(it -> Void.TYPE == it.getReturnType() && Stream.of(it.getParameters()).noneMatch(param -> param.isAnnotationPresent(Output.class)));
    }

    private Stream<ParameterMeta> findNestedDataSets(Collection<ParameterMeta> options, String name) {
        return options.stream().filter(it -> "dataset".equals(it.getMetadata().get("tcomp::configurationtype::type")) && name.equals(it.getMetadata().get("tcomp::configurationtype::name")));
    }

    private Stream<ParameterMeta> flatten(Collection<ParameterMeta> options) {
        return options.stream().flatMap(it -> Stream.concat(Stream.of(it), it.getNestedParameters().isEmpty() ? Stream.empty() : this.flatten(it.getNestedParameters())));
    }

    private String validateFamilyI18nKey(Class<?> clazz, String ... keys) {
        Class<?> pck = this.findPackageOrFail(clazz, this.apiTester(Components.class), Components.class.getName());
        String family = pck.getAnnotation(Components.class).family();
        String baseName = Optional.ofNullable(pck.getPackage()).map(p -> p.getName() + ".").orElse("") + "Messages";
        ResourceBundle bundle = this.findResourceBundle(pck);
        if (bundle == null) {
            return "No resource bundle for " + clazz.getName() + " translations, you should create a " + baseName.replace('.', '/') + ".properties at least.";
        }
        Collection missingKeys = Stream.of(keys).map(key -> key.replace("${family}", family)).filter(k -> !bundle.containsKey((String)k)).collect(Collectors.toList());
        if (!missingKeys.isEmpty()) {
            return baseName + " is missing the key(s): " + String.join((CharSequence)"\n", missingKeys);
        }
        return null;
    }

    private void validateActions(AnnotationFinder finder, Set<String> errors) {
        errors.addAll(this.getActionsStream().flatMap(action -> {
            Class returnedType = action.getAnnotation(ActionType.class).expectedReturnedType();
            List annotatedMethods = finder.findAnnotatedMethods(action);
            return Stream.concat(annotatedMethods.stream().filter(m -> !returnedType.isAssignableFrom(m.getReturnType())).map(m -> m + " doesn't return a " + returnedType + ", please fix it"), annotatedMethods.stream().filter(m -> !m.getDeclaringClass().isAnnotationPresent(Service.class) && !Modifier.isAbstract(m.getDeclaringClass().getModifiers())).map(m -> m + " is not declared into a service class"));
        }).sorted().collect(ComponentValidator.toSet()));
        errors.addAll(finder.findAnnotatedMethods(DynamicValues.class).stream().filter(m -> this.countParameters((Method)m) != 0).map(m -> m + " should have no parameter").sorted().collect(ComponentValidator.toSet()));
        errors.addAll(finder.findAnnotatedMethods(HealthCheck.class).stream().filter(m -> this.countParameters((Method)m) != 1 || !m.getParameterTypes()[0].isAnnotationPresent(DataStore.class)).map(m -> m + " should have its first parameter being a datastore (marked with @DataStore)").sorted().collect(ComponentValidator.toSet()));
        errors.addAll(finder.findAnnotatedMethods(DiscoverSchema.class).stream().filter(m -> this.countParameters((Method)m) != 1 || !m.getParameterTypes()[0].isAnnotationPresent(DataSet.class)).map(m -> m + " should have its first parameter being a dataset (marked with @DataSet)").sorted().collect(ComponentValidator.toSet()));
        Map updates = finder.findAnnotatedMethods(Update.class).stream().collect(Collectors.toMap(m -> m.getAnnotation(Update.class).value(), Function.identity()));
        errors.addAll(updates.values().stream().filter(m -> this.isPrimitiveLike(m.getReturnType())).map(m -> m + " should return an object").sorted().collect(ComponentValidator.toSet()));
        List updatableFields = finder.findAnnotatedFields(Updatable.class);
        errors.addAll(updatableFields.stream().filter(f -> f.getAnnotation(Updatable.class).after().contains(".")).map(f -> "@Updatable.after should only reference direct child primitive fields").sorted().collect(ComponentValidator.toSet()));
        errors.addAll(updatableFields.stream().filter(f -> this.isPrimitiveLike(f.getType())).map(f -> "@Updatable should not be used on primitives: " + f).sorted().collect(ComponentValidator.toSet()));
        errors.addAll(updatableFields.stream().map(f -> {
            Method service = (Method)updates.get(f.getAnnotation(Updatable.class).value());
            if (service == null) {
                return null;
            }
            if (f.getType().isAssignableFrom(service.getReturnType())) {
                return null;
            }
            return "@Updatable field '" + f + "' does not match returned type of '" + service + "'";
        }).filter(Objects::nonNull).sorted().collect(ComponentValidator.toSet()));
        errors.addAll(updatableFields.stream().filter(f -> updates.get(f.getAnnotation(Updatable.class).value()) == null).map(f -> "No @Update service found for field " + f + ", did you intend to use @Updatable?").sorted().collect(ComponentValidator.toSet()));
        errors.addAll(finder.findAnnotatedFields(Proposable.class).stream().filter(f -> f.getType().isEnum()).map(f -> f.toString() + " must not define @Proposable since it is an enum").sorted().collect(ComponentValidator.toSet()));
        Set proposables = finder.findAnnotatedFields(Proposable.class).stream().map(f -> f.getAnnotation(Proposable.class).value()).sorted().collect(ComponentValidator.toSet());
        Set dynamicValues = finder.findAnnotatedMethods(DynamicValues.class).stream().map(f -> f.getAnnotation(DynamicValues.class).value()).sorted().collect(ComponentValidator.toSet());
        proposables.removeAll(dynamicValues);
        errors.addAll(proposables.stream().map(p -> "No @DynamicValues(\"" + p + "\"), add a service with this method: @DynamicValues(\"" + p + "\") Values proposals();").sorted().collect(ComponentValidator.toSet()));
    }

    private Stream<Class<? extends Annotation>> getActionsStream() {
        return Stream.of(AsyncValidation.class, DynamicValues.class, HealthCheck.class, DiscoverSchema.class, Suggestions.class, Update.class);
    }

    private boolean isPrimitiveLike(Class<?> type) {
        return type.isPrimitive() || type == String.class;
    }

    private int countParameters(Method m) {
        return this.countParameters(m.getParameters());
    }

    private int countParameters(Parameter[] params) {
        return (int)Stream.of(params).filter(p -> !this.parameterModelService.isService(new ParameterModelService.Param(p))).count();
    }

    private String validateComponentResourceBundle(Class<?> component) {
        String baseName = Optional.ofNullable(component.getPackage()).map(p -> p.getName() + ".").orElse("") + "Messages";
        ResourceBundle bundle = this.findResourceBundle(component);
        if (bundle == null) {
            return "No resource bundle for " + component.getName() + ", you should create a " + baseName.replace('.', '/') + ".properties at least.";
        }
        String prefix = this.components(component).map(c -> this.findFamily((BaseTask.Component)c, component) + "." + c.name()).orElseThrow(() -> new IllegalStateException(component.getName()));
        Collection missingKeys = Stream.of("_displayName").map(n -> prefix + "." + n).filter(k -> !bundle.containsKey((String)k)).collect(Collectors.toList());
        if (!missingKeys.isEmpty()) {
            return baseName + " is missing the key(s): " + String.join((CharSequence)"\n", missingKeys);
        }
        return null;
    }

    private boolean isSerializable(Class<?> aClass) {
        return Serializable.class.isAssignableFrom(aClass);
    }

    private static <T> Collector<T, ?, Set<T>> toSet() {
        return Collectors.toCollection(TreeSet::new);
    }

    public static class Configuration {
        private boolean validateFamily;
        private boolean validateSerializable;
        private boolean validateInternationalization;
        private boolean validateHttpClient;
        private boolean validateModel;
        private boolean validateMetadata;
        private boolean validateComponent;
        private boolean validateDataStore;
        private boolean validateDataSet;
        private boolean validateActions;
        private boolean validateDocumentation;
        private boolean validateWording;
        private boolean validateLayout;
        private boolean validateOptionNames;
        private boolean validateLocalConfiguration;
        private boolean validateOutputConnection;
        private boolean validatePlaceholder;
        private boolean validateSvg;
        private boolean validateNoFinalOption;
        private String pluginId;

        public boolean isValidateFamily() {
            return this.validateFamily;
        }

        public boolean isValidateSerializable() {
            return this.validateSerializable;
        }

        public boolean isValidateInternationalization() {
            return this.validateInternationalization;
        }

        public boolean isValidateHttpClient() {
            return this.validateHttpClient;
        }

        public boolean isValidateModel() {
            return this.validateModel;
        }

        public boolean isValidateMetadata() {
            return this.validateMetadata;
        }

        public boolean isValidateComponent() {
            return this.validateComponent;
        }

        public boolean isValidateDataStore() {
            return this.validateDataStore;
        }

        public boolean isValidateDataSet() {
            return this.validateDataSet;
        }

        public boolean isValidateActions() {
            return this.validateActions;
        }

        public boolean isValidateDocumentation() {
            return this.validateDocumentation;
        }

        public boolean isValidateWording() {
            return this.validateWording;
        }

        public boolean isValidateLayout() {
            return this.validateLayout;
        }

        public boolean isValidateOptionNames() {
            return this.validateOptionNames;
        }

        public boolean isValidateLocalConfiguration() {
            return this.validateLocalConfiguration;
        }

        public boolean isValidateOutputConnection() {
            return this.validateOutputConnection;
        }

        public boolean isValidatePlaceholder() {
            return this.validatePlaceholder;
        }

        public boolean isValidateSvg() {
            return this.validateSvg;
        }

        public boolean isValidateNoFinalOption() {
            return this.validateNoFinalOption;
        }

        public String getPluginId() {
            return this.pluginId;
        }

        public void setValidateFamily(boolean validateFamily) {
            this.validateFamily = validateFamily;
        }

        public void setValidateSerializable(boolean validateSerializable) {
            this.validateSerializable = validateSerializable;
        }

        public void setValidateInternationalization(boolean validateInternationalization) {
            this.validateInternationalization = validateInternationalization;
        }

        public void setValidateHttpClient(boolean validateHttpClient) {
            this.validateHttpClient = validateHttpClient;
        }

        public void setValidateModel(boolean validateModel) {
            this.validateModel = validateModel;
        }

        public void setValidateMetadata(boolean validateMetadata) {
            this.validateMetadata = validateMetadata;
        }

        public void setValidateComponent(boolean validateComponent) {
            this.validateComponent = validateComponent;
        }

        public void setValidateDataStore(boolean validateDataStore) {
            this.validateDataStore = validateDataStore;
        }

        public void setValidateDataSet(boolean validateDataSet) {
            this.validateDataSet = validateDataSet;
        }

        public void setValidateActions(boolean validateActions) {
            this.validateActions = validateActions;
        }

        public void setValidateDocumentation(boolean validateDocumentation) {
            this.validateDocumentation = validateDocumentation;
        }

        public void setValidateWording(boolean validateWording) {
            this.validateWording = validateWording;
        }

        public void setValidateLayout(boolean validateLayout) {
            this.validateLayout = validateLayout;
        }

        public void setValidateOptionNames(boolean validateOptionNames) {
            this.validateOptionNames = validateOptionNames;
        }

        public void setValidateLocalConfiguration(boolean validateLocalConfiguration) {
            this.validateLocalConfiguration = validateLocalConfiguration;
        }

        public void setValidateOutputConnection(boolean validateOutputConnection) {
            this.validateOutputConnection = validateOutputConnection;
        }

        public void setValidatePlaceholder(boolean validatePlaceholder) {
            this.validatePlaceholder = validatePlaceholder;
        }

        public void setValidateSvg(boolean validateSvg) {
            this.validateSvg = validateSvg;
        }

        public void setValidateNoFinalOption(boolean validateNoFinalOption) {
            this.validateNoFinalOption = validateNoFinalOption;
        }

        public void setPluginId(String pluginId) {
            this.pluginId = pluginId;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Configuration)) {
                return false;
            }
            Configuration other = (Configuration)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isValidateFamily() != other.isValidateFamily()) {
                return false;
            }
            if (this.isValidateSerializable() != other.isValidateSerializable()) {
                return false;
            }
            if (this.isValidateInternationalization() != other.isValidateInternationalization()) {
                return false;
            }
            if (this.isValidateHttpClient() != other.isValidateHttpClient()) {
                return false;
            }
            if (this.isValidateModel() != other.isValidateModel()) {
                return false;
            }
            if (this.isValidateMetadata() != other.isValidateMetadata()) {
                return false;
            }
            if (this.isValidateComponent() != other.isValidateComponent()) {
                return false;
            }
            if (this.isValidateDataStore() != other.isValidateDataStore()) {
                return false;
            }
            if (this.isValidateDataSet() != other.isValidateDataSet()) {
                return false;
            }
            if (this.isValidateActions() != other.isValidateActions()) {
                return false;
            }
            if (this.isValidateDocumentation() != other.isValidateDocumentation()) {
                return false;
            }
            if (this.isValidateWording() != other.isValidateWording()) {
                return false;
            }
            if (this.isValidateLayout() != other.isValidateLayout()) {
                return false;
            }
            if (this.isValidateOptionNames() != other.isValidateOptionNames()) {
                return false;
            }
            if (this.isValidateLocalConfiguration() != other.isValidateLocalConfiguration()) {
                return false;
            }
            if (this.isValidateOutputConnection() != other.isValidateOutputConnection()) {
                return false;
            }
            if (this.isValidatePlaceholder() != other.isValidatePlaceholder()) {
                return false;
            }
            if (this.isValidateSvg() != other.isValidateSvg()) {
                return false;
            }
            if (this.isValidateNoFinalOption() != other.isValidateNoFinalOption()) {
                return false;
            }
            String this$pluginId = this.getPluginId();
            String other$pluginId = other.getPluginId();
            return !(this$pluginId == null ? other$pluginId != null : !this$pluginId.equals(other$pluginId));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Configuration;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isValidateFamily() ? 79 : 97);
            result = result * 59 + (this.isValidateSerializable() ? 79 : 97);
            result = result * 59 + (this.isValidateInternationalization() ? 79 : 97);
            result = result * 59 + (this.isValidateHttpClient() ? 79 : 97);
            result = result * 59 + (this.isValidateModel() ? 79 : 97);
            result = result * 59 + (this.isValidateMetadata() ? 79 : 97);
            result = result * 59 + (this.isValidateComponent() ? 79 : 97);
            result = result * 59 + (this.isValidateDataStore() ? 79 : 97);
            result = result * 59 + (this.isValidateDataSet() ? 79 : 97);
            result = result * 59 + (this.isValidateActions() ? 79 : 97);
            result = result * 59 + (this.isValidateDocumentation() ? 79 : 97);
            result = result * 59 + (this.isValidateWording() ? 79 : 97);
            result = result * 59 + (this.isValidateLayout() ? 79 : 97);
            result = result * 59 + (this.isValidateOptionNames() ? 79 : 97);
            result = result * 59 + (this.isValidateLocalConfiguration() ? 79 : 97);
            result = result * 59 + (this.isValidateOutputConnection() ? 79 : 97);
            result = result * 59 + (this.isValidatePlaceholder() ? 79 : 97);
            result = result * 59 + (this.isValidateSvg() ? 79 : 97);
            result = result * 59 + (this.isValidateNoFinalOption() ? 79 : 97);
            String $pluginId = this.getPluginId();
            result = result * 59 + ($pluginId == null ? 43 : $pluginId.hashCode());
            return result;
        }

        public String toString() {
            return "ComponentValidator.Configuration(validateFamily=" + this.isValidateFamily() + ", validateSerializable=" + this.isValidateSerializable() + ", validateInternationalization=" + this.isValidateInternationalization() + ", validateHttpClient=" + this.isValidateHttpClient() + ", validateModel=" + this.isValidateModel() + ", validateMetadata=" + this.isValidateMetadata() + ", validateComponent=" + this.isValidateComponent() + ", validateDataStore=" + this.isValidateDataStore() + ", validateDataSet=" + this.isValidateDataSet() + ", validateActions=" + this.isValidateActions() + ", validateDocumentation=" + this.isValidateDocumentation() + ", validateWording=" + this.isValidateWording() + ", validateLayout=" + this.isValidateLayout() + ", validateOptionNames=" + this.isValidateOptionNames() + ", validateLocalConfiguration=" + this.isValidateLocalConfiguration() + ", validateOutputConnection=" + this.isValidateOutputConnection() + ", validatePlaceholder=" + this.isValidatePlaceholder() + ", validateSvg=" + this.isValidateSvg() + ", validateNoFinalOption=" + this.isValidateNoFinalOption() + ", pluginId=" + this.getPluginId() + ")";
        }
    }
}

