/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.tools;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;
import java.util.Optional;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.talend.sdk.component.tools.DocBaseGenerator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DitaDocumentationGenerator
extends DocBaseGenerator {
    private final boolean ignoreType;
    private final boolean ignoreFullPath;

    public DitaDocumentationGenerator(File[] classes, Locale locale, Object log, File output, boolean ignoreType, boolean ignoreFullPath) {
        super(classes, locale, log, output);
        this.ignoreType = ignoreType;
        this.ignoreFullPath = ignoreFullPath;
    }

    @Override
    public void doRun() {
        Throwable throwable;
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        DocumentBuilderFactory builderFactory = this.newDocFactory();
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        HashSet directories = new HashSet();
        try {
            throwable = null;
            try (ZipOutputStream zip = new ZipOutputStream(buffer);){
                this.components().forEach(it -> {
                    try {
                        this.addDita((DocBaseGenerator.ComponentDescription)it, builderFactory, transformerFactory, zip, directories);
                    }
                    catch (ParserConfigurationException e) {
                        throw new IllegalStateException(e);
                    }
                });
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        this.ensureParentExists(this.output);
        try {
            throwable = null;
            try (OutputStream out = Files.newOutputStream(this.output.toPath(), StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);){
                out.write(buffer.toByteArray());
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        this.log.info("Generated " + this.output.getAbsolutePath());
    }

    private void addDita(DocBaseGenerator.ComponentDescription componentDescription, DocumentBuilderFactory factory, TransformerFactory transformerFactory, ZipOutputStream zip, Collection<String> directories) throws ParserConfigurationException {
        String family = componentDescription.getFamily();
        String name = componentDescription.getName();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document xml = builder.newDocument();
        Element topic = xml.createElement("topic");
        topic.setAttribute("id", "connector-" + family + '-' + name);
        topic.setAttribute("xml:lang", Optional.ofNullable(this.getLocale().getLanguage()).filter(it -> !it.isEmpty()).orElse("en"));
        xml.appendChild(topic);
        Element title = xml.createElement("title");
        title.setTextContent(name + " parameters");
        topic.appendChild(title);
        Element shortdesc = xml.createElement("shortdesc");
        shortdesc.setTextContent(componentDescription.getDocumentation().trim());
        topic.appendChild(shortdesc);
        Element prolog = xml.createElement("prolog");
        Element metadata = xml.createElement("metadata");
        Element othermeta = xml.createElement("othermeta");
        othermeta.setAttribute("content", family);
        othermeta.setAttribute("name", "pageid");
        metadata.appendChild(othermeta);
        prolog.appendChild(metadata);
        topic.appendChild(prolog);
        Element body = xml.createElement("body");
        body.setAttribute("outputclass", "subscription");
        Element section = xml.createElement("section");
        section.setAttribute("id", "section_" + topic.getAttribute("id"));
        section.setAttribute("outputclass", "subscription");
        body.appendChild(section);
        Element sectionTitle = xml.createElement("title");
        sectionTitle.setTextContent("Parameters for " + family + " " + name + " component.");
        section.appendChild(sectionTitle);
        if (!componentDescription.getParameters().isEmpty()) {
            int columnNumber = 6 - Stream.of(this.ignoreType, this.ignoreFullPath).mapToInt(it -> it != false ? 1 : 0).sum();
            Element table = xml.createElement("table");
            table.setAttribute("colsep", "1");
            table.setAttribute("frame", "all");
            table.setAttribute("rowsep", "1");
            Element tgroup = xml.createElement("tgroup");
            tgroup.setAttribute("cols", Integer.toString(columnNumber));
            table.appendChild(tgroup);
            IntStream.rangeClosed(1, columnNumber).forEach(col -> {
                Element colspec = xml.createElement("colspec");
                colspec.setAttribute("colname", "c" + col);
                colspec.setAttribute("colnum", Integer.toString(col));
                colspec.setAttribute("colwidth", "1*");
                tgroup.appendChild(colspec);
            });
            Element configurationHead = xml.createElement("thead");
            Element headRow = xml.createElement("row");
            this.appendColumn(xml, headRow, "Display Name");
            this.appendColumn(xml, headRow, "Description");
            this.appendColumn(xml, headRow, "Default Value");
            this.appendColumn(xml, headRow, "Enabled If");
            if (!this.ignoreFullPath) {
                this.appendColumn(xml, headRow, "Path");
            }
            if (!this.ignoreType) {
                this.appendColumn(xml, headRow, "Type");
            }
            configurationHead.appendChild(headRow);
            tgroup.appendChild(configurationHead);
            Element configurationBody = xml.createElement("tbody");
            componentDescription.parameters().forEach(param -> {
                Element row = xml.createElement("row");
                this.appendColumn(xml, row, param.getDisplayName());
                this.appendColumn(xml, row, param.getDocumentation());
                this.appendColumn(xml, row, param.getDefaultValue());
                Element column = xml.createElement("entry");
                this.renderConditions(xml, column, param.getConditions());
                row.appendChild(column);
                if (!this.ignoreFullPath) {
                    this.appendColumn(xml, row, param.getFullPath());
                }
                if (!this.ignoreType) {
                    this.appendColumn(xml, row, param.getType());
                }
                configurationBody.appendChild(row);
            });
            tgroup.appendChild(configurationBody);
            section.appendChild(table);
        }
        topic.appendChild(body);
        StringWriter writer = new StringWriter();
        StreamResult result = new StreamResult(writer);
        try {
            String ditaFolder;
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            transformer.transform(new DOMSource(xml), result);
            String rootDir = this.output.getName().replace(".zip", "");
            if (directories.add(rootDir)) {
                zip.putNextEntry(new ZipEntry(rootDir + '/'));
                zip.closeEntry();
            }
            if (directories.add(ditaFolder = rootDir + '/' + family)) {
                zip.putNextEntry(new ZipEntry(ditaFolder + '/'));
                zip.closeEntry();
            }
            String path = ditaFolder + '/' + name + ".dita";
            zip.putNextEntry(new ZipEntry(path));
            String content = writer.toString();
            int topicIdx = content.indexOf("<topic");
            zip.write((content.substring(0, topicIdx) + "<!DOCTYPE topic PUBLIC \"-//OASIS//DTD DITA Topic//EN\" \"topic.dtd\">\n" + content.substring(topicIdx)).getBytes(StandardCharsets.UTF_8));
            zip.closeEntry();
        }
        catch (IOException | TransformerException e) {
            throw new IllegalStateException(e);
        }
    }

    private void renderConditions(Document xml, Element container, DocBaseGenerator.Conditions conditions) {
        switch (conditions.getConditions().size()) {
            case 0: {
                container.setTextContent("Always enabled");
                break;
            }
            case 1: {
                this.renderCondition(xml, container, conditions.getConditions().iterator().next());
                break;
            }
            default: {
                Element listWrapper = xml.createElement("ul");
                Runnable conditionAppender = () -> conditions.getConditions().forEach(cond -> {
                    Element li = xml.createElement("li");
                    this.renderCondition(xml, li, (DocBaseGenerator.Condition)cond);
                    listWrapper.appendChild(li);
                });
                switch (conditions.getOperator().toUpperCase(Locale.ROOT)) {
                    case "OR": {
                        container.setTextContent("One of these conditions is meet:");
                        conditionAppender.run();
                        break;
                    }
                    default: {
                        container.setTextContent("All of the following conditions are met:");
                        conditionAppender.run();
                    }
                }
                container.appendChild(listWrapper);
            }
        }
    }

    private void renderCondition(Document xml, Element container, DocBaseGenerator.Condition condition) {
        Runnable valuesAppender = () -> Stream.of(condition.getValue().split(",")).map(v -> {
            Element userinput = xml.createElement("userinput");
            userinput.setTextContent((String)v);
            return userinput;
        }).reduce(container, (wrapper, child) -> {
            if (wrapper.hasChildNodes()) {
                wrapper.setTextContent(" or ");
            }
            wrapper.appendChild((Node)child);
            return wrapper;
        });
        Runnable appendPath = () -> {
            Element parmname = xml.createElement("parmname");
            parmname.setTextContent(condition.getPath());
            container.appendChild(parmname);
        };
        switch (Optional.ofNullable(condition.getStrategy()).orElse("default").toLowerCase(Locale.ROOT)) {
            case "length": {
                if (condition.isNegate()) {
                    if ("0".equals(condition.getValue())) {
                        appendPath.run();
                        container.setTextContent(" is not empty");
                        break;
                    }
                    container.setTextContent("the length of ");
                    appendPath.run();
                    container.setTextContent(" is not ");
                    valuesAppender.run();
                    break;
                }
                if ("0".equals(condition.getValue())) {
                    appendPath.run();
                    container.setTextContent("is empty");
                    break;
                }
                container.setTextContent("the length of ");
                appendPath.run();
                container.setTextContent(" is ");
                valuesAppender.run();
                break;
            }
            case "contains": {
                appendPath.run();
                if (condition.isNegate()) {
                    container.setTextContent(" does not contain ");
                } else {
                    container.setTextContent(" contains ");
                }
                valuesAppender.run();
                break;
            }
            case "contains(lowercase=true)": {
                container.setTextContent("the lowercase value of ");
                appendPath.run();
                if (condition.isNegate()) {
                    container.setTextContent(" does not contain ");
                } else {
                    container.setTextContent(" contains ");
                }
                valuesAppender.run();
                break;
            }
            default: {
                appendPath.run();
                if (condition.isNegate()) {
                    container.setTextContent(" is not equal to ");
                } else {
                    container.setTextContent(" is equal to ");
                }
                valuesAppender.run();
            }
        }
    }

    private void appendColumn(Document xml, Element row, String value) {
        Element column = xml.createElement("entry");
        if (value != null) {
            column.setTextContent(value.trim());
        }
        row.appendChild(column);
    }

    private DocumentBuilderFactory newDocFactory() {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        }
        catch (ParserConfigurationException e) {
            throw new IllegalStateException(e);
        }
        return factory;
    }
}

