/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.tools;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import java.util.Scanner;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Stream;
import org.apache.catalina.core.StandardServer;
import org.apache.commons.cli.CommandLine;
import org.apache.meecrowave.Meecrowave;
import org.apache.meecrowave.runner.Cli;
import org.talend.sdk.component.tools.Log;
import org.talend.sdk.component.tools.ReflectiveLog;

public class WebServer
implements Runnable {
    private final Collection<String> serverArguments;
    private final Integer port;
    private final String componentGav;
    private final Log log;

    public WebServer(Collection<String> serverArguments, Integer port, Object log, String gav) {
        this.serverArguments = serverArguments;
        this.port = port;
        try {
            this.log = Log.class.isInstance(log) ? (Log)Log.class.cast(log) : new ReflectiveLog(log);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(e);
        }
        this.componentGav = gav;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        String originalCompSystProp = this.setSystemProperty("talend.component.server.component.coordinates", this.componentGav);
        String skipClasspathSystProp = this.setSystemProperty("component.manager.classpath.skip", "true");
        String skipCallersSystProp = this.setSystemProperty("component.manager.callers.skip", "true");
        final AtomicReference ref = new AtomicReference();
        try {
            final CountDownLatch latch = new CountDownLatch(1);
            Cli cli = new Cli(this.buildArgs()){

                protected void doWait(Meecrowave meecrowave, CommandLine line) {
                    ref.set(meecrowave);
                    latch.countDown();
                    super.doWait(meecrowave, line);
                }
            };
            new Thread(() -> {
                try {
                    cli.run();
                }
                catch (RuntimeException re) {
                    latch.countDown();
                    this.log.error(re.getMessage());
                    throw re;
                }
            }, this.getClass().getName() + '_' + this.findPort()).start();
            try {
                latch.await(2L, TimeUnit.MINUTES);
            }
            catch (InterruptedException e) {
                Thread.interrupted();
                this.reset("talend.component.server.component.coordinates", originalCompSystProp);
                this.reset("component.manager.classpath.skip", skipClasspathSystProp);
                this.reset("component.manager.callers.skip", skipCallersSystProp);
                Optional.ofNullable(ref.get()).ifPresent(mw -> ((StandardServer)StandardServer.class.cast(mw.getTomcat().getServer())).stopAwait());
                return;
            }
            this.log.info("\n\n  You can now access the UI at http://localhost:" + this.port + "\n\n");
            Scanner scanner = new Scanner(System.in);
            do {
                this.log.info("Enter 'exit' to quit");
            } while (!this.shouldQuit(scanner.nextLine()));
        }
        finally {
            this.reset("talend.component.server.component.coordinates", originalCompSystProp);
            this.reset("component.manager.classpath.skip", skipClasspathSystProp);
            this.reset("component.manager.callers.skip", skipCallersSystProp);
            Optional.ofNullable(ref.get()).ifPresent(mw -> ((StandardServer)StandardServer.class.cast(mw.getTomcat().getServer())).stopAwait());
        }
    }

    private String setSystemProperty(String key, String value) {
        String old = System.getProperty(key);
        System.setProperty(key, value);
        return old;
    }

    private void reset(String key, String value) {
        if (value == null) {
            System.clearProperty(key);
        } else {
            System.setProperty(key, value);
        }
    }

    private boolean shouldQuit(String value) {
        return Stream.of("exit", "quit", "X").anyMatch(v -> v.equalsIgnoreCase(value));
    }

    private String[] buildArgs() {
        ArrayList<String> args = new ArrayList<String>();
        if (this.serverArguments != null) {
            args.addAll(this.serverArguments);
        }
        if (this.serverArguments != null && this.serverArguments.contains("--http")) {
            if (this.port != null) {
                this.log.info("port configuration ignored since serverArguments already defines it");
            }
        } else {
            args.add("--http");
            args.add(this.findPort());
        }
        if (!args.contains("--use-shutdown-hook")) {
            args.add("--use-shutdown-hook");
            args.add("false");
        }
        return args.toArray(new String[args.size()]);
    }

    private String findPort() {
        return this.port == null ? "8080" : Integer.toString(this.port);
    }
}

