/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.tools;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Executable;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.xbean.finder.AnnotationFinder;
import org.talend.sdk.component.api.meta.Documentation;
import org.talend.sdk.component.runtime.manager.ParameterMeta;
import org.talend.sdk.component.runtime.manager.reflect.Constructors;
import org.talend.sdk.component.runtime.manager.reflect.ParameterModelService;
import org.talend.sdk.component.runtime.manager.util.DefaultValueInspector;
import org.talend.sdk.component.tools.AsciidoctorExecutor;
import org.talend.sdk.component.tools.BaseTask;
import org.talend.sdk.component.tools.Log;
import org.talend.sdk.component.tools.ReflectiveLog;

public class AsciidocDocumentationGenerator
extends BaseTask {
    private final File output;
    private final String levelPrefix;
    private final DefaultValueInspector defaultValueInspector = new DefaultValueInspector();
    private final Map<String, String> formats;
    private final Map<String, String> attributes;
    private final File templateDir;
    private final File workDir;
    private final String templateEngine;
    private final String title;
    private final String version;
    private final Log log;
    private final ParameterModelService parameterModelService = new ParameterModelService(Collections.singletonList((parameterName, parameterType, annotation) -> annotation.annotationType() == Documentation.class ? Collections.singletonMap("documentation", ((Documentation)Documentation.class.cast(annotation)).value()) : Collections.emptyMap())){};

    public AsciidocDocumentationGenerator(File[] classes, File output, String title, int level, Map<String, String> formats, Map<String, String> attributes, File templateDir, String templateEngine, Object log, File workDir, String version) {
        super(classes);
        this.title = title;
        this.output = output;
        this.formats = formats;
        this.attributes = attributes;
        this.templateDir = templateDir;
        this.templateEngine = templateEngine;
        this.workDir = workDir;
        this.version = version;
        this.levelPrefix = IntStream.range(0, level).mapToObj(i -> "=").collect(Collectors.joining(""));
        try {
            this.log = Log.class.isInstance(log) ? (Log)Log.class.cast(log) : new ReflectiveLog(log);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public void run() {
        AnnotationFinder finder = this.newFinder();
        String doc = this.componentMarkers().flatMap(a -> finder.findAnnotatedClasses(a).stream()).map(this::toAsciidoc).collect(StringBuilder::new, StringBuilder::append, StringBuilder::append).toString();
        this.output.getParentFile().mkdirs();
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(this.output));){
            writer.write(doc);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        Optional.ofNullable(this.formats).ifPresent(f -> {
            try (AsciidoctorExecutor asciidoctorExecutor = new AsciidoctorExecutor();){
                f.forEach((format, output) -> {
                    switch (format.toLowerCase(Locale.ENGLISH)) {
                        case "html": {
                            asciidoctorExecutor.render(this.workDir, this.version, this.log, "html5", this.output, new File((String)output), this.title, this.attributes, this.templateDir, this.templateEngine);
                            break;
                        }
                        case "pdf": {
                            asciidoctorExecutor.render(this.workDir, this.version, this.log, "pdf", this.output, new File((String)output), this.title, this.attributes, this.templateDir, this.templateEngine);
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("unknown format: '" + format + "', supported: [html, pdf]");
                        }
                    }
                });
            }
        });
    }

    private String toAsciidoc(Class<?> aClass) {
        List parameterMetas = this.parameterModelService.buildParameterMetas((Executable)Constructors.findConstructor(aClass), Optional.ofNullable(aClass.getPackage()).map(Package::getName).orElse(""));
        return this.levelPrefix + " " + this.componentMarkers().filter(aClass::isAnnotationPresent).map(aClass::getAnnotation).map(this::asComponent).findFirst().get().name() + "\n\n" + Optional.ofNullable(aClass.getAnnotation(Documentation.class)).map(Documentation::value).map(v -> v + "\n\n").orElse("") + (parameterMetas.isEmpty() ? "" : this.levelPrefix + "= Configuration\n\n" + this.toAsciidocRows(parameterMetas, null).sorted(Comparator.comparing(line -> line.substring(1, line.indexOf(124, 1)))).collect(Collectors.joining("\n", "|===\n|Path|Description|Default Value\n", "\n|===\n\n")));
    }

    private Stream<String> toAsciidocRows(Collection<ParameterMeta> parameterMetas, Object parentInstance) {
        return parameterMetas.stream().flatMap(p -> {
            Object instance = this.defaultValueInspector.createDemoInstance(parentInstance, p);
            return Stream.concat(Stream.of(this.toAsciidoctor((ParameterMeta)p, instance)), this.toAsciidocRows(p.getNestedParameters(), instance));
        });
    }

    private String toAsciidoctor(ParameterMeta p, Object instance) {
        return "|" + p.getPath() + '|' + this.findDocumentation(p) + '|' + Optional.ofNullable(this.defaultValueInspector.findDefault(instance, p)).orElse("-");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String findDocumentation(ParameterMeta p) {
        String inline = (String)p.getMetadata().get("documentation");
        if (inline == null) return p.getName() + " configuration";
        if (!inline.startsWith("resource:")) return inline;
        InputStream stream = Thread.currentThread().getContextClassLoader().getResourceAsStream(inline.substring("resource:".length()));
        if (stream == null) throw new IllegalArgumentException("No resource: '" + inline + "'");
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));){
            String string = reader.lines().collect(Collectors.joining("\n"));
            return string;
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Bad resource: '" + inline + "'", e);
        }
    }
}

