/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.tools.webapp.standalone.main;

import java.io.StringReader;
import java.util.HashMap;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.json.bind.Jsonb;
import javax.json.bind.JsonbBuilder;
import lombok.Generated;
import org.talend.sdk.component.container.Container;
import org.talend.sdk.component.runtime.manager.ComponentManager;
import org.talend.sdk.component.runtime.manager.ContainerComponentRegistry;

public class ActionExecutor {
    public static void main(String[] args) {
        if (args.length != 6) {
            System.err.println("Usage\n   app <component_gav> <lang> <action_family> <action_type> <action_name> <payload>");
            return;
        }
        System.setProperty("talend.component.manager.m2.repository", System.getProperty("talend.component.manager.m2.repository", System.getProperty("user.home") + "/.m2/repository"));
        System.setProperty("talend.component.manager.classpathcontributor.skip", System.getProperty("talend.component.manager.classpathcontributor.skip", "true"));
        System.setProperty("talend.component.manager.localconfiguration.skip", System.getProperty("talend.component.manager.localconfiguration.skip", "true"));
        System.setProperty("talend.component.manager.jmx.skip", System.getProperty("talend.component.manager.jmx.skip", "true"));
        System.setProperty("talend.component.impl.mode", System.getProperty("talend.component.impl.mode", "UNSAFE"));
        try (Jsonb jsonb = JsonbBuilder.create();){
            try {
                ComponentManager instance = ComponentManager.instance();
                String plugin = instance.addPlugin(args[0]);
                Container container = (Container)instance.findPlugin(plugin).orElseThrow(() -> new IllegalArgumentException("plugin '" + plugin + "' incorrectly started"));
                Properties props = new Properties();
                try (StringReader reader = new StringReader(args[5]);){
                    props.load(reader);
                }
                HashMap<String, String> runtimeParams = new HashMap<String, String>(1 + props.size());
                runtimeParams.put("$lang", args[1]);
                runtimeParams.putAll(props.stringPropertyNames().stream().collect(Collectors.toMap(Function.identity(), props::getProperty)));
                Object result = ((ContainerComponentRegistry)container.get(ContainerComponentRegistry.class)).getServices().stream().flatMap(sm -> sm.getActions().stream()).filter(act -> Objects.equals(args[2], act.getFamily()) && Objects.equals(args[3], act.getType()) && Objects.equals(args[4], act.getAction())).findFirst().orElseThrow(() -> new IllegalArgumentException("Invalid action, not found")).getInvoker().apply(runtimeParams);
                ActionExecutor.onResult(jsonb, result);
            }
            catch (RuntimeException re) {
                ActionExecutor.onError(jsonb, re);
                System.exit(1);
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private static void onError(Jsonb jsonb, RuntimeException re) {
        System.err.println(jsonb.toJson((Object)new ErrorPayload("ACTION_ERROR", "Action execution failed with: " + Optional.ofNullable(re.getMessage()).orElseGet(() -> NullPointerException.class.isInstance(re) ? "unexpected null" : "no error message"))));
    }

    private static void onResult(Jsonb jsonb, Object result) {
        System.out.println(jsonb.toJson(result));
    }

    @Generated
    private ActionExecutor() {
    }

    public static class ErrorPayload {
        private String code;
        private String description;

        @Generated
        public String getCode() {
            return this.code;
        }

        @Generated
        public String getDescription() {
            return this.description;
        }

        @Generated
        public void setCode(String code) {
            this.code = code;
        }

        @Generated
        public void setDescription(String description) {
            this.description = description;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ErrorPayload)) {
                return false;
            }
            ErrorPayload other = (ErrorPayload)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$code = this.getCode();
            String other$code = other.getCode();
            if (this$code == null ? other$code != null : !this$code.equals(other$code)) {
                return false;
            }
            String this$description = this.getDescription();
            String other$description = other.getDescription();
            return !(this$description == null ? other$description != null : !this$description.equals(other$description));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ErrorPayload;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $code = this.getCode();
            result = result * 59 + ($code == null ? 43 : $code.hashCode());
            String $description = this.getDescription();
            result = result * 59 + ($description == null ? 43 : $description.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "ActionExecutor.ErrorPayload(code=" + this.getCode() + ", description=" + this.getDescription() + ")";
        }

        @Generated
        public ErrorPayload() {
        }

        @Generated
        public ErrorPayload(String code, String description) {
            this.code = code;
            this.description = description;
        }
    }
}

