/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.tools.webapp;

import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.sdk.component.form.api.ActionService;
import org.talend.sdk.component.form.api.Client;
import org.talend.sdk.component.form.api.UiSpecService;
import org.talend.sdk.component.form.api.WebException;
import org.talend.sdk.component.form.model.UiActionResult;
import org.talend.sdk.component.server.front.model.ComponentDetail;
import org.talend.sdk.component.server.front.model.ComponentDetailList;
import org.talend.sdk.component.server.front.model.ComponentIndices;
import org.talend.sdk.component.server.front.model.ConfigTypeNode;
import org.talend.sdk.component.server.front.model.ConfigTypeNodes;

@ApplicationScoped
@Path(value="application")
public class WebAppComponentProxy {
    private static final Logger log = LoggerFactory.getLogger(WebAppComponentProxy.class);
    @Inject
    private Client<Object> client;
    @Inject
    private ActionService actionService;
    @Inject
    private UiSpecService<Object> uiSpecService;
    @Inject
    private WebTarget target;

    @POST
    @Path(value="action")
    public void action(@Suspended AsyncResponse response, @QueryParam(value="family") String family, @QueryParam(value="lang") String language, @QueryParam(value="type") String type, @QueryParam(value="action") String action, Map<String, Object> params, @Context HttpServletRequest request) {
        this.client.action(family, type, action, this.getLanguage(language, request), params, null).handle((r, e) -> {
            if (e != null) {
                this.onException(response, (Throwable)e);
            } else {
                response.resume((Object)this.actionService.map(type, r));
            }
            return null;
        });
    }

    @GET
    @Path(value="index")
    public void getIndex(@Suspended AsyncResponse response, @QueryParam(value="language") String language, @QueryParam(value="configuration") @DefaultValue(value="false") boolean configuration, @Context HttpServletRequest request) {
        if (configuration) {
            this.target.path("configurationtype/index").queryParam("language", new Object[]{this.getLanguage(language, request)}).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).rx().get(ConfigTypeNodes.class).toCompletableFuture().handle((index, e) -> {
                if (e != null) {
                    this.onException(response, (Throwable)e);
                } else {
                    response.resume(index);
                }
                return null;
            });
        } else {
            this.target.path("component/index").queryParam("language", new Object[]{this.getLanguage(language, request)}).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).rx().get(ComponentIndices.class).toCompletableFuture().handle((index, e) -> {
                if (e != null) {
                    this.onException(response, (Throwable)e);
                } else {
                    index.getComponents().stream().flatMap(c -> c.getLinks().stream()).forEach(link -> link.setPath(link.getPath().replaceFirst("/component/", "/application/").replace("/details?identifiers=", "/detail/")));
                    response.resume(index);
                }
                return null;
            });
        }
    }

    @GET
    @Path(value="detail/{id}")
    public void getDetail(@Suspended AsyncResponse response, @QueryParam(value="language") String language, @PathParam(value="id") String id, @QueryParam(value="configuration") @DefaultValue(value="false") boolean configuration, @Context HttpServletRequest request) {
        String lang = Optional.ofNullable(request.getLocale()).map(Locale::getLanguage).orElse("en");
        if (configuration) {
            ((CompletableFuture)this.target.path("configurationtype/details").queryParam("language", new Object[]{this.getLanguage(language, request)}).queryParam("identifiers", new Object[]{id}).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).rx().get(ConfigTypeNodes.class).toCompletableFuture().thenCompose(result -> {
                ConfigTypeNode node = (ConfigTypeNode)result.getNodes().values().iterator().next();
                return this.uiSpecService.convert(this.extractFamilyFromNode(node.getId()), lang, node, null);
            })).handle((result, e) -> {
                if (e != null) {
                    this.onException(response, (Throwable)e);
                } else {
                    response.resume(result);
                }
                return null;
            });
        } else {
            ((CompletableFuture)this.target.path("component/details").queryParam("language", new Object[]{this.getLanguage(language, request)}).queryParam("identifiers", new Object[]{id}).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).rx().get(ComponentDetailList.class).toCompletableFuture().thenCompose(result -> this.uiSpecService.convert((ComponentDetail)result.getDetails().iterator().next(), lang, null))).handle((result, e) -> {
                if (e != null) {
                    this.onException(response, (Throwable)e);
                } else {
                    response.resume(result);
                }
                return null;
            });
        }
    }

    private String getLanguage(String language, HttpServletRequest request) {
        return Optional.ofNullable(language).orElseGet(() -> Optional.ofNullable(request.getLocale()).map(Locale::getLanguage).filter(it -> !it.isEmpty()).orElse("en"));
    }

    private String extractFamilyFromNode(String id) {
        String decoded = new String(Base64.getUrlDecoder().decode(id), StandardCharsets.UTF_8);
        if (decoded.startsWith("extension::")) {
            String[] split = decoded.split("::");
            return split[split.length - 1];
        }
        return decoded.split("#")[1];
    }

    private void onException(AsyncResponse response, Throwable e) {
        UiActionResult payload;
        int status;
        if (WebException.class.isInstance(e)) {
            WebException we = (WebException)WebException.class.cast(e);
            status = we.getStatus();
            payload = this.actionService.map(we);
        } else if (CompletionException.class.isInstance(e)) {
            CompletionException actualException = (CompletionException)CompletionException.class.cast(e);
            log.error(actualException.getMessage(), (Throwable)actualException);
            status = Response.Status.BAD_GATEWAY.getStatusCode();
            if (WebApplicationException.class.isInstance(actualException.getCause())) {
                Response resp = ((WebApplicationException)((Object)WebApplicationException.class.cast(actualException.getCause()))).getResponse();
                if (response != null) {
                    String s = (String)resp.readEntity(String.class);
                    response.resume((Object)Response.status((int)resp.getStatus()).entity((Object)s).type(MediaType.APPLICATION_JSON_TYPE).build());
                    return;
                }
            }
            payload = this.actionService.map(new WebException((Throwable)actualException, -1, Collections.emptyMap()));
        } else {
            log.error(e.getMessage(), e);
            status = Response.Status.BAD_GATEWAY.getStatusCode();
            payload = this.actionService.map(new WebException(e, -1, Collections.emptyMap()));
        }
        response.resume((Throwable)new WebApplicationException(Response.status((int)status).entity((Object)payload).build()));
    }
}

