/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.tools.webapp.standalone.generator;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.enterprise.inject.se.SeContainer;
import javax.enterprise.inject.se.SeContainerInitializer;
import javax.json.bind.Jsonb;
import javax.json.bind.JsonbBuilder;
import javax.json.bind.JsonbConfig;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import org.apache.meecrowave.openwebbeans.MeecrowaveLoaderService;
import org.apache.webbeans.spi.LoaderService;
import org.talend.sdk.component.path.PathFactory;
import org.talend.sdk.component.server.api.ActionResource;
import org.talend.sdk.component.server.api.ComponentResource;
import org.talend.sdk.component.server.api.ConfigurationTypeResource;
import org.talend.sdk.component.server.api.DocumentationResource;
import org.talend.sdk.component.server.api.EnvironmentResource;
import org.talend.sdk.component.server.front.model.ConfigTypeNodes;
import org.talend.sdk.component.server.front.model.error.ErrorPayload;
import org.talend.sdk.component.tools.webapp.standalone.Route;

public class StaticResourceGenerator
implements Runnable {
    private final Map<String, String> systemPropertyVariables;
    private final Path outputRepository;
    private final Path outputDescriptor;
    private final Collection<String> languages;
    private final OutputFormatter formatter;
    private final boolean skipDependencies;

    public StaticResourceGenerator(String[] args) {
        this(Collections.emptyMap(), PathFactory.get((String)args[0]).resolve("repository"), PathFactory.get((String)args[0]).resolve("routes.json"), Stream.of(args[1].split(",")).collect(Collectors.toList()), OutputFormatter.JSON, args.length >= 3 && Boolean.parseBoolean(args[2]));
    }

    @Override
    public void run() {
        this.validate();
        this.generate(routes -> {
            try {
                if (!Files.exists(this.outputDescriptor.getParent(), new LinkOption[0])) {
                    Files.createDirectories(this.outputDescriptor.getParent(), new FileAttribute[0]);
                }
                if (this.formatter.needsFileIdMapping()) {
                    if (!Files.exists(this.outputRepository, new LinkOption[0])) {
                        Files.createDirectories(this.outputRepository, new FileAttribute[0]);
                    }
                    routes.forEach(r -> {
                        try {
                            Files.copy(new ByteArrayInputStream(r.getContent()), this.outputRepository.resolve(r.getId()), StandardCopyOption.REPLACE_EXISTING);
                        }
                        catch (IOException e) {
                            throw new IllegalStateException(e);
                        }
                    });
                    routes.forEach(r -> r.setContent(null));
                }
                try (OutputStream stream = Files.newOutputStream(this.outputDescriptor, new OpenOption[0]);){
                    this.formatter.format((Collection<Route>)routes, stream);
                }
            }
            catch (IOException ioe) {
                throw new IllegalStateException(ioe);
            }
        });
    }

    public void generate(Consumer<Collection<Route>> routesConsumer) {
        try (AutoCloseable autoClosed = this.prepareEnv();){
            routesConsumer.accept(this.collectResources());
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public Collection<Route> collectResources() {
        ArrayList<Route> routes = new ArrayList<Route>(this.languages.size() * 11);
        try (SeContainer container = SeContainerInitializer.newInstance().addProperty("skipHttp", (Object)true).addProperty("org.apache.webbeans.scanBeansXmlOnly", (Object)"true").addProperty(LoaderService.class.getName(), (Object)new MeecrowaveLoaderService()).initialize();
             Jsonb jsonb = JsonbBuilder.create();){
            String[] emptyStringArray = new String[]{};
            EnvironmentResource environment = (EnvironmentResource)container.select(EnvironmentResource.class, new Annotation[0]).get();
            routes.add(StaticResourceGenerator.route("component_server_environment", "/api/v1/environment", MapBuilder.map().done(), Collections.emptyMap(), Collections.emptyMap(), jsonb.toJson((Object)environment.get())));
            ActionResource actions = (ActionResource)container.select(ActionResource.class, new Annotation[0]).get();
            routes.addAll(this.languages.stream().map(lang -> StaticResourceGenerator.route("component_server_action_index_" + lang, "/api/v1/action/index", MapBuilder.map().with("language", (String)lang).done(), Collections.emptyMap(), Collections.emptyMap(), jsonb.toJson((Object)actions.getIndex(emptyStringArray, emptyStringArray, lang)))).collect(Collectors.toList()));
            ComponentResource components = (ComponentResource)container.select(ComponentResource.class, new Annotation[0]).get();
            routes.addAll(Stream.of(true, false).flatMap(includeIconContent -> this.languages.stream().map(lang -> StaticResourceGenerator.route("component_server_component_index_" + lang + '_' + (includeIconContent != false ? "includeIconContent" : "noIncludeIconContent"), "/api/v1/component/index", MapBuilder.map().with("language", (String)lang).with("includeIconContent", Boolean.toString(includeIconContent)).done(), Collections.emptyMap(), Collections.emptyMap(), jsonb.toJson((Object)components.getIndex(lang, includeIconContent.booleanValue(), ""))))).collect(Collectors.toList()));
            List componentIndex = components.getIndex("en", false, "").getComponents();
            List componentIds = componentIndex.stream().map(it -> it.getId().getId()).distinct().collect(Collectors.toList());
            List componentFamilyIds = componentIndex.stream().map(it -> it.getId().getFamilyId()).distinct().collect(Collectors.toList());
            routes.addAll(componentIds.stream().flatMap(componentId -> this.languages.stream().map(lang -> StaticResourceGenerator.route("component_server_component_dependencies_" + lang + '_' + componentId, "/api/v1/component/dependencies", MapBuilder.map().with("identifier", (String)componentId).done(), Collections.emptyMap(), Collections.emptyMap(), jsonb.toJson((Object)components.getDependencies(new String[]{componentId}))))).collect(Collectors.toList()));
            routes.addAll(componentIds.stream().flatMap(componentId -> this.languages.stream().map(lang -> StaticResourceGenerator.route("component_server_component_details_" + lang + '_' + componentId, "/api/v1/component/details", MapBuilder.map().with("language", (String)lang).with("identifiers", (String)componentId).done(), Collections.emptyMap(), Collections.emptyMap(), jsonb.toJson((Object)components.getDetail(lang, new String[]{componentId}))))).collect(Collectors.toList()));
            if (!this.skipDependencies) {
                routes.addAll(componentIds.stream().flatMap(componentId -> components.getDependencies(new String[]{componentId}).getDependencies().values().stream()).flatMap(dep -> dep.getDependencies().stream()).distinct().filter(it -> !it.startsWith("org.talend.sdk.component:")).map(dep -> new Route("component_server_component_dependency_" + dep.replace(':', '_').replace('.', '_'), Response.Status.OK.getStatusCode(), "/api/v1/component/dependency/" + dep, MapBuilder.map().done(), Collections.singletonMap("Content-Type", "application/octet-stream"), Collections.emptyMap(), this.swallow(() -> components.getDependency(dep)))).collect(Collectors.toList()));
            }
            routes.addAll(componentIds.stream().map(componentId -> {
                Response response = components.icon(componentId);
                return StaticResourceGenerator.route("component_server_component_icon_" + componentId, "/api/v1/component/icon/" + componentId, MapBuilder.map().done(), Collections.singletonMap("Content-Type", "application/octet-stream"), Collections.emptyMap(), response.getStatus(), arg_0 -> ((Response)response).readEntity(arg_0), jsonb);
            }).collect(Collectors.toList()));
            routes.addAll(componentFamilyIds.stream().map(familyId -> {
                Response response = components.familyIcon(familyId);
                return StaticResourceGenerator.route("component_server_component_family_icon_" + familyId, "/api/v1/component/icon/family/" + familyId, MapBuilder.map().done(), Collections.singletonMap("Content-Type", "application/octet-stream"), Collections.emptyMap(), response.getStatus(), arg_0 -> ((Response)response).readEntity(arg_0), jsonb);
            }).collect(Collectors.toList()));
            ConfigurationTypeResource configurations = (ConfigurationTypeResource)container.select(ConfigurationTypeResource.class, new Annotation[0]).get();
            ConfigTypeNodes configurationTypes = configurations.getRepositoryModel("en", true, "");
            routes.addAll(Stream.of(true, false).flatMap(lightPayload -> this.languages.stream().map(lang -> StaticResourceGenerator.route("component_server_configuration_index_" + lang + '_' + (lightPayload != false ? "lightPayload" : "noLightPayload"), "/api/v1/configurationtype/index", MapBuilder.map().with("language", (String)lang).with("lightPayload", Boolean.toString(lightPayload)).done(), Collections.emptyMap(), Collections.emptyMap(), jsonb.toJson((Object)configurations.getRepositoryModel(lang, lightPayload.booleanValue(), ""))))).collect(Collectors.toList()));
            routes.addAll(configurationTypes.getNodes().keySet().stream().flatMap(id -> this.languages.stream().map(lang -> StaticResourceGenerator.route("component_server_configuration_details_" + lang + "_" + id, "/api/v1/configurationtype/details", MapBuilder.map().with("language", (String)lang).with("identifiers", (String)id).done(), Collections.emptyMap(), Collections.emptyMap(), jsonb.toJson((Object)configurations.getDetail(lang, new String[]{id}))))).collect(Collectors.toList()));
            DocumentationResource documentations = (DocumentationResource)container.select(DocumentationResource.class, new Annotation[0]).get();
            routes.addAll(componentIds.stream().flatMap(componentId -> this.languages.stream().flatMap(lang -> Stream.of(DocumentationResource.DocumentationSegment.values()).map(segment -> StaticResourceGenerator.route("component_server_documentation_" + lang + "_" + segment.name().toLowerCase(Locale.ROOT) + '_' + componentId, "/api/v1/documentation/component/" + componentId, MapBuilder.map().with("language", (String)lang).with("segment", segment.name()).done(), Collections.emptyMap(), Collections.emptyMap(), jsonb.toJson((Object)documentations.getDocumentation(componentId, lang, segment)))))).collect(Collectors.toList()));
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        return routes;
    }

    private void validate() {
        if (this.outputDescriptor == null) {
            throw new IllegalArgumentException("No otuput set");
        }
        if (this.languages.isEmpty()) {
            throw new IllegalArgumentException("No language set, nothing to generate");
        }
    }

    private AutoCloseable prepareEnv() {
        List cleanupTasks = Optional.ofNullable(this.systemPropertyVariables).orElseGet(Collections::emptyMap).entrySet().stream().map(e -> {
            String existing = System.getProperty((String)e.getKey());
            System.setProperty((String)e.getKey(), (String)e.getValue());
            return () -> {
                if (existing == null) {
                    System.clearProperty((String)e.getKey());
                } else {
                    System.setProperty((String)e.getKey(), existing);
                }
            };
        }).collect(Collectors.toList());
        Locale oldLocale = Locale.getDefault();
        cleanupTasks.add(() -> Locale.setDefault(oldLocale));
        return () -> cleanupTasks.forEach(Runnable::run);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] swallow(Supplier<StreamingOutput> dependency) {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            dependency.get().write((OutputStream)baos);
            baos.flush();
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        catch (WebApplicationException wae) {
            throw new IllegalStateException(wae.getResponse().readEntity(Object.class).toString(), wae);
        }
    }

    private static Route route(String id, String path, SortedMap<String, String> queries, Map<String, String> requestHeaders, Map<String, String> responseHeaders, String content) {
        return new Route(id, 200, path, queries, responseHeaders.isEmpty() ? Collections.singletonMap("Accept", responseHeaders.getOrDefault("Content-Type", "application/json")) : requestHeaders, responseHeaders.isEmpty() ? Collections.singletonMap("Content-Type", "application/json") : responseHeaders, content.getBytes(StandardCharsets.UTF_8));
    }

    private static Route route(String id, String path, SortedMap<String, String> queries, Map<String, String> requestHeaders, Map<String, String> responseHeaders, int status, Function<Class<?>, Object> responseProvider, Jsonb jsonb) {
        return new Route(id, status, path, queries, requestHeaders, responseHeaders, status == 200 ? (byte[])byte[].class.cast(responseProvider.apply(byte[].class)) : jsonb.toJson(responseProvider.apply(ErrorPayload.class)).getBytes(StandardCharsets.UTF_8));
    }

    public static void main(String[] args) {
        if (args.length < 2) {
            System.err.println("Usage:\nargs: <where to output the dump> <which langs to use for the generation> <ignore dependency endpoint>  ex:  app output_root_dir lang1,lang2,... [true|false]");
            return;
        }
        new StaticResourceGenerator(args).run();
    }

    public StaticResourceGenerator(Map<String, String> systemPropertyVariables, Path outputRepository, Path outputDescriptor, Collection<String> languages, OutputFormatter formatter, boolean skipDependencies) {
        this.systemPropertyVariables = systemPropertyVariables;
        this.outputRepository = outputRepository;
        this.outputDescriptor = outputDescriptor;
        this.languages = languages;
        this.formatter = formatter;
        this.skipDependencies = skipDependencies;
    }

    public static enum OutputFormatter {
        JSON{

            @Override
            public void format(Collection<Route> routes, OutputStream outputStream) {
                try (Jsonb jsonb = JsonbBuilder.create((JsonbConfig)new JsonbConfig().withFormatting(Boolean.valueOf(true)).withBinaryDataStrategy("BASE_64").setProperty("johnzon.cdi.activated", (Object)false));){
                    jsonb.toJson(routes, outputStream);
                }
                catch (Exception e) {
                    throw new IllegalStateException(e);
                }
            }
        };


        public boolean needsFileIdMapping() {
            return true;
        }

        public abstract void format(Collection<Route> var1, OutputStream var2);
    }

    private static class MapBuilder {
        private final SortedMap<String, String> queries = new TreeMap<String, String>();

        public static MapBuilder map() {
            return new MapBuilder();
        }

        public MapBuilder with(String k, String v) {
            this.queries.put(k, v);
            return this;
        }

        public SortedMap<String, String> done() {
            return this.queries;
        }

        public SortedMap<String, String> getQueries() {
            return this.queries;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MapBuilder)) {
                return false;
            }
            MapBuilder other = (MapBuilder)o;
            if (!other.canEqual(this)) {
                return false;
            }
            SortedMap<String, String> this$queries = this.getQueries();
            SortedMap<String, String> other$queries = other.getQueries();
            return !(this$queries == null ? other$queries != null : !this$queries.equals(other$queries));
        }

        protected boolean canEqual(Object other) {
            return other instanceof MapBuilder;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            SortedMap<String, String> $queries = this.getQueries();
            result = result * 59 + ($queries == null ? 43 : $queries.hashCode());
            return result;
        }

        public String toString() {
            return "StaticResourceGenerator.MapBuilder(queries=" + this.getQueries() + ")";
        }
    }
}

