/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.tools.webapp.standalone.generator;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.function.BiConsumer;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.json.bind.Jsonb;
import javax.json.bind.JsonbBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.sdk.component.form.api.Client;
import org.talend.sdk.component.form.api.UiSpecService;
import org.talend.sdk.component.form.model.Ui;
import org.talend.sdk.component.server.front.model.ComponentDetail;
import org.talend.sdk.component.server.front.model.ComponentDetailList;
import org.talend.sdk.component.server.front.model.ConfigTypeNode;
import org.talend.sdk.component.server.front.model.ConfigTypeNodes;
import org.talend.sdk.component.tools.webapp.standalone.Route;
import org.talend.sdk.component.tools.webapp.standalone.generator.StaticResourceGenerator;

public class StaticUiSpecGenerator
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(StaticUiSpecGenerator.class);
    private final Map<String, String> systemPropertyVariables;
    private final Collection<String> languages;
    private final Path output;

    public StaticUiSpecGenerator(String[] args) {
        this(Collections.emptyMap(), Stream.of(args[1].split(",")).collect(Collectors.toList()), Paths.get(args[0], new String[0]));
    }

    @Override
    public void run() {
        new StaticResourceGenerator(this.systemPropertyVariables, null, null, this.languages, StaticResourceGenerator.OutputFormatter.JSON, true).generate(routes -> {
            UiSpecService service = new UiSpecService(new Client(){

                public CompletionStage<Map<String, Object>> action(String family, String type, String action, String lang, Map params, Object context) {
                    HashMap result = new HashMap();
                    result.put("items", Collections.emptyList());
                    return CompletableFuture.completedFuture(result);
                }

                public void close() {
                }
            });
            if (!Files.exists(this.output.getParent(), new LinkOption[0])) {
                try {
                    Files.createDirectories(this.output.getParent(), new FileAttribute[0]);
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
            }
            try (Jsonb jsonb = JsonbBuilder.create();
                 JarOutputStream jar = new JarOutputStream(Files.newOutputStream(this.output, new OpenOption[0]));){
                jar.putNextEntry(new JarEntry("configurations/"));
                jar.closeEntry();
                jar.putNextEntry(new JarEntry("components/"));
                jar.closeEntry();
                BiConsumer<String, String> onFile = (name, content) -> {
                    try {
                        jar.putNextEntry(new JarEntry((String)name));
                        jar.write(content.getBytes(StandardCharsets.UTF_8));
                        jar.closeEntry();
                    }
                    catch (IOException e) {
                        throw new IllegalStateException(e);
                    }
                };
                routes.stream().filter(it -> it.getId().startsWith("component_server_component_details_en_")).forEach(r -> {
                    try {
                        this.visitComponentRoute((UiSpecService<Object>)service, jsonb, (Route)r, onFile);
                    }
                    catch (IOException e) {
                        throw new IllegalStateException(e);
                    }
                });
                routes.stream().filter(it -> it.getId().startsWith("component_server_configuration_details_en_")).forEach(r -> {
                    try {
                        this.visitConfigurationRoute((UiSpecService<Object>)service, jsonb, (Route)r, onFile);
                    }
                    catch (IOException e) {
                        throw new IllegalStateException(e);
                    }
                });
                log.info("Created '{}'", (Object)this.output);
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        });
    }

    private void visitConfigurationRoute(UiSpecService<Object> service, Jsonb jsonb, Route route, BiConsumer<String, String> onFile) throws IOException {
        String configId = route.getId().substring("component_server_configuration_details_en_".length());
        String id = new String(Base64.getDecoder().decode(configId), StandardCharsets.UTF_8);
        String family = id.split("#")[1];
        try (ByteArrayInputStream stream = new ByteArrayInputStream(route.getContent());){
            try {
                ConfigTypeNodes nodes = (ConfigTypeNodes)jsonb.fromJson((InputStream)stream, ConfigTypeNodes.class);
                Ui ui = (Ui)service.convert(family, "en", (ConfigTypeNode)nodes.getNodes().values().iterator().next(), null).toCompletableFuture().get();
                onFile.accept("configuration/" + configId, jsonb.toJson((Object)ui));
            }
            catch (InterruptedException | ExecutionException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    private void visitComponentRoute(UiSpecService<Object> service, Jsonb jsonb, Route route, BiConsumer<String, String> onFile) throws IOException {
        try (ByteArrayInputStream stream = new ByteArrayInputStream(route.getContent());){
            try {
                ComponentDetailList list = (ComponentDetailList)jsonb.fromJson((InputStream)stream, ComponentDetailList.class);
                Ui ui = (Ui)service.convert((ComponentDetail)list.getDetails().iterator().next(), "en", null).toCompletableFuture().get();
                onFile.accept("configuration/" + route.getId().substring("component_server_component_details_en_".length()), jsonb.toJson((Object)ui));
            }
            catch (InterruptedException | ExecutionException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    public static void main(String[] args) {
        if (args.length < 2) {
            System.err.println("Usage:\nargs: <where to output the zip> <which langs to use for the generation>  ex:  app output_root_dir lang1,lang2,...");
            return;
        }
        new StaticUiSpecGenerator(args).run();
    }

    public StaticUiSpecGenerator(Map<String, String> systemPropertyVariables, Collection<String> languages, Path output) {
        this.systemPropertyVariables = systemPropertyVariables;
        this.languages = languages;
        this.output = output;
    }
}

