/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.starter.server.service.rrd;

import java.awt.Color;
import java.awt.Paint;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import javax.annotation.PreDestroy;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.Initialized;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.rrd4j.ConsolFun;
import org.rrd4j.DsType;
import org.rrd4j.core.ArcDef;
import org.rrd4j.core.FetchData;
import org.rrd4j.core.RrdBackendFactory;
import org.rrd4j.core.RrdDb;
import org.rrd4j.core.RrdDef;
import org.rrd4j.core.RrdNioBackendFactory;
import org.rrd4j.core.Sample;
import org.rrd4j.core.Util;
import org.rrd4j.graph.RrdGraph;
import org.rrd4j.graph.RrdGraphDef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.sdk.component.starter.server.service.ProjectGenerator;
import org.talend.sdk.component.starter.server.service.rrd.RRDConfig;
import org.talend.sdk.component.starter.server.service.statistic.StatisticService;

@ApplicationScoped
public class RRDStorage {
    private static final Logger log = LoggerFactory.getLogger(RRDStorage.class);
    @Inject
    private RRDConfig config;
    @Inject
    private ProjectGenerator projectGenerator;
    private volatile Stats stats = new Stats();
    private RrdBackendFactory backendFactory;
    private ScheduledExecutorService executor;
    private ScheduledFuture<?> updater;
    private List<String> facets;
    private CompletionStage<RrdDb> db;
    private volatile boolean dbAvailable;
    private volatile boolean savedData;
    private volatile long lastDump = System.currentTimeMillis();

    public void onStart(@Observes @Initialized(value=ApplicationScoped.class) Object startEvt) {
        if (this.config.getSkipped().booleanValue()) {
            return;
        }
        this.facets = this.projectGenerator.getFacets().keySet().stream().map(this::normalizeFacetName).sorted().collect(Collectors.toList());
        int syncPeriod = this.config.getSyncPeriod();
        CompletableFuture<RrdDb> rrdFuture = new CompletableFuture<RrdDb>();
        try {
            this.backendFactory = new RrdNioBackendFactory(syncPeriod, Executors.newScheduledThreadPool(this.config.getSynchronizerThreads(), RRDStorage.newThreadFactory("synchronizer")));
            Path exportFile = this.getExportFile();
            if (!Files.exists(exportFile, new LinkOption[0])) {
                log.info("No existing RRD at '{}', will create the it from scratch", (Object)exportFile);
                Integer heartbeat = this.config.getHeartbeat();
                RrdDef rrdDef = new RrdDef(this.getLocation().toString(), (long)this.config.getSteps().intValue());
                rrdDef.setStartTime(Util.getTime());
                rrdDef.addDatasource("projects!", DsType.GAUGE, (long)heartbeat.intValue(), 0.0, Double.NaN);
                rrdDef.addDatasource("sources!", DsType.GAUGE, (long)heartbeat.intValue(), 0.0, Double.NaN);
                rrdDef.addDatasource("processors!", DsType.GAUGE, (long)heartbeat.intValue(), 0.0, Double.NaN);
                rrdDef.addDatasource("endpoints!", DsType.GAUGE, (long)heartbeat.intValue(), 0.0, Double.NaN);
                this.facets.forEach(k -> rrdDef.addDatasource(k + '!', DsType.GAUGE, (long)heartbeat.intValue(), 0.0, Double.NaN));
                List<Integer> archiveRows = this.config.getArchiveRows();
                if (this.config.getArchiveSteps().size() != archiveRows.size()) {
                    throw new IllegalArgumentException("Ensure archive steps and rows have the same number of values");
                }
                Iterator<Integer> archiveRowsIt = archiveRows.iterator();
                this.config.getArchiveSteps().forEach(step -> rrdDef.addArchive(new ArcDef(ConsolFun.TOTAL, (double)this.config.getArchiveXff().floatValue(), step.intValue(), ((Integer)archiveRowsIt.next()).intValue())));
                rrdFuture.complete(RrdDb.getBuilder().setRrdDef(rrdDef).setBackendFactory(this.backendFactory).build());
                this.db = rrdFuture;
                this.dbAvailable = true;
            } else {
                log.info("Loading RRD '{}'", (Object)exportFile);
                this.db = rrdFuture.thenApply(instance -> {
                    log.info("RRD loaded");
                    this.dbAvailable = true;
                    return instance;
                });
                new Thread(() -> {
                    try {
                        rrdFuture.complete(RrdDb.getBuilder().setPath(this.getLocation().toString()).setExternalPath(exportFile.toString()).setBackendFactory(this.backendFactory).build());
                    }
                    catch (IOException e) {
                        rrdFuture.completeExceptionally(e);
                    }
                }, this.getClass().getName() + "-loader").start();
            }
        }
        catch (IOException e) {
            rrdFuture.completeExceptionally(e);
        }
        this.executor = Executors.newSingleThreadScheduledExecutor(RRDStorage.newThreadFactory("updater"));
        this.updater = this.executor.scheduleAtFixedRate(this::doUpdate, syncPeriod, syncPeriod, TimeUnit.SECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onEvent(@Observes StatisticService.Representation representation) {
        Stats current;
        if (this.config.getSkipped().booleanValue()) {
            return;
        }
        RRDStorage rRDStorage = this;
        synchronized (rRDStorage) {
            current = this.stats;
        }
        current.projects.incrementAndGet();
        if (representation.getOpenapiEndpoints() != null) {
            current.endpoints.addAndGet(representation.getOpenapiEndpoints());
        }
        current.sources.addAndGet(representation.getSourcesCount());
        current.processors.addAndGet(representation.getProcessorsCount());
        if (representation.getFacets() != null) {
            representation.getFacets().stream().map(this::normalizeFacetName).forEach(key -> {
                AtomicLong counter = (AtomicLong)current.facets.get(key);
                if (counter == null) {
                    counter = new AtomicLong();
                    AtomicLong existing = current.facets.putIfAbsent(key, counter);
                    if (existing != null) {
                        counter = existing;
                    }
                }
                counter.incrementAndGet();
            });
        }
    }

    public CompletionStage<FetchData> fetch(long start, long end) {
        return this.db.thenApply(db -> {
            try {
                long correctedEnd;
                long correctedStart = start <= 0L ? db.getArchive(0).getStartTime() : start;
                long l = correctedEnd = end <= 0L ? db.getArchive(0).getEndTime() : end;
                if (correctedStart >= correctedEnd) {
                    throw new IllegalStateException("end can't be before start");
                }
                return db.createFetchRequest(ConsolFun.TOTAL, correctedStart, correctedEnd, this.getFetchStep(correctedStart, correctedEnd)).fetchData();
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        });
    }

    public CompletionStage<InputStream> render(long start, long end, int width, int height) {
        if (this.config.getSkipped().booleanValue()) {
            throw new IllegalStateException("RRD is not active");
        }
        return this.db.thenApply(db -> {
            try {
                long correctedEnd;
                long correctedStart = start <= 0L ? db.getArchive(0).getStartTime() : start;
                long l = correctedEnd = end <= 0L ? db.getArchive(0).getEndTime() : end;
                if (correctedStart >= correctedEnd) {
                    throw new IllegalStateException("end can't be before start");
                }
                if (width <= 0 || height <= 0) {
                    throw new IllegalStateException("height and width can't be null");
                }
                return this.doRender(correctedStart, correctedEnd, width, height);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        });
    }

    private long getFetchStep(long correctedStart, long correctedEnd) {
        return Math.max(1L, (correctedEnd - correctedStart) / (long)this.config.getMaxFetchPoints().intValue());
    }

    private InputStream doRender(long start, long end, int width, int height) throws IOException {
        String rrdPath = this.getLocation().toAbsolutePath().toString();
        RrdGraphDef def = new RrdGraphDef();
        def.setImageFormat("png");
        def.setShowSignature(false);
        def.setWidth(Math.min(width, 4000));
        def.setHeight(Math.min(height, 4000));
        def.setFilename("-");
        def.setTitle("Statistics from " + Util.getDate((long)start) + " to " + Util.getDate((long)end));
        def.setTimeSpan(start, end);
        def.setStep(this.getFetchStep(start, end));
        def.datasource("projects!", rrdPath, "projects!", ConsolFun.TOTAL);
        def.datasource("sources!", rrdPath, "sources!", ConsolFun.TOTAL);
        def.datasource("processors!", rrdPath, "processors!", ConsolFun.TOTAL);
        def.datasource("endpoints!", rrdPath, "endpoints!", ConsolFun.TOTAL);
        this.facets.forEach(k -> {
            String name = k + "!";
            def.datasource(name, rrdPath, name, ConsolFun.TOTAL);
        });
        def.line("projects!", (Paint)Color.GRAY, "#projects", 2.0f);
        def.line("sources!", (Paint)Color.BLUE, "#sources", 2.0f);
        def.line("processors!", (Paint)Color.CYAN, "#processors", 2.0f);
        def.line("endpoints!", (Paint)Color.GREEN, "#endpoints", 2.0f);
        AtomicInteger lastFacetColor = new AtomicInteger();
        this.facets.forEach(k -> def.line(k + '!', (Paint)new Color(100 + lastFacetColor.addAndGet(20) % 255, 0, 0), "#" + k, 2.0f));
        return new ByteArrayInputStream(new RrdGraph(def).getRrdGraphInfo().getBytes());
    }

    @PreDestroy
    private void destroy() {
        if (this.config.getSkipped().booleanValue()) {
            return;
        }
        try {
            this.updater.cancel(true);
            this.executor.shutdownNow();
            try {
                this.executor.awaitTermination(1L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        finally {
            try {
                this.db.thenAccept(db -> {
                    try {
                        this.doDump((RrdDb)db);
                    }
                    finally {
                        try {
                            db.close();
                        }
                        catch (IOException e) {
                            log.error(e.getMessage(), (Throwable)e);
                        }
                    }
                }).toCompletableFuture().get();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (ExecutionException e) {
                log.error(e.getMessage(), e.getCause());
            }
            try {
                this.backendFactory.close();
            }
            catch (IOException e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private void doDump(RrdDb db) {
        if (this.savedData) {
            log.info("Saving RRD");
            try {
                db.exportXml(this.getExportFile().toString());
                this.savedData = false;
            }
            catch (IOException e) {
                log.error("Can't dump the rrd, next restart will likely not be able to reuse it: " + e.getMessage(), (Throwable)e);
            }
        } else {
            log.debug("No project created, no RRD dump update");
        }
    }

    private String normalizeFacetName(String it) {
        return "facet_" + it.replace(' ', '_');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doUpdate() {
        if (!this.dbAvailable) {
            return;
        }
        RRDStorage rRDStorage = this;
        synchronized (rRDStorage) {
            Stats stats = this.stats;
            if (stats.projects.get() == 0L) {
                return;
            }
            this.stats = new Stats();
            this.save(stats);
        }
    }

    private void save(Stats stats) {
        this.db.thenApply(db -> {
            try {
                long now;
                Sample sample = db.createSample();
                sample.setValue("projects!", (double)stats.projects.get());
                sample.setValue("sources!", (double)stats.sources.get());
                sample.setValue("processors!", (double)stats.processors.get());
                sample.setValue("endpoints!", (double)stats.endpoints.get());
                stats.facets.forEach((k, v) -> sample.setValue(k + '!', (double)v.get()));
                sample.update();
                this.savedData = true;
                log.debug("Updated RRD storage");
                long autoDumpTimeout = this.config.getAutoDumpTimeout().intValue();
                if (autoDumpTimeout > 0L && (now = System.currentTimeMillis()) - this.lastDump > autoDumpTimeout) {
                    this.doDump((RrdDb)db);
                    this.lastDump = now;
                }
            }
            catch (IOException e) {
                log.error(e.getMessage() + ", stats: " + stats, (Throwable)e);
            }
            return db;
        });
    }

    private Path getExportFile() {
        return this.ensureParent(this.config.getExport().map(x$0 -> Paths.get(x$0, new String[0])).orElseGet(() -> this.getDefaultLocation("statistics.xml").toAbsolutePath()));
    }

    private Path getLocation() {
        return this.ensureParent(this.config.getLocation().map(x$0 -> Paths.get(x$0, new String[0])).orElseGet(() -> this.getDefaultLocation("statistics.rrd")));
    }

    private Path getDefaultLocation(String name) {
        return this.ensureParent(Paths.get(System.getProperty("meecrowave.base", "target"), new String[0]).resolve("work").resolve(name));
    }

    private Path ensureParent(Path path) {
        if (!Files.exists(path.getParent(), new LinkOption[0])) {
            try {
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
        return path.toAbsolutePath();
    }

    private static ThreadFactory newThreadFactory(final String name) {
        return new ThreadFactory(){
            private final AtomicInteger counter = new AtomicInteger();

            @Override
            public Thread newThread(Runnable task) {
                Thread thread = new Thread(task, this.getClass().getName() + '-' + name + '-' + this.counter.incrementAndGet());
                thread.setPriority(5);
                thread.setDaemon(false);
                return thread;
            }
        };
    }

    private static class Stats {
        private final AtomicLong projects = new AtomicLong();
        private final AtomicLong sources = new AtomicLong();
        private final AtomicLong processors = new AtomicLong();
        private final AtomicLong endpoints = new AtomicLong();
        private final ConcurrentMap<String, AtomicLong> facets = new ConcurrentHashMap<String, AtomicLong>();

        public AtomicLong getProjects() {
            return this.projects;
        }

        public AtomicLong getSources() {
            return this.sources;
        }

        public AtomicLong getProcessors() {
            return this.processors;
        }

        public AtomicLong getEndpoints() {
            return this.endpoints;
        }

        public ConcurrentMap<String, AtomicLong> getFacets() {
            return this.facets;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Stats)) {
                return false;
            }
            Stats other = (Stats)o;
            if (!other.canEqual(this)) {
                return false;
            }
            AtomicLong this$projects = this.getProjects();
            AtomicLong other$projects = other.getProjects();
            if (this$projects == null ? other$projects != null : !this$projects.equals(other$projects)) {
                return false;
            }
            AtomicLong this$sources = this.getSources();
            AtomicLong other$sources = other.getSources();
            if (this$sources == null ? other$sources != null : !this$sources.equals(other$sources)) {
                return false;
            }
            AtomicLong this$processors = this.getProcessors();
            AtomicLong other$processors = other.getProcessors();
            if (this$processors == null ? other$processors != null : !this$processors.equals(other$processors)) {
                return false;
            }
            AtomicLong this$endpoints = this.getEndpoints();
            AtomicLong other$endpoints = other.getEndpoints();
            if (this$endpoints == null ? other$endpoints != null : !this$endpoints.equals(other$endpoints)) {
                return false;
            }
            ConcurrentMap<String, AtomicLong> this$facets = this.getFacets();
            ConcurrentMap<String, AtomicLong> other$facets = other.getFacets();
            return !(this$facets == null ? other$facets != null : !this$facets.equals(other$facets));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Stats;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            AtomicLong $projects = this.getProjects();
            result = result * 59 + ($projects == null ? 43 : $projects.hashCode());
            AtomicLong $sources = this.getSources();
            result = result * 59 + ($sources == null ? 43 : $sources.hashCode());
            AtomicLong $processors = this.getProcessors();
            result = result * 59 + ($processors == null ? 43 : $processors.hashCode());
            AtomicLong $endpoints = this.getEndpoints();
            result = result * 59 + ($endpoints == null ? 43 : $endpoints.hashCode());
            ConcurrentMap<String, AtomicLong> $facets = this.getFacets();
            result = result * 59 + ($facets == null ? 43 : $facets.hashCode());
            return result;
        }

        public String toString() {
            return "RRDStorage.Stats(projects=" + this.getProjects() + ", sources=" + this.getSources() + ", processors=" + this.getProcessors() + ", endpoints=" + this.getEndpoints() + ", facets=" + this.getFacets() + ")";
        }
    }
}

