/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.starter.server.service.facet.util;

import java.util.Locale;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.enterprise.context.ApplicationScoped;
import org.talend.sdk.component.starter.server.service.Strings;
import org.talend.sdk.component.starter.server.service.domain.ProjectRequest;

@ApplicationScoped
public class NameConventions {
    public String toJavaName(String name) {
        return Stream.of(name).flatMap(s -> Stream.of(s.split("[^\\p{Alnum}]"))).map(s -> s.replaceAll("-", "")).map(String::trim).filter(it -> !it.isEmpty()).map(Strings::capitalize).collect(Collectors.joining());
    }

    public String sanitizeConnectionName(String name) {
        return "MAIN".equals(name) ? "__default__" : name.replace("_", "").replace("#", "").replace(" ", "");
    }

    public String toJavaConfigType(String root, String pack, ProjectRequest.Entry entry, BiConsumer<String, ProjectRequest.DataStructure> nestedGenerator) {
        if (entry.getReference() != null && !entry.getReference().isEmpty()) {
            nestedGenerator.accept(entry.getType(), entry.getNestedType());
            return entry.getType().substring(entry.getType().lastIndexOf(46) + 1);
        }
        String type = entry.getType();
        if (type == null || type.isEmpty()) {
            if (entry.getNestedType() != null) {
                String name = (root == null ? "" : root) + Strings.capitalize(entry.getName()) + "Configuration";
                nestedGenerator.accept(name.contains(".") ? name : pack + '.' + name, entry.getNestedType());
                return name;
            }
            return "String";
        }
        switch (type.toLowerCase(Locale.ENGLISH)) {
            case "boolean": {
                return "boolean";
            }
            case "double": {
                return "double";
            }
            case "int": 
            case "integer": {
                return "int";
            }
            case "uri": {
                return "java.net.URI";
            }
            case "url": {
                return "java.net.URL";
            }
            case "file": {
                return "java.io.File";
            }
        }
        String reference = entry.getReference();
        if (reference != null && !reference.trim().isEmpty()) {
            return reference.substring(reference.lastIndexOf(46) + 1);
        }
        return "String";
    }

    public String toSourceName(String name) {
        return this.toJavaName(name) + "Source";
    }

    public String toMapperName(String name) {
        return this.toJavaName(name) + "Mapper";
    }

    public String toProcessorName(ProjectRequest.ProcessorConfiguration processor) {
        boolean isOutput = processor.getOutputStructures() == null || processor.getOutputStructures().isEmpty();
        return this.toJavaName(processor.getName()) + (isOutput ? "Output" : "Processor");
    }

    public String toConfigurationName(String name) {
        return this.toJavaName(name) + "Configuration";
    }

    public String toMapperRecordName(ProjectRequest.SourceConfiguration source) {
        return source.getOutputStructure() == null || source.getOutputStructure().isGeneric() ? Strings.capitalize(source.getName()) + "GenericRecord" : Strings.capitalize(source.getName()) + "Record";
    }
}

