/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.starter.server.service.facet.travis;

import java.util.Collection;
import java.util.stream.Stream;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import org.talend.sdk.component.starter.server.service.domain.Build;
import org.talend.sdk.component.starter.server.service.domain.ProjectRequest;
import org.talend.sdk.component.starter.server.service.event.GeneratorRegistration;
import org.talend.sdk.component.starter.server.service.facet.FacetGenerator;
import org.talend.sdk.component.starter.server.service.info.ServerInfo;

@ApplicationScoped
public class TravisFacet
implements FacetGenerator {
    private FacetGenerator.InMemoryFile travisYml;

    public void register(@Observes GeneratorRegistration init) {
        init.registerFacetType(this);
        this.travisYml = new FacetGenerator.InMemoryFile(".travis.yml", "language: java\njdk:\n- oraclejdk8\nenv:\n  global:\n    - MAVEN_OPTS=\"-Dmaven.artifact.threads=64 -Dorg.slf4j.simpleLogger.log.org.apache.maven.cli.transfer.Slf4jMavenTransferListener=warn\"\ncache:\n  directories:\n  - \"$HOME/.m2\"\ninstall: mvn clean install -DskipTests -Dinvoker.skip=true --batch-mode\nscript: mvn clean install -e --batch-mode\n");
    }

    @Override
    public Stream<FacetGenerator.InMemoryFile> create(String packageBase, Build build, Collection<String> facets, Collection<ProjectRequest.SourceConfiguration> sources, Collection<ProjectRequest.ProcessorConfiguration> processors, ServerInfo.Snapshot versions) {
        return Stream.of(this.travisYml);
    }

    @Override
    public String readme() {
        return "The .travis.yml file created at the root of the project is preconfigured to be able to build a common component. It caches the maven repository to speed up builds and decrease the maven log level to avoid to reach Travis CI output limit too fast for no reason.\n\nMore information can be found at link:https://docs.travis-ci.com/user/getting-started/#To-get-started-with-Travis-CI[Get Started with Travis CI].";
    }

    @Override
    public String description() {
        return "Creates a .travis.yml pre-configured for a component build.";
    }

    @Override
    public String name() {
        return "Travis CI";
    }

    @Override
    public FacetGenerator.Category category() {
        return FacetGenerator.Category.TOOL;
    }
}

