/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.starter.server.service.facet.component;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.talend.sdk.component.starter.server.configuration.StarterConfiguration;
import org.talend.sdk.component.starter.server.service.Strings;
import org.talend.sdk.component.starter.server.service.domain.Build;
import org.talend.sdk.component.starter.server.service.domain.ProjectRequest;
import org.talend.sdk.component.starter.server.service.facet.FacetGenerator;
import org.talend.sdk.component.starter.server.service.facet.util.NameConventions;
import org.talend.sdk.component.starter.server.service.template.TemplateRenderer;

@ApplicationScoped
public class ComponentGenerator {
    private final Comparator<Connection> connectionComparator = (o1, o2) -> {
        if ("__default__".equals(o1.getName())) {
            return -1;
        }
        if ("__default__".equals(o2.getName())) {
            return 1;
        }
        return o1.getName().compareTo(o2.getName());
    };
    @Inject
    private StarterConfiguration config;
    @Inject
    private TemplateRenderer tpl;
    @Inject
    private NameConventions names;
    private byte[] defaultIconContent;

    private static boolean isOutput(ProjectRequest.ProcessorConfiguration p) {
        return p.getOutputStructures() == null || p.getOutputStructures().isEmpty();
    }

    private static boolean isProcessor(ProjectRequest.ProcessorConfiguration p) {
        return !ComponentGenerator.isOutput(p);
    }

    @PostConstruct
    private void init() {
        this.defaultIconContent = "<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 16 16\"><path d=\"M6 14L0 8l1.9-1.9L6 10.2 14.1 2 16 3.9z\"/></svg>".getBytes(StandardCharsets.UTF_8);
    }

    public Stream<FacetGenerator.InMemoryFile> create(final String tuple, final Build build, final String family, final String category, final Collection<ProjectRequest.SourceConfiguration> sources, final Collection<ProjectRequest.ProcessorConfiguration> processors, Collection<ProjectRequest.ReusableConfiguration> configurations) {
        boolean hasService;
        String mainJava = build.getMainJavaDirectory() + '/' + tuple.replace('.', '/');
        HashMap<String, Map<String, String>> messageProperties = new HashMap<String, Map<String, String>>();
        messageProperties.put(tuple, new TreeMap());
        if (family != null && !family.isEmpty()) {
            ((Map)messageProperties.get(tuple)).put(family + "._displayName", family);
        }
        boolean bl = hasService = sources != null && !sources.isEmpty() || processors != null && !processors.isEmpty();
        if (!hasService) {
            return Stream.empty();
        }
        String baseName = this.names.toJavaName(build.getArtifact());
        final String serviceName = baseName + "Service";
        final String usedFamily = Optional.ofNullable(family).orElse(build.getArtifact());
        final String iconResourcesDirectory = build.getMainResourcesDirectory() + "/icons";
        ArrayList<FacetGenerator.InMemoryFile> files = new ArrayList<FacetGenerator.InMemoryFile>();
        files.add(new FacetGenerator.InMemoryFile(mainJava + "/package-info.java", this.tpl.render("generator/component/package-info.mustache", new HashMap<String, Object>(){
            {
                this.put("package", tuple);
                this.put("family", usedFamily);
                this.put("category", Optional.ofNullable(category).orElse(build.getArtifact()));
                this.put("iconResources", iconResourcesDirectory);
            }
        })));
        files.addAll(this.generateIcons(iconResourcesDirectory, usedFamily));
        files.add(new FacetGenerator.InMemoryFile(mainJava + "/service/" + serviceName + ".java", this.tpl.render("generator/component/Service.mustache", new HashMap<String, Object>(){
            {
                this.put("className", serviceName);
                this.put("package", tuple + ".service");
            }
        })));
        configurations.stream().filter(it -> it.getType() != null && !it.getType().isEmpty()).forEach(it -> {
            String lowerType = it.getType().toLowerCase(Locale.ENGLISH);
            String configPck = tuple + '.' + lowerType;
            String name = it.getName().substring(it.getName().lastIndexOf(46) + 1);
            this.generateConfiguration(configPck + '.' + name, configPck, mainJava, it.getStructure(), name, files, lowerType);
            messageProperties.computeIfAbsent(tuple, k -> new TreeMap()).put(family + "." + lowerType + "." + name + "._displayName", name);
            if (it.getStructure() != null) {
                Map i18n = messageProperties.computeIfAbsent(configPck, k -> new TreeMap());
                this.toProperties(name, it.getStructure().getEntries()).flatMap(this::toProperties).forEach(t -> i18n.put(((StringTuple2)t).key, ((StringTuple2)t).value));
            }
        });
        if (sources != null && !sources.isEmpty()) {
            files.addAll(this.createSourceFiles(tuple, iconResourcesDirectory, sources, mainJava, serviceName).collect(Collectors.toList()));
            messageProperties.put(tuple + ".source", (Map<String, String>)new TreeMap<String, String>(){
                {
                    this.putAll(sources.stream().map(source -> new StringTuple2(family + "." + source.getName() + "._displayName", source.getName())).collect(Collectors.toMap(StringTuple2::getKey, StringTuple2::getValue)));
                    this.putAll(sources.stream().filter(source -> source.getConfiguration() != null && source.getConfiguration().getEntries() != null).flatMap(source -> ComponentGenerator.this.toProperties(ComponentGenerator.this.names.toConfigurationName(ComponentGenerator.this.names.toMapperName(source.getName())), source.getConfiguration().getEntries())).flatMap(tuple3 -> ComponentGenerator.this.toProperties(tuple3)).collect(Collectors.toMap(StringTuple2::getKey, StringTuple2::getValue, (k1, k2) -> k1)));
                }
            });
        }
        if (processors != null && !processors.isEmpty()) {
            files.addAll(this.createProcessorFiles(tuple, iconResourcesDirectory, processors, mainJava, serviceName).collect(Collectors.toList()));
            messageProperties.put(tuple + ".output", (Map<String, String>)new TreeMap<String, String>(){
                {
                    this.putAll(processors.stream().filter(x$0 -> ComponentGenerator.isOutput(x$0)).map(processor -> new StringTuple2(family + "." + processor.getName() + "._displayName", processor.getName())).collect(Collectors.toMap(StringTuple2::getKey, StringTuple2::getValue)));
                    this.putAll(processors.stream().filter(processor -> processor.getConfiguration() != null && processor.getConfiguration().getEntries() != null).filter(x$0 -> ComponentGenerator.isOutput(x$0)).flatMap(p -> ComponentGenerator.this.toProperties(ComponentGenerator.this.names.toConfigurationName(ComponentGenerator.this.names.toProcessorName((ProjectRequest.ProcessorConfiguration)p)), p.getConfiguration().getEntries())).flatMap(tuple3 -> ComponentGenerator.this.toProperties(tuple3)).collect(Collectors.toMap(StringTuple2::getKey, StringTuple2::getValue, (k1, k2) -> k1)));
                }
            });
            messageProperties.put(tuple + ".processor", (Map<String, String>)new TreeMap<String, String>(){
                {
                    this.putAll(processors.stream().filter(x$0 -> ComponentGenerator.isProcessor(x$0)).map(processor -> new StringTuple2(family + "." + processor.getName() + "._displayName", processor.getName())).collect(Collectors.toMap(StringTuple2::getKey, StringTuple2::getValue)));
                    this.putAll(processors.stream().filter(processor -> processor.getConfiguration() != null && processor.getConfiguration().getEntries() != null).filter(x$0 -> ComponentGenerator.isProcessor(x$0)).flatMap(p -> ComponentGenerator.this.toProperties(ComponentGenerator.this.names.toConfigurationName(ComponentGenerator.this.names.toProcessorName((ProjectRequest.ProcessorConfiguration)p)), p.getConfiguration().getEntries())).flatMap(tuple3 -> ComponentGenerator.this.toProperties(tuple3)).collect(Collectors.toMap(StringTuple2::getKey, StringTuple2::getValue, (k1, k2) -> k1)));
                }
            });
        }
        files.addAll(this.generateProperties(build.getMainResourcesDirectory(), messageProperties).collect(Collectors.toList()));
        return files.stream();
    }

    private Stream<StringTuple2> toProperties(StringTuple3 entry) {
        return Stream.concat(Stream.of(new StringTuple2(entry.key + "._displayName", entry.value)), this.isStringable(entry) ? Stream.of(new StringTuple2(entry.key + "._placeholder", entry.value + "...")) : Stream.empty());
    }

    private boolean isStringable(StringTuple3 entry) {
        return "string".equalsIgnoreCase(entry.type) || "uri".equalsIgnoreCase(entry.type) || "url".equalsIgnoreCase(entry.type);
    }

    private Stream<StringTuple3> toProperties(String prefix, Collection<ProjectRequest.Entry> structure) {
        return structure.stream().flatMap(e -> {
            String prop = prefix + "." + e.getName();
            StringTuple3 tuple3 = new StringTuple3(prop, e.getName(), e.getType());
            if (e.getNestedType() != null) {
                return Stream.concat(Stream.of(tuple3), this.toProperties(this.names.toConfigurationName(e.getName()), e.getNestedType().getEntries()));
            }
            return Stream.of(tuple3);
        });
    }

    private List<FacetGenerator.InMemoryFile> generateIcons(String iconResourcesDirectory, String iconName) {
        return Arrays.asList(new FacetGenerator.InMemoryFile(String.format("%s/%s.svg", iconResourcesDirectory, iconName), this.defaultIconContent), new FacetGenerator.InMemoryFile(String.format("%s/dark/%s.svg", iconResourcesDirectory, iconName), this.defaultIconContent), new FacetGenerator.InMemoryFile(String.format("%s/light/%s.svg", iconResourcesDirectory, iconName), this.defaultIconContent));
    }

    private Stream<FacetGenerator.InMemoryFile> generateProperties(String mainResourcesDirectory, Map<String, Map<String, String>> messageProperties) {
        return messageProperties.entrySet().stream().map(props -> new FacetGenerator.InMemoryFile(mainResourcesDirectory + "/" + ((String)props.getKey()).replace(".", "/") + "/Messages.properties", this.tpl.render("generator/component/Messages.mustache", new HashMap<String, Object>(){
            {
                this.put("properties", ((Map)props.getValue()).entrySet());
            }
        })));
    }

    private Stream<FacetGenerator.InMemoryFile> createProcessorFiles(final String packageBase, final String iconResourcesDirectory, Collection<ProjectRequest.ProcessorConfiguration> processors, String mainJava, final String serviceName) {
        return processors.stream().flatMap(processor -> {
            boolean isOutput = ComponentGenerator.isOutput(processor);
            final String className = this.names.toProcessorName((ProjectRequest.ProcessorConfiguration)processor);
            final String configurationClassName = this.names.toConfigurationName(className);
            final String processorFinalPackage = isOutput ? "output" : "processor";
            String processorPackage = packageBase + "." + processorFinalPackage;
            ArrayList<FacetGenerator.InMemoryFile> files = new ArrayList<FacetGenerator.InMemoryFile>();
            final List outputNames = !isOutput ? processor.getOutputStructures().entrySet().stream().map(e -> {
                String javaName = this.names.sanitizeConnectionName((String)e.getKey());
                if (((ProjectRequest.StructureConfiguration)e.getValue()).isGeneric()) {
                    return new Connection((String)e.getKey(), javaName, "Record", this.isDefault((String)e.getKey()));
                }
                String outputClassName = Strings.capitalize(processor.getName() + Strings.capitalize(javaName + "Output"));
                this.generateModel(null, processorPackage, mainJava, ((ProjectRequest.StructureConfiguration)e.getValue()).getStructure(), outputClassName, files);
                return new Connection((String)e.getKey(), javaName, outputClassName, this.isDefault((String)e.getKey()));
            }).sorted(this.connectionComparator).collect(Collectors.toList()) : Collections.emptyList();
            final List inputNames = processor.getInputStructures() != null ? processor.getInputStructures().entrySet().stream().map(e -> {
                String javaName = this.names.sanitizeConnectionName((String)e.getKey());
                if (((ProjectRequest.StructureConfiguration)e.getValue()).isGeneric()) {
                    return new Connection((String)e.getKey(), javaName, "Record", this.isDefault((String)e.getKey()));
                }
                String inputClassName = Strings.capitalize(processor.getName() + Strings.capitalize(javaName + "Input"));
                this.generateModel(null, processorPackage, mainJava, ((ProjectRequest.StructureConfiguration)e.getValue()).getStructure(), inputClassName, files);
                return new Connection((String)e.getKey(), javaName, inputClassName, this.isDefault((String)e.getKey()));
            }).sorted(this.connectionComparator).collect(Collectors.toList()) : Collections.emptyList();
            this.generateConfiguration(null, processorPackage, mainJava, processor.getConfiguration(), configurationClassName, files, null);
            final String iconName = Optional.ofNullable(processor.getIcon()).filter(s -> !s.isEmpty()).orElse(processor.getName());
            files.addAll(this.generateIcons(iconResourcesDirectory, iconName));
            files.add(new FacetGenerator.InMemoryFile(mainJava + "/" + processorFinalPackage + "/" + className + ".java", this.tpl.render("generator/component/Processor.mustache", new HashMap<String, Object>(){
                {
                    this.put("name", processor.getName());
                    this.put("className", className);
                    this.put("package", packageBase + "." + processorFinalPackage);
                    this.put("serviceName", serviceName);
                    this.put("servicePackage", packageBase + ".service");
                    this.put("configurationName", configurationClassName);
                    this.put("inputs", inputNames);
                    this.put("hasInputs", inputNames.size() != 0);
                    this.put("outputs", outputNames);
                    this.put("hasOutputs", outputNames.size() != 0);
                    this.put("icon", iconName);
                    this.put("iconResources", iconResourcesDirectory);
                    this.put("generic", outputNames.stream().anyMatch(o -> ((Connection)o).type.equals("Record")) || inputNames.stream().anyMatch(o -> ((Connection)o).type.equals("Record")));
                }
            })));
            return files.stream();
        });
    }

    private boolean isDefault(String name) {
        return "__default__".equals(name);
    }

    private Stream<FacetGenerator.InMemoryFile> createSourceFiles(final String packageBase, final String iconResourcesDirectory, Collection<ProjectRequest.SourceConfiguration> sources, String mainJava, final String serviceName) {
        return sources.stream().flatMap(source -> {
            final boolean generic = source.getOutputStructure() == null || source.getOutputStructure().isGeneric() || source.getOutputStructure().getStructure() == null;
            String baseName = this.names.toJavaName(source.getName());
            final String sourceName = this.names.toSourceName(baseName);
            final String mapperName = this.names.toMapperName(baseName);
            final String configurationClassName = this.names.toConfigurationName(mapperName);
            final String modelClassName = this.names.toMapperRecordName((ProjectRequest.SourceConfiguration)source);
            final String sourcePackage = packageBase + ".source";
            ArrayList<FacetGenerator.InMemoryFile> files = new ArrayList<FacetGenerator.InMemoryFile>();
            final String iconName = Optional.ofNullable(source.getIcon()).filter(s -> !s.isEmpty()).orElse(source.getName());
            files.addAll(this.generateIcons(iconResourcesDirectory, iconName));
            files.add(new FacetGenerator.InMemoryFile(mainJava + "/source/" + mapperName + ".java", this.tpl.render("generator/component/Mapper.mustache", new HashMap<String, Object>(){
                {
                    this.put("generic", generic);
                    this.put("name", source.getName());
                    this.put("className", mapperName);
                    this.put("package", sourcePackage);
                    this.put("serviceName", serviceName);
                    this.put("servicePackage", packageBase + ".service");
                    this.put("configurationName", configurationClassName);
                    this.put("sourceName", sourceName);
                    this.put("infinite", source.isStream());
                    this.put("icon", iconName);
                    this.put("iconResources", iconResourcesDirectory);
                }
            })));
            files.add(new FacetGenerator.InMemoryFile(mainJava + "/source/" + sourceName + ".java", this.tpl.render("generator/component/Source.mustache", new HashMap<String, Object>(){
                {
                    this.put("className", sourceName);
                    this.put("package", sourcePackage);
                    this.put("serviceName", serviceName);
                    this.put("servicePackage", packageBase + ".service");
                    this.put("configurationName", configurationClassName);
                    this.put("modelName", modelClassName);
                    this.put("generic", generic);
                }
            })));
            this.generateConfiguration(null, sourcePackage, mainJava, source.getConfiguration(), configurationClassName, files, null);
            this.generateModel(null, sourcePackage, mainJava, generic ? null : source.getOutputStructure().getStructure(), modelClassName, files);
            return files.stream();
        });
    }

    private void generateModel(final String root, final String packageBase, final String mainJava, final ProjectRequest.DataStructure structure, final String modelClassName, final Collection<FacetGenerator.InMemoryFile> files) {
        if (structure != null) {
            files.add(new FacetGenerator.InMemoryFile(mainJava + "/" + packageBase.substring(packageBase.lastIndexOf(46) + 1) + "/" + modelClassName + ".java", this.tpl.render("generator/component/Model.mustache", new HashMap<String, Object>(){
                {
                    this.put("className", modelClassName);
                    this.put("package", packageBase);
                    this.put("generic", false);
                    if (structure.getEntries() != null) {
                        this.put("structure", structure.getEntries().stream().map(e -> new Property(e.getName(), Strings.capitalize(e.getName()), ComponentGenerator.this.names.toJavaConfigType(root, packageBase, (ProjectRequest.Entry)e, (fqn, nested) -> {
                            int li = fqn.lastIndexOf(46);
                            String pck = li > 0 ? fqn.substring(0, li) : "";
                            String cn = li > 0 ? fqn.substring(li + 1) : fqn;
                            ComponentGenerator.this.generateModel((root == null ? "" : root) + Strings.capitalize(cn), pck, mainJava, e.getNestedType(), cn, files);
                        }), false)).collect(Collectors.toList()));
                    }
                }
            })));
        }
    }

    private void generateConfiguration(final String root, final String packageBase, final String mainJava, final ProjectRequest.DataStructure structure, final String configurationClassName, final Collection<FacetGenerator.InMemoryFile> files, final String type) {
        files.add(new FacetGenerator.InMemoryFile(mainJava + "/" + packageBase.substring(packageBase.lastIndexOf(46) + 1) + "/" + configurationClassName + ".java", this.tpl.render("generator/component/Configuration.mustache", new HashMap<String, Object>(){
            {
                ArrayList imports = new ArrayList();
                boolean hasEntries = structure != null && structure.getEntries() != null;
                List structures = hasEntries ? structure.getEntries().stream().map(e -> {
                    String name = e.getName();
                    String javaConfigType = ComponentGenerator.this.names.toJavaConfigType(root, packageBase, (ProjectRequest.Entry)e, (fqn, nested) -> {
                        String cn;
                        int li = fqn.lastIndexOf(46);
                        String pck = li > 0 ? fqn.substring(0, li) : "";
                        String string = cn = li > 0 ? fqn.substring(li + 1) : fqn;
                        if (!pck.equals(packageBase)) {
                            imports.add(fqn);
                        }
                        if (e.getReference() == null) {
                            ComponentGenerator.this.generateConfiguration(cn.contains(".") ? cn : (root == null ? "" : root) + Strings.capitalize(cn), pck, mainJava, nested, cn, files, null);
                        }
                    });
                    int lastDot = javaConfigType.lastIndexOf(46);
                    if (lastDot > 0 && javaConfigType.substring(0, lastDot).equals(packageBase)) {
                        javaConfigType = javaConfigType.substring(lastDot + 1);
                    }
                    return new Property(name, Strings.capitalize(name), javaConfigType, ComponentGenerator.this.isCredential(name, e.getType()));
                }).collect(Collectors.toList()) : Collections.emptyList();
                imports.sort(String::compareTo);
                this.put("imports", imports);
                this.put("className", configurationClassName);
                this.put("package", packageBase);
                this.put("structure", structures);
                this.put("hasCredential", structures.stream().anyMatch(s -> ((Property)s).isCredential));
                if (type != null) {
                    this.put(type, true);
                    this.put(type + "Name", configurationClassName);
                }
            }
        })));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isCredential(String name, String type) {
        if (name == null) return false;
        if (name.isEmpty()) return false;
        if (!"string".equals(type)) return false;
        if (!this.config.getDictionaryCredentials().stream().anyMatch(name::contains)) return false;
        return true;
    }

    public static class StringTuple3 {
        private final String key;
        private final String value;
        private final String type;

        public StringTuple3(String key, String value, String type) {
            this.key = key;
            this.value = value;
            this.type = type;
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }

        public String getType() {
            return this.type;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof StringTuple3)) {
                return false;
            }
            StringTuple3 other = (StringTuple3)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$key = this.getKey();
            String other$key = other.getKey();
            if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
                return false;
            }
            String this$value = this.getValue();
            String other$value = other.getValue();
            if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            return !(this$type == null ? other$type != null : !this$type.equals(other$type));
        }

        protected boolean canEqual(Object other) {
            return other instanceof StringTuple3;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $key = this.getKey();
            result = result * 59 + ($key == null ? 43 : $key.hashCode());
            String $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            return result;
        }

        public String toString() {
            return "ComponentGenerator.StringTuple3(key=" + this.getKey() + ", value=" + this.getValue() + ", type=" + this.getType() + ")";
        }
    }

    public static class StringTuple2 {
        private final String key;
        private final String value;

        public StringTuple2(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof StringTuple2)) {
                return false;
            }
            StringTuple2 other = (StringTuple2)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$key = this.getKey();
            String other$key = other.getKey();
            if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
                return false;
            }
            String this$value = this.getValue();
            String other$value = other.getValue();
            return !(this$value == null ? other$value != null : !this$value.equals(other$value));
        }

        protected boolean canEqual(Object other) {
            return other instanceof StringTuple2;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $key = this.getKey();
            result = result * 59 + ($key == null ? 43 : $key.hashCode());
            String $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            return result;
        }

        public String toString() {
            return "ComponentGenerator.StringTuple2(key=" + this.getKey() + ", value=" + this.getValue() + ")";
        }
    }

    public static class Connection {
        private final String name;
        private final String javaName;
        private final String type;
        private final boolean isDefault;

        public String getName() {
            return this.name;
        }

        public String getJavaName() {
            return this.javaName;
        }

        public String getType() {
            return this.type;
        }

        public boolean isDefault() {
            return this.isDefault;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Connection)) {
                return false;
            }
            Connection other = (Connection)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isDefault() != other.isDefault()) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$javaName = this.getJavaName();
            String other$javaName = other.getJavaName();
            if (this$javaName == null ? other$javaName != null : !this$javaName.equals(other$javaName)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            return !(this$type == null ? other$type != null : !this$type.equals(other$type));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Connection;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isDefault() ? 79 : 97);
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $javaName = this.getJavaName();
            result = result * 59 + ($javaName == null ? 43 : $javaName.hashCode());
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            return result;
        }

        public String toString() {
            return "ComponentGenerator.Connection(name=" + this.getName() + ", javaName=" + this.getJavaName() + ", type=" + this.getType() + ", isDefault=" + this.isDefault() + ")";
        }

        public Connection(String name, String javaName, String type, boolean isDefault) {
            this.name = name;
            this.javaName = javaName;
            this.type = type;
            this.isDefault = isDefault;
        }
    }

    public static class Property {
        private final String name;
        private final String methodName;
        private final String type;
        private final boolean isCredential;

        public String getName() {
            return this.name;
        }

        public String getMethodName() {
            return this.methodName;
        }

        public String getType() {
            return this.type;
        }

        public boolean isCredential() {
            return this.isCredential;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Property)) {
                return false;
            }
            Property other = (Property)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isCredential() != other.isCredential()) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$methodName = this.getMethodName();
            String other$methodName = other.getMethodName();
            if (this$methodName == null ? other$methodName != null : !this$methodName.equals(other$methodName)) {
                return false;
            }
            String this$type = this.getType();
            String other$type = other.getType();
            return !(this$type == null ? other$type != null : !this$type.equals(other$type));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Property;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isCredential() ? 79 : 97);
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $methodName = this.getMethodName();
            result = result * 59 + ($methodName == null ? 43 : $methodName.hashCode());
            String $type = this.getType();
            result = result * 59 + ($type == null ? 43 : $type.hashCode());
            return result;
        }

        public String toString() {
            return "ComponentGenerator.Property(name=" + this.getName() + ", methodName=" + this.getMethodName() + ", type=" + this.getType() + ", isCredential=" + this.isCredential() + ")";
        }

        public Property(String name, String methodName, String type, boolean isCredential) {
            this.name = name;
            this.methodName = methodName;
            this.type = type;
            this.isCredential = isCredential;
        }
    }
}

