/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.starter.server.service.facet.codenvy;

import java.util.Collection;
import java.util.HashMap;
import java.util.stream.Stream;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.talend.sdk.component.starter.server.service.domain.Build;
import org.talend.sdk.component.starter.server.service.domain.ProjectRequest;
import org.talend.sdk.component.starter.server.service.event.GeneratorRegistration;
import org.talend.sdk.component.starter.server.service.facet.FacetGenerator;
import org.talend.sdk.component.starter.server.service.info.ServerInfo;
import org.talend.sdk.component.starter.server.service.template.TemplateRenderer;

@ApplicationScoped
public class CodenvyFacet
implements FacetGenerator {
    @Inject
    private TemplateRenderer tpl;

    public void register(@Observes GeneratorRegistration init) {
        init.registerFacetType(this);
    }

    @Override
    public String description() {
        return "Pre-configures the project to be usable with Codenvy.";
    }

    @Override
    public String name() {
        return "Codenvy";
    }

    @Override
    public FacetGenerator.Category category() {
        return FacetGenerator.Category.TOOL;
    }

    @Override
    public String readme() {
        return "Codenvy allows you to code on this project from any web browser if you host your sources in a Github repository.\n\nClick on this link and the project will be opened on your account, ready to develop:\n\nimage:http://beta.codenvy.com/factory/resources/codenvy-contribute.svg[Codenvy,link=http://codenvy.io/f?url=https://github.com/@organization@/@repository@,window=\"_blank\"]";
    }

    @Override
    public Stream<FacetGenerator.InMemoryFile> create(String packageBase, final Build build, Collection<String> facets, Collection<ProjectRequest.SourceConfiguration> sources, Collection<ProjectRequest.ProcessorConfiguration> processors, ServerInfo.Snapshot versions) {
        return Stream.of(new FacetGenerator.InMemoryFile(".codenvy.json", this.tpl.render("generator/facet/codenvy/codenvy.json", new HashMap<String, String>(){
            {
                this.put("group", build.getGroup());
                this.put("artifact", build.getArtifact());
                this.put("version", build.getVersion());
            }
        })));
    }
}

