/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.starter.server.service.facet.beam;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.talend.sdk.component.starter.server.service.Strings;
import org.talend.sdk.component.starter.server.service.domain.Build;
import org.talend.sdk.component.starter.server.service.domain.Dependency;
import org.talend.sdk.component.starter.server.service.domain.ProjectRequest;
import org.talend.sdk.component.starter.server.service.event.GeneratorRegistration;
import org.talend.sdk.component.starter.server.service.facet.FacetGenerator;
import org.talend.sdk.component.starter.server.service.facet.util.NameConventions;
import org.talend.sdk.component.starter.server.service.info.ServerInfo;
import org.talend.sdk.component.starter.server.service.template.TemplateRenderer;

@ApplicationScoped
public class BeamFacet
implements FacetGenerator {
    @Inject
    private TemplateRenderer tpl;
    @Inject
    private NameConventions names;

    public void register(@Observes GeneratorRegistration init) {
        init.registerFacetType(this);
    }

    @Override
    public String loggingScope() {
        return "test";
    }

    @Override
    public Stream<FacetGenerator.InMemoryFile> create(String packageBase, Build build, Collection<String> facets, Collection<ProjectRequest.SourceConfiguration> sources, Collection<ProjectRequest.ProcessorConfiguration> processors, ServerInfo.Snapshot versions) {
        boolean hasComponent;
        boolean bl = hasComponent = sources != null && !sources.isEmpty() || processors != null && !processors.isEmpty();
        if (!hasComponent) {
            return Stream.empty();
        }
        String testJava = build.getTestJavaDirectory() + '/' + packageBase.replace('.', '/');
        return Stream.concat(this.createSourceTest(testJava, packageBase, sources), this.createProcessorsTest(testJava, packageBase, processors));
    }

    private Stream<FacetGenerator.InMemoryFile> createSourceTest(String testJava, final String packageBase, Collection<ProjectRequest.SourceConfiguration> sources) {
        return sources.stream().flatMap(source -> {
            final String baseName = this.names.toMapperName(source.getName());
            final String testClassName = baseName + "BeamTest";
            final String configurationClassName = this.names.toConfigurationName(baseName);
            final String mapperName = this.names.toMapperName(baseName);
            final String outputRecordName = this.names.toMapperRecordName((ProjectRequest.SourceConfiguration)source);
            final boolean hasConfig = source.getConfiguration() != null && source.getConfiguration().getEntries() != null && !source.getConfiguration().getEntries().isEmpty();
            final Set configFields = hasConfig ? source.getConfiguration().getEntries().stream().map(e -> Strings.capitalize(e.getName())).collect(Collectors.toSet()) : Collections.emptySet();
            ArrayList<FacetGenerator.InMemoryFile> files = new ArrayList<FacetGenerator.InMemoryFile>();
            files.add(new FacetGenerator.InMemoryFile(testJava + "/source/" + testClassName + ".java", this.tpl.render("generator/facet/beam/BeamSourceTest.mustache", new HashMap<String, Object>(){
                {
                    this.put("rootPackage", packageBase);
                    this.put("classPackage", packageBase + ".source");
                    this.put("testClassName", testClassName);
                    this.put("sourceClassName", baseName);
                    this.put("sourceName", source.getName());
                    this.put("mapperName", mapperName);
                    this.put("hasConfig", hasConfig);
                    this.put("configurationClassName", configurationClassName);
                    this.put("configFields", configFields);
                    this.put("outputRecordName", outputRecordName);
                    this.put("isGeneric", source.getOutputStructure().isGeneric());
                }
            })));
            return files.stream();
        });
    }

    private Stream<FacetGenerator.InMemoryFile> createProcessorsTest(String testJava, final String packageBase, Collection<ProjectRequest.ProcessorConfiguration> processors) {
        return processors.stream().flatMap(processor -> {
            final boolean isOutput = processor.getOutputStructures() == null || processor.getOutputStructures().isEmpty();
            final String baseName = this.names.toProcessorName((ProjectRequest.ProcessorConfiguration)processor);
            final String testClassName = baseName + "BeamTest";
            final String configurationClassName = this.names.toConfigurationName(baseName);
            final String classDir = isOutput ? "output" : "processor";
            final boolean hasConfig = processor.getConfiguration() != null && processor.getConfiguration().getEntries() != null && !processor.getConfiguration().getEntries().isEmpty();
            final Set configFields = hasConfig ? processor.getConfiguration().getEntries().stream().map(e -> Strings.capitalize(e.getName())).collect(Collectors.toSet()) : Collections.emptySet();
            final Set inputBranches = processor.getInputStructures().entrySet().stream().flatMap(in -> {
                final String inName = ((ProjectRequest.StructureConfiguration)in.getValue()).isGeneric() ? "Record" : Strings.capitalize(processor.getName()) + Strings.capitalize(this.names.sanitizeConnectionName((String)in.getKey())) + "Input";
                HashMap<String, String> map = new HashMap<String, String>(){
                    {
                        this.put((String)in.getKey(), inName);
                    }
                };
                return map.entrySet().stream();
            }).collect(Collectors.toSet());
            final Set outputBranches = !isOutput ? processor.getOutputStructures().entrySet().stream().flatMap(e -> {
                final String outName = ((ProjectRequest.StructureConfiguration)e.getValue()).isGeneric() ? "Record" : Strings.capitalize(processor.getName()) + Strings.capitalize(this.names.sanitizeConnectionName((String)e.getKey())) + "Output";
                HashMap<String, String> map = new HashMap<String, String>(){
                    {
                        this.put((String)e.getKey(), outName);
                    }
                };
                return map.entrySet().stream();
            }).collect(Collectors.toSet()) : Collections.emptySet();
            final boolean isGeneric = inputBranches.stream().anyMatch(e -> "Record".equals(e.getValue())) || outputBranches.stream().anyMatch(e -> "Record".equals(e.getValue()));
            ArrayList<FacetGenerator.InMemoryFile> files = new ArrayList<FacetGenerator.InMemoryFile>();
            files.add(new FacetGenerator.InMemoryFile(testJava + "/" + classDir + "/" + testClassName + ".java", this.tpl.render("generator/facet/beam/BeamProcessorTest.mustache", new HashMap<String, Object>(){
                {
                    this.put("rootPackage", packageBase);
                    this.put("classPackage", packageBase + "." + classDir);
                    this.put("testClassName", testClassName);
                    this.put("processorClassName", baseName);
                    this.put("hasConfig", hasConfig);
                    this.put("configurationClassName", configurationClassName);
                    this.put("configFields", configFields);
                    this.put("isOutput", isOutput);
                    this.put("processorName", processor.getName());
                    this.put("inputBranches", inputBranches);
                    this.put("outputBranches", outputBranches);
                    this.put("isGeneric", isGeneric);
                }
            })));
            return files.stream();
        });
    }

    @Override
    public Stream<Dependency> dependencies(Collection<String> facets, ServerInfo.Snapshot versions) {
        return Stream.of(Dependency.junit(), new Dependency("org.talend.sdk.component", "component-runtime-beam", versions.getKit(), "test"), new Dependency("org.talend.sdk.component", "component-runtime-junit", versions.getKit(), "test"), new Dependency("org.talend.sdk.component", "component-runtime-beam-junit", versions.getKit(), "test"), new Dependency("org.hamcrest", "hamcrest-all", "1.3", "test"), new Dependency("org.apache.beam", "beam-runners-direct-java", versions.getBeam(), "test"), new Dependency("org.codehaus.jackson", "jackson-core-asl", versions.getAvroJackson(), "test"), new Dependency("org.codehaus.jackson", "jackson-mapper-asl", versions.getAvroJackson(), "test"));
    }

    @Override
    public String description() {
        return "Generates some tests using beam runtime instead of Talend Component Kit Testing framework.";
    }

    @Override
    public String readme() {
        return "Beam facet generates component tests using Apache Beam testing framework. It executes the tests using a real beam pipeline to go through the runtime constraints of Apache Beam which can be more strict than Talend Component Kit ones.";
    }

    @Override
    public String name() {
        return "Apache Beam";
    }

    @Override
    public FacetGenerator.Category category() {
        return FacetGenerator.Category.RUNTIME;
    }
}

