/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.starter.server.service.facet;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Stream;
import org.talend.sdk.component.starter.server.service.domain.Build;
import org.talend.sdk.component.starter.server.service.domain.Dependency;
import org.talend.sdk.component.starter.server.service.domain.ProjectRequest;
import org.talend.sdk.component.starter.server.service.info.ServerInfo;

public interface FacetGenerator {
    public String description();

    public String name();

    public Category category();

    default public String loggingScope() {
        return "";
    }

    default public String readme() {
        return "";
    }

    default public Stream<InMemoryFile> create(String packageBase, Build build, Collection<String> facets, Collection<ProjectRequest.SourceConfiguration> sources, Collection<ProjectRequest.ProcessorConfiguration> processors, ServerInfo.Snapshot versions) {
        return Stream.empty();
    }

    default public Stream<Dependency> dependencies(Collection<String> facets, ServerInfo.Snapshot versions) {
        return Stream.empty();
    }

    public static enum Category {
        TEST("Test"),
        RUNTIME("Runtime"),
        LIBRARIES("Libraries"),
        TOOL("Tool");

        private final String humanName;

        private Category(String humanName) {
            this.humanName = humanName;
        }

        public String getHumanName() {
            return this.humanName;
        }
    }

    public static class InMemoryFile {
        private final String path;
        private final byte[] content;

        public InMemoryFile(String path, String content) {
            this.path = path;
            this.content = content.replace("\r", "").getBytes(StandardCharsets.UTF_8);
        }

        public String getPath() {
            return this.path;
        }

        public byte[] getContent() {
            return this.content;
        }

        public String toString() {
            return "FacetGenerator.InMemoryFile(path=" + this.getPath() + ", content=" + Arrays.toString(this.getContent()) + ")";
        }

        public InMemoryFile(String path, byte[] content) {
            this.path = path;
            this.content = content;
        }
    }
}

