/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.starter.server.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import org.talend.sdk.component.starter.server.service.facet.FacetGenerator;

@ApplicationScoped
public class ReadmeGenerator {
    public String createReadme(String name, Map<FacetGenerator, List<String>> filesPerFacet) {
        Map facetByCategory = filesPerFacet.keySet().stream().collect(Collectors.toMap(f -> f.category().getHumanName(), f -> new ArrayList<FacetGenerator>(Collections.singletonList(f)), (u, u2) -> {
            if (u == null) {
                return u2;
            }
            u.addAll(u2);
            return u;
        }, TreeMap::new));
        StringBuilder builder = new StringBuilder();
        builder.append("= ").append(name).append("\n\n");
        facetByCategory.forEach((c, f) -> {
            builder.append("== ").append((String)c).append("\n\n");
            f.stream().sorted(Comparator.comparing(FacetGenerator::name)).forEach(facet -> {
                builder.append("=== ").append(facet.name()).append("\n\n");
                builder.append(Optional.ofNullable(facet.readme()).orElseGet(() -> Optional.ofNullable(facet.description()).orElse("")));
                builder.append("\n\n");
                Collection files = (Collection)filesPerFacet.get(facet);
                if (files != null && !files.isEmpty()) {
                    builder.append("==== Files generated by this facet\n\n");
                    files.forEach(file -> builder.append("- ").append((String)file).append("\n"));
                }
                builder.append("\n\n");
            });
        });
        return builder.toString();
    }
}

