/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.starter.server.service;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.talend.sdk.component.starter.server.service.ReadmeGenerator;
import org.talend.sdk.component.starter.server.service.build.BuildGenerator;
import org.talend.sdk.component.starter.server.service.domain.Build;
import org.talend.sdk.component.starter.server.service.domain.Dependency;
import org.talend.sdk.component.starter.server.service.domain.ProjectRequest;
import org.talend.sdk.component.starter.server.service.event.CreateProject;
import org.talend.sdk.component.starter.server.service.event.GeneratorRegistration;
import org.talend.sdk.component.starter.server.service.facet.FacetGenerator;
import org.talend.sdk.component.starter.server.service.facet.component.ComponentGenerator;
import org.talend.sdk.component.starter.server.service.info.ServerInfo;
import org.talend.sdk.component.starter.server.service.openapi.OpenAPIGenerator;
import org.talend.sdk.component.starter.server.service.template.TemplateRenderer;

@ApplicationScoped
public class ProjectGenerator {
    private final Map<String, BuildGenerator> generators = new TreeMap<String, BuildGenerator>(String.CASE_INSENSITIVE_ORDER);
    private final Map<String, FacetGenerator> facets = new TreeMap<String, FacetGenerator>(String.CASE_INSENSITIVE_ORDER);
    @Inject
    private Event<GeneratorRegistration> registrationEvent;
    @Inject
    private ReadmeGenerator readmeGenerator;
    @Inject
    private Event<CreateProject> onCreate;
    @Inject
    private ComponentGenerator componentGenerator;
    @Inject
    private OpenAPIGenerator openAPIGenerator;
    @Inject
    private TemplateRenderer tpl;
    @Inject
    private ServerInfo versions;
    private List<String> scopesOrdering;

    @PostConstruct
    private void init() {
        GeneratorRegistration event = new GeneratorRegistration();
        this.registrationEvent.fire((Object)event);
        this.generators.putAll(event.getBuildGenerators());
        this.facets.putAll(event.getFacetGenerators());
        this.scopesOrdering = Arrays.asList("provided", "compile", "runtime", "test");
    }

    public void generate(ProjectRequest request, OutputStream outputStream) {
        ServerInfo.Snapshot versionSnapshot = this.versions.getSnapshot();
        HashMap<String, byte[]> files = new HashMap<String, byte[]>();
        Build build = this.generateProjectStructure(request, versionSnapshot, files);
        this.componentGenerator.create(request.getPackageBase(), build, request.getFamily(), request.getCategory(), request.getSources(), request.getProcessors(), request.getConfigurations()).forEach(file -> files.put(file.getPath(), file.getContent()));
        this.zip(request, outputStream, files);
    }

    public void generateFromOpenAPI(ProjectRequest request, OutputStream outputStream) {
        ServerInfo.Snapshot versionSnapshot = this.versions.getSnapshot();
        HashMap<String, byte[]> files = new HashMap<String, byte[]>();
        Build build = this.generateProjectStructure(request, versionSnapshot, files);
        this.openAPIGenerator.generate(request.getFamily(), build, request.getPackageBase(), request.getOpenapi()).forEach(file -> files.put(file.getPath(), file.getContent()));
        this.zip(request, outputStream, files);
    }

    private Build generateProjectStructure(ProjectRequest request, ServerInfo.Snapshot versionSnapshot, Map<String, byte[]> files) {
        Collection facets = Optional.ofNullable(request.getFacets()).orElse(Collections.emptyList());
        List<Dependency> dependencies = this.getDependencies(versionSnapshot, facets);
        BuildGenerator generator = this.generators.get(request.getBuildType());
        Build build = generator.createBuild(request.getBuildConfiguration(), request.getPackageBase(), dependencies, facets, versionSnapshot);
        files.put(build.getBuildFileName(), build.getBuildFileContent().getBytes(StandardCharsets.UTF_8));
        Map<FacetGenerator, List<String>> filePerFacet = this.generateFacetFiles(request, versionSnapshot, files, facets, build);
        this.enforceReadme(request, files, filePerFacet);
        this.addLogging(versionSnapshot, files, dependencies, build, filePerFacet);
        this.addWrapper(files, build);
        return build;
    }

    private void zip(ProjectRequest request, OutputStream outputStream, Map<String, byte[]> files) {
        String rootName = request.getBuildConfiguration().getArtifact();
        HashSet createdFolders = new HashSet();
        try (ZipOutputStream zip = new ZipOutputStream(outputStream);){
            new HashSet<String>(files.keySet()).forEach(path -> {
                String[] segments = (rootName + '/' + path).split("/");
                StringBuilder current = new StringBuilder();
                for (int i = 0; i < segments.length && i != segments.length - 1; ++i) {
                    current.append(segments[i]).append('/');
                    String folder = current.toString();
                    if (!createdFolders.add(folder)) continue;
                    try {
                        zip.putNextEntry(new ZipEntry(folder));
                        zip.closeEntry();
                        continue;
                    }
                    catch (IOException e) {
                        throw new IllegalStateException(e);
                    }
                }
            });
            files.forEach((path, content) -> {
                try {
                    zip.putNextEntry(new ZipEntry(rootName + '/' + path));
                    zip.write((byte[])content);
                    zip.closeEntry();
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
            });
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        this.onCreate.fire((Object)new CreateProject(request));
    }

    private void addWrapper(Map<String, byte[]> files, Build build) {
        build.getWrapperFiles().forEach(f -> files.put(f.getPath(), f.getContent()));
    }

    private void addLogging(ServerInfo.Snapshot versionSnapshot, Map<String, byte[]> files, List<Dependency> dependencies, Build build, Map<FacetGenerator, List<String>> filePerFacet) {
        filePerFacet.keySet().stream().map(FacetGenerator::loggingScope).reduce((s1, s2) -> {
            List<String> scopes = Arrays.asList(s1, s2);
            if (scopes.contains("compile")) {
                return "compile";
            }
            if (scopes.contains("provided")) {
                return "provided";
            }
            if (scopes.contains("test")) {
                return "test";
            }
            return s1;
        }).filter(s -> !s.isEmpty()).ifPresent(scope -> {
            dependencies.add(new Dependency("org.apache.logging.log4j", "log4j-slf4j-impl", versionSnapshot.getLog4j2(), (String)scope));
            files.put(("test".equals(scope) ? build.getTestResourcesDirectory() : build.getMainResourcesDirectory()) + "/log4j2.xml", this.tpl.render("generator/logging/log4j2.mustache", Collections.emptyMap()).getBytes(StandardCharsets.UTF_8));
        });
    }

    private void enforceReadme(ProjectRequest request, Map<String, byte[]> files, Map<FacetGenerator, List<String>> filePerFacet) {
        if (!files.containsKey("README.adoc")) {
            files.put("README.adoc", this.readmeGenerator.createReadme(request.getBuildConfiguration().getName(), filePerFacet).getBytes(StandardCharsets.UTF_8));
        }
    }

    private Map<FacetGenerator, List<String>> generateFacetFiles(ProjectRequest request, ServerInfo.Snapshot versionSnapshot, Map<String, byte[]> files, Collection<String> facets, Build build) {
        return facets.stream().map(s -> s.toLowerCase(Locale.ENGLISH)).collect(Collectors.toMap(this.facets::get, f -> {
            FacetGenerator g = this.facets.get(f);
            return g.create(request.getPackageBase(), build, facets, request.getSources(), request.getProcessors(), versionSnapshot).peek(file -> files.put(file.getPath(), file.getContent())).map(FacetGenerator.InMemoryFile::getPath).collect(Collectors.toList());
        }));
    }

    private List<Dependency> getDependencies(ServerInfo.Snapshot versionSnapshot, Collection<String> facets) {
        List<Dependency> dependencies = facets.stream().map(this.facets::get).flatMap(f -> f.dependencies(facets, versionSnapshot)).distinct().sorted((o1, o2) -> {
            int scope2;
            int scope1 = this.scopesOrdering.indexOf(o1.getScope());
            int scopeDiff = scope1 - (scope2 = this.scopesOrdering.indexOf(o2.getScope()));
            if (scopeDiff != 0) {
                return scopeDiff;
            }
            int comp = o1.getGroup().compareTo(o2.getGroup());
            if (comp != 0) {
                return comp;
            }
            return o1.getArtifact().compareTo(o2.getArtifact());
        }).collect(Collectors.toList());
        Dependency componentApi = Dependency.componentApi(versionSnapshot.getApiKit());
        dependencies.remove(componentApi);
        dependencies.add(0, componentApi);
        return dependencies;
    }

    public Map<String, BuildGenerator> getGenerators() {
        return this.generators;
    }

    public Map<String, FacetGenerator> getFacets() {
        return this.facets;
    }
}

