/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.starter.server.front.js;

import java.io.IOException;
import java.util.stream.Stream;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebFilter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

@WebFilter(asyncSupported=true, urlPatterns={"/*"})
public class IndexRedirector
implements Filter {
    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        HttpServletRequest httpServletRequest = (HttpServletRequest)HttpServletRequest.class.cast(servletRequest);
        if (this.exists(httpServletRequest.getRequestURI())) {
            filterChain.doFilter(servletRequest, servletResponse);
        } else {
            filterChain.doFilter((ServletRequest)new HttpServletRequestWrapper(httpServletRequest){

                public String getPathInfo() {
                    return "";
                }

                public String getServletPath() {
                    return "/index.html";
                }
            }, servletResponse);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean exists(String requestURI) {
        if (requestURI.startsWith("/api")) return true;
        if (!Stream.of(".png", ".html", ".js", ".js.map", ".css", ".css.map", ".json", ".ico", ".woff", ".woff2").anyMatch(requestURI::contains)) return false;
        return true;
    }
}

