/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.starter.server.front;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.Providers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.sdk.component.starter.server.configuration.StarterConfiguration;
import org.talend.sdk.component.starter.server.model.ErrorMessage;
import org.talend.sdk.component.starter.server.model.FactoryConfiguration;
import org.talend.sdk.component.starter.server.model.ProjectModel;
import org.talend.sdk.component.starter.server.service.ProjectGenerator;
import org.talend.sdk.component.starter.server.service.domain.ProjectRequest;

@Path(value="project")
@ApplicationScoped
public class ProjectResource {
    private static final Logger log = LoggerFactory.getLogger(ProjectResource.class);
    private static final Annotation[] NO_ANNOTATION = new Annotation[0];
    @Inject
    private ProjectGenerator generator;
    @Inject
    private StarterConfiguration starterConfiguration;
    private FactoryConfiguration configuration;

    @PostConstruct
    private void init() {
        ArrayList<String> buildTypes = new ArrayList<String>(this.generator.getGenerators().keySet());
        buildTypes.sort(String::compareTo);
        Map facets = this.generator.getFacets().values().stream().collect(Collectors.toMap(e -> e.category().getHumanName(), e -> new ArrayList<FactoryConfiguration.Facet>(Collections.singletonList(new FactoryConfiguration.Facet(e.name(), e.description()))), (u, u2) -> {
            if (u == null) {
                return u2;
            }
            u.addAll(u2);
            return u;
        }, TreeMap::new));
        facets.forEach((k, v) -> v.sort(Comparator.comparing(FactoryConfiguration.Facet::getName)));
        this.configuration = new FactoryConfiguration(buildTypes, facets);
    }

    @GET
    @Path(value="configuration")
    @Produces(value={"application/json"})
    public FactoryConfiguration getConfiguration() {
        return this.configuration;
    }

    @POST
    @Path(value="zip/form")
    @Produces(value={"application/zip"})
    public Response createZip(@FormParam(value="project") String compressedModel, @Context Providers providers) {
        ProjectModel model = this.readProjectModel(compressedModel, providers);
        String filename = Optional.ofNullable(model.getArtifact()).orElse("zip") + ".zip";
        return Response.ok().entity(out -> {
            this.generator.generate(this.toRequest(model), out);
            out.flush();
        }).header("Content-Disposition", (Object)("inline; filename=" + filename)).build();
    }

    @POST
    @Path(value="openapi/zip/form")
    @Produces(value={"application/zip"})
    public Response createOpenAPIZip(@FormParam(value="project") String compressedModel, @Context Providers providers) {
        ProjectModel model = this.readProjectModel(compressedModel, providers);
        String filename = Optional.ofNullable(model.getArtifact()).orElse("zip") + ".zip";
        return Response.ok().entity(out -> {
            this.generator.generateFromOpenAPI(this.toRequest(model), out);
            out.flush();
        }).header("Content-Disposition", (Object)("inline; filename=" + filename)).build();
    }

    @POST
    @Path(value="zip")
    @Produces(value={"application/zip"})
    @Consumes(value={"application/json"})
    public StreamingOutput createZip(ProjectModel model) {
        return out -> {
            this.generator.generate(this.toRequest(model), out);
            out.flush();
        };
    }

    @POST
    @Path(value="openapi/zip")
    @Produces(value={"application/zip"})
    @Consumes(value={"application/json"})
    public StreamingOutput createOpenAPIZip(ProjectModel model) {
        return out -> {
            this.generator.generateFromOpenAPI(this.toRequest(model), out);
            out.flush();
        };
    }

    private ProjectModel readProjectModel(String compressedModel, Providers providers) {
        ProjectModel model;
        MessageBodyReader jsonReader = providers.getMessageBodyReader(ProjectModel.class, ProjectModel.class, NO_ANNOTATION, MediaType.APPLICATION_JSON_TYPE);
        try (ByteArrayInputStream gzipInputStream = new ByteArrayInputStream(this.debase64(compressedModel));){
            model = (ProjectModel)jsonReader.readFrom(ProjectModel.class, ProjectModel.class, NO_ANNOTATION, MediaType.APPLICATION_JSON_TYPE, (MultivaluedMap)new MultivaluedHashMap(), (InputStream)gzipInputStream);
        }
        catch (IOException e) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)new ErrorMessage(e.getMessage())).type(MediaType.APPLICATION_JSON_TYPE).build());
        }
        return model;
    }

    private byte[] debase64(String compressedModel) {
        try {
            return Base64.getUrlDecoder().decode(compressedModel);
        }
        catch (IllegalArgumentException iae) {
            return Base64.getDecoder().decode(compressedModel);
        }
    }

    private ProjectRequest toRequest(ProjectModel model) {
        String group = Optional.ofNullable(model.getGroup()).orElse("com.component").replace('/', '.');
        if (group.endsWith(".")) {
            group = group.substring(0, group.length() - 1);
        }
        if (group.isEmpty()) {
            group = "component";
        }
        String rootPackage = Optional.ofNullable(model.getPackageBase()).orElse("com.application").replace('/', '.');
        Map reusableConfigs = Optional.ofNullable(model.getDatastores()).map(Collection::stream).map(rs -> this.mapReusableConfig((Stream<ProjectModel.ReusableStructure>)rs, "datastore", rootPackage, (Map<String, ProjectRequest.ReusableConfiguration>)new HashMap<String, ProjectRequest.ReusableConfiguration>())).orElseGet(Stream::empty).collect(Collectors.toMap(ProjectRequest.ReusableConfiguration::getId, Function.identity()));
        reusableConfigs.putAll(Optional.ofNullable(model.getDatasets()).map(Collection::stream).map(rs -> this.mapReusableConfig((Stream<ProjectModel.ReusableStructure>)rs, "dataset", rootPackage, reusableConfigs)).orElseGet(Stream::empty).collect(Collectors.toMap(ProjectRequest.ReusableConfiguration::getId, Function.identity())));
        return new ProjectRequest(Optional.ofNullable(model.getBuildType()).orElse("maven").toLowerCase(Locale.ENGLISH), new ProjectRequest.BuildConfiguration(Optional.ofNullable(model.getName()).orElse("A Talend generated Component Starter Project"), Optional.ofNullable(model.getDescription()).orElse("An application generated by the Talend Component Kit Starter"), "jar", group, Optional.ofNullable(model.getArtifact()).orElse("application"), Optional.ofNullable(model.getVersion()).orElse("0.0.1-SNAPSHOT"), "1.8"), rootPackage, Optional.ofNullable(model.getFacets()).orElse(Collections.emptyList()), Optional.ofNullable(model.getSources()).map(s -> s.stream().map(i -> new ProjectRequest.SourceConfiguration(i.getName(), i.getIcon(), i.isStream(), this.toStructure(false, i.getConfigurationStructure(), true, reusableConfigs).getStructure(), this.toStructure(i.isGenericOutput(), i.getOutputStructure(), false, reusableConfigs))).collect(Collectors.toList())).orElse(Collections.emptyList()), Optional.ofNullable(model.getProcessors()).map(s -> s.stream().map(i -> new ProjectRequest.ProcessorConfiguration(i.getName(), i.getIcon(), this.toStructure(false, i.getConfigurationStructure(), true, reusableConfigs).getStructure(), this.mapStructures(i.getInputStructures(), reusableConfigs), this.mapStructures(i.getOutputStructures(), reusableConfigs))).collect(Collectors.toList())).orElse(Collections.emptyList()), reusableConfigs.values(), model.getFamily(), model.getCategory(), model.getOpenapi());
    }

    private Stream<ProjectRequest.ReusableConfiguration> mapReusableConfig(Stream<ProjectModel.ReusableStructure> rs, String type, String basePck, Map<String, ProjectRequest.ReusableConfiguration> reusableConfigs) {
        return rs.map(it -> new ProjectRequest.ReusableConfiguration(it.getId(), basePck + '.' + type + '.' + this.ensureUnAmbiguousName(type, it.getName()), this.toStructure(false, it.getStructure(), true, reusableConfigs).getStructure(), type));
    }

    private String ensureUnAmbiguousName(String type, String name) {
        if (type.equalsIgnoreCase(name)) {
            return "Custom" + name;
        }
        return name;
    }

    private Map<String, ProjectRequest.StructureConfiguration> mapStructures(Collection<ProjectModel.NamedModel> inputStructures, Map<String, ProjectRequest.ReusableConfiguration> reusableConfigs) {
        return Optional.ofNullable(inputStructures).map(is -> is.stream().collect(Collectors.toMap(n -> this.unifiedName(n.getName()), nm -> this.toStructure(nm.isGeneric(), nm.getStructure(), false, reusableConfigs)))).orElse(Collections.emptyMap());
    }

    private String unifiedName(String name) {
        if ("MAIN".equalsIgnoreCase(name)) {
            return "__default__";
        }
        return name;
    }

    private ProjectRequest.StructureConfiguration toStructure(boolean generic, ProjectModel.Model model, boolean rootConfiguration, Map<String, ProjectRequest.ReusableConfiguration> reusableConfigs) {
        boolean hasEntries;
        if (generic) {
            return new ProjectRequest.StructureConfiguration(null, generic);
        }
        boolean bl = hasEntries = model != null && model.getEntries() != null;
        if (!hasEntries) {
            if (rootConfiguration) {
                return new ProjectRequest.StructureConfiguration(new ProjectRequest.DataStructure(new ArrayList<ProjectRequest.Entry>()), generic);
            }
            return new ProjectRequest.StructureConfiguration(null, generic);
        }
        return new ProjectRequest.StructureConfiguration(new ProjectRequest.DataStructure(model.getEntries().stream().map(e -> {
            if (e.getReference() != null && !e.getReference().isEmpty()) {
                ProjectRequest.ReusableConfiguration reusableConfiguration = (ProjectRequest.ReusableConfiguration)reusableConfigs.get(e.getReference());
                if (reusableConfiguration == null) {
                    return null;
                }
                return new ProjectRequest.Entry(e.getName(), reusableConfiguration.getName(), e.getReference(), null);
            }
            return new ProjectRequest.Entry(e.getName(), e.getType(), e.getReference(), e.getModel() != null ? this.toStructure(false, e.getModel(), false, reusableConfigs).getStructure() : null);
        }).filter(Objects::nonNull).collect(Collectors.toList())), generic);
    }
}

