/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.starter.server.front;

import java.io.IOException;
import java.io.InputStream;
import java.time.ZonedDateTime;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.json.Json;
import javax.json.JsonObject;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
@Path(value="demo")
public class ApiDemoEndpoints {
    private static final Logger log = LoggerFactory.getLogger(ApiDemoEndpoints.class);
    private static final String RES_ROOT = "demo";
    private static final String RES_VERSION = "/{version}";
    private static final String PATH_ENVIRONMENT = "/api/v1/environment";
    private static final String PATH_CACHE_RESET = "/api/v1/cache/clear";
    private static final String PATH_ACTION_INDEX = "/api/v1/action/index";
    private static final String PATH_ACTION_EXECUTE = "/api/v1/action/execute";
    private static final String PATH_COMPONENT_INDEX = "/api/v1/component/index";
    private static final String PATH_COMPONENT_DETAILS = "/api/v1/component/details";
    private static final String PATH_COMPONENT_DEPENDENCIES = "/api/v1/component/dependencies";
    private static final String PATH_COMPONENT_DEPENDENCY = "/api/v1/component/dependency";
    private static final String PATH_COMPONENT_ICON = "/api/v1/component/icon";
    private static final String PATH_COMPONENT_ICON_FAMILY = "/api/v1/component/icon/family";
    private static final String PATH_COMPONENT_MIGRATE = "/api/v1/component/migrate";
    private static final String PATH_CONFIGURATIONTYPE_INDEX = "/api/v1/configurationtype/index";
    private static final String PATH_CONFIGURATIONTYPE_DETAILS = "/api/v1/configurationtype/details";
    private static final String PATH_CONFIGURATIONTYPE_MIGRATE = "/api/v1/configurationtype/migrate";
    public static final String HEADER_ACCESS_CONTROL_ALLOW_ORIGIN = "Access-Control-Allow-Origin";
    public static final String HEADER_ACCESS_CONTROL_ALLOW_METHODS = "Access-Control-Allow-Methods";
    public static final String HEADER_ACCESS_CONTROL_ALLOW_HEADERS = "Access-Control-Allow-Headers";
    public static final String VALUE_ACCESS_CONTROL_ALLOW_HEADERS = "Content-Type, api_key, Authorization";
    public static final String VALUE_ACCESS_CONTROL_ALLOW_ORIGIN = "*";
    public static final String VALUE_ACCESS_CONTROL_ALLOW_METHODS = "GET, POST, DELETE, PUT, PATCH, OPTIONS";
    private final byte[] ENVIRONMENT;
    private final Object ACTION_INDEX;
    private final Object ACTION_EXECUTE;
    private final Object COMPONENT_INDEX;
    private final Object COMPONENT_DETAILS;
    private final Object COMPONENT_DEPENDENCIES;
    private final Object COMPONENT_DEPENDENCY;
    private final Object COMPONENT_ICON;
    private final Object COMPONENT_ICON_FAMILY;
    private final Object COMPONENT_MIGRATE;
    private final Object CONFIGURATIONTYPE_INDEX;
    private final Object CONFIGURATIONTYPE_DETAILS;
    private final Object CONFIGURATIONTYPE_MIGRATE;

    public ApiDemoEndpoints() {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        this.ENVIRONMENT = this.getResponseContent(loader, "demo/api/v1/environment");
        this.ACTION_INDEX = this.getResponseContent(loader, "demo/api/v1/action/index");
        this.ACTION_EXECUTE = this.getResponseContent(loader, "demo/api/v1/action/execute");
        this.COMPONENT_INDEX = this.getResponseContent(loader, "demo/api/v1/component/index");
        this.COMPONENT_DETAILS = this.getResponseContent(loader, "demo/api/v1/component/details");
        this.COMPONENT_DEPENDENCIES = this.getResponseContent(loader, "demo/api/v1/component/dependencies");
        this.COMPONENT_DEPENDENCY = this.getResponseContent(loader, "demo/api/v1/component/dependency");
        this.COMPONENT_ICON = this.getResponseContent(loader, "demo/api/v1/component/icon/Y29tcG9uZW50cyNNb2NrI01vY2tJbnB1dA");
        this.COMPONENT_ICON_FAMILY = this.getResponseContent(loader, "demo/api/v1/component/icon/family/Y29tcG9uZW50cyNNb2Nr");
        this.COMPONENT_MIGRATE = this.getResponseContent(loader, "demo/api/v1/component/migrate/Y29tcG9uZW50cyNNb2NrI01vY2tJbnB1dA/1");
        this.CONFIGURATIONTYPE_INDEX = this.getResponseContent(loader, "demo/api/v1/configurationtype/index");
        this.CONFIGURATIONTYPE_DETAILS = this.getResponseContent(loader, "demo/api/v1/configurationtype/details");
        this.CONFIGURATIONTYPE_MIGRATE = this.getResponseContent(loader, "demo/api/v1/configurationtype/migrate/Y29tcG9uZW50cyNNb2NrI2RhdGFzZXQjdGFibGU/1");
    }

    private byte[] getResponseContent(ClassLoader loader, String request) {
        byte[] byArray;
        block8: {
            InputStream stream = loader.getResourceAsStream(request);
            try {
                byte[] result = new byte[stream.available()];
                stream.read(result);
                log.debug(String.format("%s - %d bytes.", request, result.length));
                byArray = result;
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    log.error(e.getMessage());
                    throw new IllegalStateException(e);
                }
            }
            stream.close();
        }
        return byArray;
    }

    @GET
    @Path(value="/{version}/api/v1/environment")
    @Produces(value={"application/json"})
    public Response environment(@PathParam(value="version") String version) {
        JsonObject env = Json.createObjectBuilder().add("commit", "daf300ad598d186007007984481df02a5b21dcaa").add("lastUpdated", "2020-12-18T18:06:03.43Z[UTC]").add("latestApiVersion", 1).add("time", ZonedDateTime.now().toString()).add("version", version).build();
        return Response.ok((Object)env).header(HEADER_ACCESS_CONTROL_ALLOW_ORIGIN, (Object)VALUE_ACCESS_CONTROL_ALLOW_ORIGIN).header(HEADER_ACCESS_CONTROL_ALLOW_METHODS, (Object)VALUE_ACCESS_CONTROL_ALLOW_METHODS).header(HEADER_ACCESS_CONTROL_ALLOW_HEADERS, (Object)VALUE_ACCESS_CONTROL_ALLOW_HEADERS).type(MediaType.APPLICATION_JSON_TYPE).build();
    }

    @GET
    @Path(value="/{version}/api/v1/cache/clear")
    public Response clearCaches() {
        return Response.noContent().build();
    }

    @GET
    @Path(value="/{version}/api/v1/action/index")
    @Produces(value={"application/json"})
    public Response actionIndex(@PathParam(value="version") String version, @QueryParam(value="type") String[] types, @QueryParam(value="family") String[] families, @QueryParam(value="language") String lang) {
        return Response.ok((Object)this.ACTION_INDEX).header(HEADER_ACCESS_CONTROL_ALLOW_ORIGIN, (Object)VALUE_ACCESS_CONTROL_ALLOW_ORIGIN).header(HEADER_ACCESS_CONTROL_ALLOW_METHODS, (Object)VALUE_ACCESS_CONTROL_ALLOW_METHODS).header(HEADER_ACCESS_CONTROL_ALLOW_HEADERS, (Object)VALUE_ACCESS_CONTROL_ALLOW_HEADERS).type(MediaType.APPLICATION_JSON_TYPE).build();
    }

    @POST
    @Path(value="/{version}/api/v1/action/execute")
    @Produces(value={"application/json"})
    public Response actionExecute(@PathParam(value="version") String version, @QueryParam(value="family") String family, @QueryParam(value="type") String type, @QueryParam(value="action") String action, @QueryParam(value="lang") String lang) {
        return Response.ok((Object)this.ACTION_EXECUTE).header(HEADER_ACCESS_CONTROL_ALLOW_ORIGIN, (Object)VALUE_ACCESS_CONTROL_ALLOW_ORIGIN).header(HEADER_ACCESS_CONTROL_ALLOW_METHODS, (Object)VALUE_ACCESS_CONTROL_ALLOW_METHODS).header(HEADER_ACCESS_CONTROL_ALLOW_HEADERS, (Object)VALUE_ACCESS_CONTROL_ALLOW_HEADERS).type(MediaType.APPLICATION_JSON_TYPE).build();
    }

    @GET
    @Path(value="/{version}/api/v1/component/index")
    @Produces(value={"application/json"})
    public Response componentIndex(@PathParam(value="version") String version, @QueryParam(value="language") @DefaultValue(value="en") String language, @QueryParam(value="includeIconContent") @DefaultValue(value="false") boolean includeIconContent, @QueryParam(value="q") String query) {
        return Response.ok((Object)this.COMPONENT_INDEX).header(HEADER_ACCESS_CONTROL_ALLOW_ORIGIN, (Object)VALUE_ACCESS_CONTROL_ALLOW_ORIGIN).header(HEADER_ACCESS_CONTROL_ALLOW_METHODS, (Object)VALUE_ACCESS_CONTROL_ALLOW_METHODS).header(HEADER_ACCESS_CONTROL_ALLOW_HEADERS, (Object)VALUE_ACCESS_CONTROL_ALLOW_HEADERS).type(MediaType.APPLICATION_JSON_TYPE).build();
    }

    @GET
    @Path(value="/{version}/api/v1/component/details")
    @Produces(value={"application/json"})
    public Response componentDetails(@PathParam(value="version") String version, @QueryParam(value="language") @DefaultValue(value="en") String language, @QueryParam(value="identifiers") String[] ids) {
        return Response.ok((Object)this.COMPONENT_DETAILS).header(HEADER_ACCESS_CONTROL_ALLOW_ORIGIN, (Object)VALUE_ACCESS_CONTROL_ALLOW_ORIGIN).header(HEADER_ACCESS_CONTROL_ALLOW_METHODS, (Object)VALUE_ACCESS_CONTROL_ALLOW_METHODS).header(HEADER_ACCESS_CONTROL_ALLOW_HEADERS, (Object)VALUE_ACCESS_CONTROL_ALLOW_HEADERS).type(MediaType.APPLICATION_JSON_TYPE).build();
    }

    @GET
    @Path(value="/{version}/api/v1/component/dependencies")
    @Produces(value={"application/json"})
    public Response componentDependencies(@PathParam(value="version") String version, @QueryParam(value="identifier") String[] ids) {
        return Response.ok((Object)this.COMPONENT_DEPENDENCIES).header(HEADER_ACCESS_CONTROL_ALLOW_ORIGIN, (Object)VALUE_ACCESS_CONTROL_ALLOW_ORIGIN).header(HEADER_ACCESS_CONTROL_ALLOW_METHODS, (Object)VALUE_ACCESS_CONTROL_ALLOW_METHODS).header(HEADER_ACCESS_CONTROL_ALLOW_HEADERS, (Object)VALUE_ACCESS_CONTROL_ALLOW_HEADERS).type(MediaType.APPLICATION_JSON_TYPE).build();
    }

    @GET
    @Path(value="/{version}/api/v1/component/dependency/{id}")
    @Produces(value={"application/octet-stream"})
    public Response componentDependency(@PathParam(value="version") String version, @PathParam(value="id") String id) {
        return Response.ok((Object)this.COMPONENT_DEPENDENCIES).header(HEADER_ACCESS_CONTROL_ALLOW_ORIGIN, (Object)VALUE_ACCESS_CONTROL_ALLOW_ORIGIN).header(HEADER_ACCESS_CONTROL_ALLOW_METHODS, (Object)VALUE_ACCESS_CONTROL_ALLOW_METHODS).header(HEADER_ACCESS_CONTROL_ALLOW_HEADERS, (Object)VALUE_ACCESS_CONTROL_ALLOW_HEADERS).type(MediaType.APPLICATION_OCTET_STREAM_TYPE).build();
    }

    @GET
    @Path(value="/{version}/api/v1/component/icon/{id}")
    @Produces(value={"application/octet-stream"})
    public Response componentIcon(@PathParam(value="version") String version, @PathParam(value="id") String id) {
        return Response.ok((Object)this.COMPONENT_ICON).header(HEADER_ACCESS_CONTROL_ALLOW_ORIGIN, (Object)VALUE_ACCESS_CONTROL_ALLOW_ORIGIN).header(HEADER_ACCESS_CONTROL_ALLOW_METHODS, (Object)VALUE_ACCESS_CONTROL_ALLOW_METHODS).header(HEADER_ACCESS_CONTROL_ALLOW_HEADERS, (Object)VALUE_ACCESS_CONTROL_ALLOW_HEADERS).type(MediaType.APPLICATION_OCTET_STREAM_TYPE).build();
    }

    @GET
    @Path(value="/{version}/api/v1/component/icon/family/{id}")
    @Produces(value={"application/octet-stream"})
    public Response componentIconFamily(@PathParam(value="version") String version, @PathParam(value="id") String id) {
        return Response.ok((Object)this.COMPONENT_ICON_FAMILY).header(HEADER_ACCESS_CONTROL_ALLOW_ORIGIN, (Object)VALUE_ACCESS_CONTROL_ALLOW_ORIGIN).header(HEADER_ACCESS_CONTROL_ALLOW_METHODS, (Object)VALUE_ACCESS_CONTROL_ALLOW_METHODS).header(HEADER_ACCESS_CONTROL_ALLOW_HEADERS, (Object)VALUE_ACCESS_CONTROL_ALLOW_HEADERS).type(MediaType.APPLICATION_OCTET_STREAM_TYPE).build();
    }

    @POST
    @Path(value="/{version}/api/v1/component/migrate/{id}/{configurationVersion}")
    @Produces(value={"application/json"})
    public Response componentMigrate(@PathParam(value="version") String version, @PathParam(value="id") String id, @PathParam(value="configurationVersion") int migrateVersion, Map<String, String> config) {
        return Response.ok((Object)this.COMPONENT_MIGRATE).header(HEADER_ACCESS_CONTROL_ALLOW_ORIGIN, (Object)VALUE_ACCESS_CONTROL_ALLOW_ORIGIN).header(HEADER_ACCESS_CONTROL_ALLOW_METHODS, (Object)VALUE_ACCESS_CONTROL_ALLOW_METHODS).header(HEADER_ACCESS_CONTROL_ALLOW_HEADERS, (Object)VALUE_ACCESS_CONTROL_ALLOW_HEADERS).type(MediaType.APPLICATION_JSON_TYPE).build();
    }

    @GET
    @Path(value="/{version}/api/v1/configurationtype/index")
    @Produces(value={"application/json"})
    public Response configurationtypeIndex(@PathParam(value="version") String version, @QueryParam(value="language") @DefaultValue(value="en") String language, @QueryParam(value="lightPayload") @DefaultValue(value="true") boolean lightPayload, @QueryParam(value="q") String query) {
        return Response.ok((Object)this.CONFIGURATIONTYPE_INDEX).header(HEADER_ACCESS_CONTROL_ALLOW_ORIGIN, (Object)VALUE_ACCESS_CONTROL_ALLOW_ORIGIN).header(HEADER_ACCESS_CONTROL_ALLOW_METHODS, (Object)VALUE_ACCESS_CONTROL_ALLOW_METHODS).header(HEADER_ACCESS_CONTROL_ALLOW_HEADERS, (Object)VALUE_ACCESS_CONTROL_ALLOW_HEADERS).type(MediaType.APPLICATION_JSON_TYPE).build();
    }

    @GET
    @Path(value="/{version}/api/v1/configurationtype/details")
    @Produces(value={"application/json"})
    public Response configurationtypeDetails(@PathParam(value="version") String version, @QueryParam(value="language") @DefaultValue(value="en") String language, @QueryParam(value="identifiers") String[] ids) {
        return Response.ok((Object)this.CONFIGURATIONTYPE_DETAILS).header(HEADER_ACCESS_CONTROL_ALLOW_ORIGIN, (Object)VALUE_ACCESS_CONTROL_ALLOW_ORIGIN).header(HEADER_ACCESS_CONTROL_ALLOW_METHODS, (Object)VALUE_ACCESS_CONTROL_ALLOW_METHODS).header(HEADER_ACCESS_CONTROL_ALLOW_HEADERS, (Object)VALUE_ACCESS_CONTROL_ALLOW_HEADERS).type(MediaType.APPLICATION_JSON_TYPE).build();
    }

    @POST
    @Path(value="/{version}/api/v1/configurationtype/migrate/{id}/{configurationVersion}")
    @Produces(value={"application/json"})
    public Response configurationtypeMigrate(@PathParam(value="version") String version, @PathParam(value="id") String id, @PathParam(value="configurationVersion") int migrateVersion, Map<String, String> config) {
        return Response.ok((Object)this.CONFIGURATIONTYPE_MIGRATE).header(HEADER_ACCESS_CONTROL_ALLOW_ORIGIN, (Object)VALUE_ACCESS_CONTROL_ALLOW_ORIGIN).header(HEADER_ACCESS_CONTROL_ALLOW_METHODS, (Object)VALUE_ACCESS_CONTROL_ALLOW_METHODS).header(HEADER_ACCESS_CONTROL_ALLOW_HEADERS, (Object)VALUE_ACCESS_CONTROL_ALLOW_HEADERS).type(MediaType.APPLICATION_JSON_TYPE).build();
    }
}

