/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.starter.server.configuration;

import java.io.IOException;
import java.util.EnumSet;
import java.util.Set;
import javax.inject.Inject;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterRegistration;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import org.apache.catalina.filters.HttpHeaderSecurityFilter;
import org.talend.sdk.component.starter.server.configuration.StarterConfiguration;

public class ServletConfigurer
implements ServletContainerInitializer {
    public void onStartup(Set<Class<?>> set, ServletContext servletContext) {
        this.addFilter(servletContext, "security-filter", HttpHeaderSecurityFilter.class);
        this.addFilter(servletContext, "encoding-filter", EncodingFilter.class);
        this.addFilter(servletContext, "csp-filter", CSPFilter.class);
    }

    private void addFilter(ServletContext servletContext, String name, Class<? extends Filter> type) {
        FilterRegistration.Dynamic reg = servletContext.addFilter(name, type);
        reg.setAsyncSupported(true);
        reg.addMappingForUrlPatterns(EnumSet.allOf(DispatcherType.class), true, new String[]{"/*"});
    }

    public static class EncodingFilter
    implements Filter {
        public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
            response.setCharacterEncoding("UTF-8");
            chain.doFilter(request, response);
        }
    }

    public static class CSPFilter
    implements Filter {
        @Inject
        private StarterConfiguration configuration;

        public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
            ((HttpServletResponse)HttpServletResponse.class.cast(servletResponse)).addHeader("Content-Security-Policy", this.configuration.getCsp());
            filterChain.doFilter(servletRequest, servletResponse);
        }
    }
}

