/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.server.service.httpurlconnection;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.talend.sdk.component.server.service.httpurlconnection.NetAuthenticatorController;

@ApplicationScoped
public class NetAuthenticatorWorkaround {
    @Inject
    private NetAuthenticatorController controller;
    private volatile Authenticator original;

    @PostConstruct
    private void init() {
        this.original = this.getAuthenticator();
        Authenticator.setDefault(new ApplicationAuthenticator(this.original, this.controller));
    }

    public void lazyInit() {
    }

    @PreDestroy
    private void destroy() {
        Authenticator.setDefault(this.original);
    }

    private Authenticator getAuthenticator() {
        return Stream.of(Authenticator.class.getDeclaredFields()).filter(f -> Modifier.isStatic(f.getModifiers()) && Modifier.isPrivate(f.getModifiers()) && f.getType() == Authenticator.class).findFirst().map(f -> {
            if (!f.isAccessible()) {
                f.setAccessible(true);
            }
            try {
                return (Authenticator)Authenticator.class.cast(f.get(null));
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException(e);
            }
        }).orElse(null);
    }

    private static class ApplicationAuthenticator
    extends Authenticator {
        private final Authenticator delegate;
        private final NetAuthenticatorController controller;
        private final Method getRequestorType;
        private final Method getPasswordAuthentication = this.findMethod("getPasswordAuthentication");
        private final Method getRequestingURL = this.findMethod("getRequestingURL");

        private ApplicationAuthenticator(Authenticator original, NetAuthenticatorController controller) {
            this.getRequestorType = this.findMethod("getRequestorType");
            this.delegate = original;
            this.controller = controller;
        }

        private Method findMethod(String name) {
            Method declaredMethod;
            try {
                declaredMethod = Authenticator.class.getDeclaredMethod(name, new Class[0]);
            }
            catch (NoSuchMethodException e) {
                throw new IllegalStateException(e);
            }
            if (!declaredMethod.isAccessible()) {
                declaredMethod.setAccessible(true);
            }
            return declaredMethod;
        }

        private boolean shouldSkip() {
            return this.delegate == null || this.controller.isSkipped();
        }

        @Override
        public PasswordAuthentication getPasswordAuthentication() {
            try {
                return this.shouldSkip() ? null : (PasswordAuthentication)PasswordAuthentication.class.cast(this.getPasswordAuthentication.invoke((Object)this.delegate, new Object[0]));
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException(e);
            }
            catch (InvocationTargetException e) {
                throw new IllegalStateException(e.getTargetException());
            }
        }

        @Override
        public URL getRequestingURL() {
            try {
                return this.shouldSkip() ? null : (URL)URL.class.cast(this.getRequestingURL.invoke((Object)this.delegate, new Object[0]));
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException(e);
            }
            catch (InvocationTargetException e) {
                throw new IllegalStateException(e.getTargetException());
            }
        }

        @Override
        public Authenticator.RequestorType getRequestorType() {
            try {
                return this.shouldSkip() ? null : (Authenticator.RequestorType)((Object)Authenticator.RequestorType.class.cast(this.getRequestorType.invoke((Object)this.delegate, new Object[0])));
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException(e);
            }
            catch (InvocationTargetException e) {
                throw new IllegalStateException(e.getTargetException());
            }
        }
    }
}

