/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.server.dao;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import javax.enterprise.context.ApplicationScoped;
import org.talend.sdk.component.runtime.manager.ServiceMeta;

@ApplicationScoped
public class ComponentActionDao {
    private Map<ActionKey, ServiceMeta.ActionMeta> data = new ConcurrentHashMap<ActionKey, ServiceMeta.ActionMeta>();

    public ActionKey createOrUpdate(ServiceMeta.ActionMeta meta) {
        ActionKey key = new ActionKey(meta.getFamily(), meta.getType(), meta.getAction());
        this.data.put(key, meta);
        return key;
    }

    public ServiceMeta.ActionMeta findBy(String component, String type, String action) {
        return this.data.get(new ActionKey(component, type, action));
    }

    public void removeById(ActionKey key) {
        this.data.remove(key);
    }

    public static class ActionKey {
        private final String component;
        private final String type;
        private final String name;
        private final int hash;

        private ActionKey(String component, String type, String name) {
            this.component = component;
            this.name = name;
            this.type = type;
            this.hash = Objects.hash(component, type, name);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ActionKey other = (ActionKey)ActionKey.class.cast(o);
            return Objects.equals(this.component, other.component) && Objects.equals(this.type, other.type) && Objects.equals(this.name, other.name);
        }

        public int hashCode() {
            return this.hash;
        }
    }
}

