/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.server.front.security;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.talend.sdk.component.runtime.manager.ParameterMeta;
import org.talend.sdk.components.vault.client.VaultClient;

@Dependent
public class SecurityUtils {
    public static final String CREDENTIAL = "tcomp::ui::credential";
    @Inject
    private VaultClient vault;

    public Map<String, String> decrypt(Collection<ParameterMeta> spec, Map<String, String> config, String tenant) {
        if (!this.hasCipheredKeys(config)) {
            return config;
        }
        List toDecipher = spec.stream().flatMap(s -> this.flatten((ParameterMeta)s).filter(p -> Boolean.parseBoolean(p.getMetadata().getOrDefault(CREDENTIAL, "false")))).map(m -> m.getPath()).collect(Collectors.toList());
        return Stream.concat(this.vault.decrypt(config.entrySet().stream().filter(e -> toDecipher.contains(e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)), tenant).entrySet().stream(), config.entrySet().stream().filter(e -> !toDecipher.contains(e.getKey()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public boolean hasCipheredKeys(Map<String, String> configuration) {
        return configuration.values().stream().anyMatch(v -> v.startsWith("vault:"));
    }

    public List<String> findCipheredKeys(ParameterMeta meta, Map<String, String> original) {
        return this.flatten(meta).filter(p -> Boolean.parseBoolean(p.getMetadata().getOrDefault(CREDENTIAL, "false"))).map(m -> m.getPath()).collect(Collectors.toList());
    }

    private Stream<ParameterMeta> flatten(ParameterMeta meta) {
        if (meta.getNestedParameters() == null || meta.getNestedParameters().isEmpty()) {
            return Stream.of(meta);
        }
        return Stream.concat(meta.getNestedParameters().stream().flatMap(this::flatten), Stream.of(meta));
    }
}

