/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.server.mdc;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.enterprise.inject.Vetoed;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.logging.log4j.ThreadContext;

@Vetoed
public class MdcRequestBinder
implements Filter {
    private String hostname;

    public void init(FilterConfig filterConfig) {
        try {
            this.hostname = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            this.hostname = Optional.ofNullable(System.getenv("HOST")).orElse("unknown");
        }
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (HttpServletRequest.class.isInstance(request)) {
            ThreadContext.putAll(this.createContext((HttpServletRequest)HttpServletRequest.class.cast(request)));
        }
        chain.doFilter(request, response);
    }

    private Map<String, String> createContext(HttpServletRequest req) {
        HashMap<String, String> map = new HashMap<String, String>();
        Optional.ofNullable(req.getHeader("X-B3-TraceId")).ifPresent(v -> map.put("spanId", (String)v));
        Optional.ofNullable(req.getHeader("X-B3-SpanId")).ifPresent(v -> map.put("traceId", (String)v));
        map.put("hostname", this.hostname);
        return map;
    }
}

