/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.server.lang;

import java.util.ArrayList;
import java.util.Collection;
import java.util.NoSuchElementException;

public class StringPropertiesTokenizer {
    private String input;
    private char[] delim;
    private int pos = 0;
    private char lastDelimiter = '\u0000';
    private boolean isDelimiter = false;

    public StringPropertiesTokenizer(String str) {
        this.input = str;
        this.delim = ", \t\r\n\f".toCharArray();
    }

    public Collection<String> tokens() {
        ArrayList<String> out = new ArrayList<String>();
        while (this.hasMoreTokens()) {
            out.add(this.nextToken());
        }
        return out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasMoreTokens() {
        int oldpos = this.pos;
        char olddelim = this.lastDelimiter;
        try {
            this.nextToken();
            boolean bl = true;
            return bl;
        }
        catch (NoSuchElementException nsee) {
            boolean bl = false;
            return bl;
        }
        finally {
            this.pos = oldpos;
            this.lastDelimiter = olddelim;
        }
    }

    private String nextToken() {
        if (this.pos >= this.input.length()) {
            throw new NoSuchElementException();
        }
        StringBuilder sb = new StringBuilder();
        char prevch = '\u0000';
        while (this.pos < this.input.length()) {
            char ch;
            this.lastDelimiter = ch = this.input.charAt(this.pos);
            if (this.isDelimiter(ch, prevch)) break;
            if (this.isDelimiter(ch, '\u0000') && prevch == '\\') {
                sb.setLength(sb.length() - 1);
            }
            sb.append(ch);
            prevch = ch;
            ++this.pos;
        }
        this.isDelimiter = false;
        if (sb.length() == 0) {
            ++this.pos;
            return this.nextToken();
        }
        return sb.toString();
    }

    public String nextToken(String delim) {
        this.delim = delim.toCharArray();
        return this.nextToken();
    }

    public boolean isDelimiter() {
        return this.isDelimiter;
    }

    private boolean isDelimiter(char ch, char prevch) {
        for (char currentChar : this.delim) {
            if (ch != currentChar || prevch == '\\') continue;
            return true;
        }
        return false;
    }
}

