/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.server.tomcat;

import java.util.stream.Stream;
import org.apache.catalina.Server;
import org.apache.catalina.Service;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.startup.Tomcat;
import org.apache.catalina.valves.ErrorReportValve;
import org.apache.meecrowave.Meecrowave;

public class TomcatSetup
implements Meecrowave.InstanceCustomizer {
    public void accept(Tomcat tomcat) {
        Server server = tomcat.getServer();
        server.addLifecycleListener(event -> {
            if (Server.class.isInstance(event.getData()) && "after_destroy".equals(event.getType()) && Boolean.getBoolean("talend.component.exit-on-destroy")) {
                System.exit(0);
            }
        });
        boolean dev = Boolean.getBoolean("talend.component.server.tomcat.valve.error.debug");
        if (!dev) {
            Stream.of(server.findServices()).map(Service::getContainer).flatMap(e -> Stream.of(e.findChildren())).filter(StandardHost.class::isInstance).map(StandardHost.class::cast).forEach(host -> host.addLifecycleListener(event -> {
                if (event.getType().equals("before_start")) {
                    ((StandardHost)StandardHost.class.cast(host)).setErrorReportValveClass(MinimalErrorReportValve.class.getName());
                }
            }));
        }
    }

    public static class MinimalErrorReportValve
    extends ErrorReportValve {
        public MinimalErrorReportValve() {
            this.setShowReport(false);
            this.setShowServerInfo(false);
        }
    }
}

