/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.server.configuration;

import java.io.File;
import java.util.Map;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.meecrowave.Meecrowave;
import org.apache.meecrowave.configuration.Configuration;

public class PropertiesSetup
implements Meecrowave.ConfigurationCustomizer {
    public void accept(Configuration configuration) {
        String port;
        this.checkOrSetProperty("jdk.serialFilter", System.getenv("TALEND_JDK_SERIAL_FILTER"));
        this.checkOrSetProperty("java.io.tmpdir", System.getenv("JAVA_IO_TMPDIR"));
        this.checkOrSetProperty("java.security.egd", "file:/dev/./urandom");
        this.checkOrSetProperty("java.util.logging.manager", "org.apache.logging.log4j.jul.LogManager");
        this.checkOrSetProperty("log4j.configurationFile", System.getenv("LOG4J_CONFIGURATIONFILE"));
        this.checkOrSetProperty("http", System.getenv("BOUND_PORT"));
        this.checkOrSetProperty("meecrowave-properties", System.getenv("MEECROWAVE-PROPERTIES"));
        this.checkOrSetProperty("meecrowave.home", System.getenv("MEECROWAVE_HOME"));
        this.checkOrSetProperty("meecrowave.base", System.getenv("MEECROWAVE_BASE"));
        this.checkOrSetProperty("geronimo.metrics.sigar.refreshInterval", "0");
        this.checkOrSetProperty("talend.component.exit-on-destroy", "true");
        this.checkOrSetProperty("talend.component.manager.services.cache.eviction.defaultEvictionTimeout", "30000");
        this.checkOrSetProperty("talend.component.manager.services.cache.eviction.defaultMaxSize", "5000");
        this.checkOrSetProperty("talend.component.manager.services.cache.eviction.maxDeletionPerEvictionRun", "-1");
        System.setProperty("geronimo.opentracing.client.filter.request.skip", "true");
        System.setProperty("geronimo.opentracing.filter.skippedTracing.urls", ".*/login$,.*/decrypt/.*");
        System.setProperty("geronimo.opentracing.filter.skippedTracing.matcherType", "regex");
        String string = port = System.getProperty("http") != null ? System.getProperty("http") : System.getenv("TALEND_COMPONENT_SERVER_PORT");
        if (port != null) {
            System.setProperty("http", port);
            configuration.setHttpPort(Integer.parseInt(port));
        }
        String log4jLayout = System.getenv("LOGGING_LAYOUT");
        String appHome = System.getenv("TALEND_APP_HOME");
        if (log4jLayout != null && appHome != null) {
            String initialConfig = System.getProperty("log4j.configurationFile", "default.properties");
            String newConfig = String.format("%s/conf/log4j2-component-server-%s.xml", appHome, log4jLayout);
            if (!newConfig.equals(initialConfig)) {
                System.setProperty("log4j.configurationFile", newConfig);
                LoggerContext ctx = (LoggerContext)LogManager.getContext((boolean)false);
                ctx.setConfigLocation(new File(newConfig).toURI());
                ctx.reconfigure();
                ctx.updateLoggers();
            }
        }
        configuration.loadFromProperties(System.getProperties());
        if (configuration.getProperties() == null) {
            configuration.setProperties(new Properties());
        }
        configuration.getProperties().putAll((Map<?, ?>)System.getProperties());
        configuration.getProperties().stringPropertyNames().stream().filter(k -> System.getProperty(k) == null).forEach(k -> System.setProperty(k, configuration.getProperties().getProperty((String)k)));
    }

    private void checkOrSetProperty(String key, String defaultValue) {
        if (System.getProperty(key) == null && defaultValue != null) {
            System.setProperty(key, defaultValue);
        }
    }
}

