/*
 * Decompiled with CFR 0.152.
 */
package org.apache.meecrowave.tomcat;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.servlet.ServletContext;
import org.apache.tomcat.Jar;
import org.apache.tomcat.JarScanFilter;
import org.apache.tomcat.JarScanType;
import org.apache.tomcat.JarScanner;
import org.apache.tomcat.JarScannerCallback;
import org.apache.tomcat.util.scan.JarFactory;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.corespi.scanner.xbean.CdiArchive;
import org.apache.webbeans.corespi.scanner.xbean.OwbAnnotationFinder;
import org.apache.webbeans.spi.ScannerService;
import org.apache.webbeans.web.scanner.WebScannerService;
import org.apache.xbean.finder.util.Files;

public class OWBJarScanner
implements JarScanner {
    private JarScanFilter filter;

    public void scan(JarScanType jarScanType, ServletContext servletContext, JarScannerCallback callback) {
        switch (jarScanType) {
            case PLUGGABILITY: {
                WebBeansContext owb = WebBeansContext.getInstance();
                ScannerService scannerService = owb.getScannerService();
                if (!WebScannerService.class.isInstance(scannerService)) {
                    return;
                }
                OwbAnnotationFinder finder = ((WebScannerService)WebScannerService.class.cast(scannerService)).getFinder();
                if (finder == null) {
                    return;
                }
                ((CdiArchive)CdiArchive.class.cast(finder.getArchive())).classesByUrl().keySet().stream().filter(u -> !"jar:file://!/".equals(u)).forEach(u -> {
                    block19: {
                        try {
                            URL url = new URL((String)u);
                            File asFile = Files.toFile((URL)url);
                            if (!asFile.exists()) {
                                return;
                            }
                            if (this.filter != null && !this.filter.check(jarScanType, asFile.getName())) {
                                return;
                            }
                            if (asFile.getName().endsWith(".jar")) {
                                try (Jar jar = JarFactory.newInstance((URL)asFile.toURI().toURL());){
                                    callback.scan(jar, u, true);
                                    break block19;
                                }
                            }
                            if (asFile.isDirectory()) {
                                callback.scan(asFile, asFile.getAbsolutePath(), true);
                            }
                        }
                        catch (MalformedURLException url) {
                        }
                        catch (IOException ioe) {
                            throw new IllegalArgumentException(ioe);
                        }
                    }
                });
                return;
            }
        }
    }

    public JarScanFilter getJarScanFilter() {
        return this.filter;
    }

    public void setJarScanFilter(JarScanFilter jarScanFilter) {
        this.filter = jarScanFilter;
    }
}

