/*
 * Decompiled with CFR 0.152.
 */
package org.apache.meecrowave.tomcat;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.annotation.HandlesTypes;
import javax.servlet.annotation.WebFilter;
import javax.servlet.annotation.WebListener;
import javax.servlet.annotation.WebServlet;
import org.apache.catalina.Context;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.startup.ContextConfig;
import org.apache.catalina.startup.WebappServiceLoader;
import org.apache.meecrowave.Meecrowave;
import org.apache.meecrowave.configuration.Configuration;
import org.apache.meecrowave.logging.tomcat.LogFacade;
import org.apache.meecrowave.openwebbeans.OWBTomcatWebScannerService;
import org.apache.meecrowave.watching.ReloadOnChangeController;
import org.apache.tomcat.JarScanner;
import org.apache.tomcat.util.bcel.classfile.ClassParser;
import org.apache.tomcat.util.descriptor.web.WebXml;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.corespi.scanner.xbean.CdiArchive;
import org.apache.webbeans.corespi.scanner.xbean.OwbAnnotationFinder;
import org.apache.webbeans.spi.ScannerService;

public class MeecrowaveContextConfig
extends ContextConfig {
    private final Configuration configuration;
    private final Map<String, Collection<Class<?>>> webClasses = new HashMap();
    private final boolean fixDocBase;
    private final ServletContainerInitializer intializer;
    private final Consumer<Context> redeployCallback;
    private OwbAnnotationFinder finder;
    private ReloadOnChangeController watcher;

    public MeecrowaveContextConfig(Configuration configuration, boolean fixDocBase, ServletContainerInitializer intializer, Consumer<Context> redeployCallback) {
        this.configuration = configuration;
        this.fixDocBase = fixDocBase;
        this.intializer = intializer;
        this.redeployCallback = redeployCallback;
    }

    protected void fixDocBase() throws IOException {
        if (!this.fixDocBase) {
            return;
        }
        super.fixDocBase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void webConfig() {
        if (this.context.getServletContext().getAttribute("meecrowave.configuration") == null) {
            this.context.getServletContext().setAttribute("meecrowave.configuration", (Object)(Meecrowave.Builder.class.isInstance(this.configuration) ? this.configuration : new Meecrowave.Builder(this.configuration)));
            this.context.addServletContainerInitializer(this.intializer, Collections.emptySet());
        }
        if (!this.configuration.isTomcatScanning()) {
            super.webConfig();
            return;
        }
        ClassLoader loader = this.context.getLoader().getClassLoader();
        Thread thread = Thread.currentThread();
        ClassLoader old = thread.getContextClassLoader();
        thread.setContextClassLoader(loader);
        try {
            ScannerService service = WebBeansContext.getInstance().getScannerService();
            if (OWBTomcatWebScannerService.class.isInstance(service)) {
                OWBTomcatWebScannerService scannerService = (OWBTomcatWebScannerService)((Object)OWBTomcatWebScannerService.class.cast(service));
                scannerService.setFilter(Optional.ofNullable(this.context.getJarScanner()).map(JarScanner::getJarScanFilter).orElse(null), this.context.getServletContext());
                scannerService.setDocBase(this.context.getDocBase());
                scannerService.setShared(this.configuration.getSharedLibraries());
                if (this.configuration.getWatcherBouncing() > 0) {
                    this.watcher = new ReloadOnChangeController(this.context, this.configuration.getWatcherBouncing(), this.redeployCallback);
                    scannerService.setFileVisitor(f -> this.watcher.register((File)f));
                }
                scannerService.scan();
                this.finder = scannerService.getFinder();
                this.finder.link();
                CdiArchive archive = (CdiArchive)CdiArchive.class.cast(this.finder.getArchive());
                Stream.of(WebServlet.class, WebFilter.class, WebListener.class).forEach(marker -> this.finder.findAnnotatedClasses(marker).stream().filter(c -> !Modifier.isAbstract(c.getModifiers()) && Modifier.isPublic(c.getModifiers())).forEach(webComponent -> this.webClasses.computeIfAbsent((String)archive.classesByUrl().entrySet().stream().filter(e -> ((CdiArchive.FoundClasses)e.getValue()).getClassNames().contains(webComponent.getName())).findFirst().get().getKey(), (Function<String, Collection<Class<?>>>)((Function<String, Collection>)k -> new HashSet())).add(webComponent)));
            }
            super.webConfig();
        }
        finally {
            thread.setContextClassLoader(old);
            this.webClasses.clear();
            this.finder = null;
        }
    }

    protected void processClasses(WebXml webXml, Set<WebXml> orderedFragments) {
        ClassLoader loader = this.context.getLoader().getClassLoader();
        orderedFragments.forEach(fragment -> {
            WebXml annotations = new WebXml();
            annotations.setDistributable(true);
            URL url = fragment.getURL();
            String urlString = url.toExternalForm();
            Collection<Class<?>> classes = this.webClasses.get(urlString);
            if (classes == null) {
                if (!urlString.startsWith("file:") || !urlString.endsWith("jar")) {
                    return;
                }
                urlString = "jar:" + urlString + "!/";
                classes = this.webClasses.get(urlString);
                if (classes == null) {
                    return;
                }
            }
            classes.forEach(clazz -> {
                try (InputStream stream = loader.getResourceAsStream(clazz.getName().replace('.', '/') + ".class");){
                    this.processClass(annotations, new ClassParser(stream).parse());
                }
                catch (IOException e) {
                    new LogFacade(MeecrowaveContextConfig.class.getName()).error("Can't parse " + clazz);
                }
            });
            fragment.merge(Collections.singleton(annotations));
        });
    }

    public void lifecycleEvent(LifecycleEvent event) {
        super.lifecycleEvent(event);
        if (this.watcher != null && this.watcher.shouldRun() && Context.class.cast(event.getLifecycle()) == this.context) {
            if ("after_start".equals(event.getType())) {
                this.watcher.start();
            } else if ("before_stop".equals(event.getType())) {
                this.watcher.close();
            }
        }
    }

    protected void processServletContainerInitializers() {
        if (!this.configuration.isTomcatScanning()) {
            return;
        }
        try {
            new WebappServiceLoader(this.context).load(ServletContainerInitializer.class).forEach(sci -> {
                HandlesTypes ht;
                HashSet classes = new HashSet();
                this.initializerClassMap.put(sci, classes);
                try {
                    ht = sci.getClass().getAnnotation(HandlesTypes.class);
                }
                catch (Exception | NoClassDefFoundError e) {
                    return;
                }
                if (ht == null) {
                    return;
                }
                Stream.of(ht.value()).forEach(t -> {
                    if (t.isAnnotation()) {
                        Class annotation = (Class)Class.class.cast(t);
                        classes.addAll(this.finder.findAnnotatedClasses(annotation));
                    } else if (t.isInterface()) {
                        classes.addAll(this.finder.findImplementations(t));
                    } else {
                        classes.addAll(this.finder.findSubclasses(t));
                    }
                });
            });
        }
        catch (IOException e) {
            this.ok = false;
        }
    }
}

