/*
 * Decompiled with CFR 0.152.
 */
package org.apache.meecrowave;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.lang.annotation.Annotation;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.ServerSocket;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.TreeMap;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.CDI;
import javax.enterprise.inject.spi.InjectionTarget;
import javax.servlet.ServletContainerInitializer;
import javax.servlet.SessionCookieConfig;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Host;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.LifecycleState;
import org.apache.catalina.Loader;
import org.apache.catalina.Manager;
import org.apache.catalina.Pipeline;
import org.apache.catalina.Realm;
import org.apache.catalina.Server;
import org.apache.catalina.SessionIdGenerator;
import org.apache.catalina.Valve;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.core.StandardHost;
import org.apache.catalina.session.StandardManager;
import org.apache.catalina.startup.Catalina;
import org.apache.catalina.startup.Tomcat;
import org.apache.catalina.util.StandardSessionIdGenerator;
import org.apache.coyote.UpgradeProtocol;
import org.apache.coyote.http2.Http2Protocol;
import org.apache.meecrowave.api.StartListening;
import org.apache.meecrowave.api.StopListening;
import org.apache.meecrowave.configuration.Configuration;
import org.apache.meecrowave.cxf.ConfigurableBus;
import org.apache.meecrowave.cxf.CxfCdiAutoSetup;
import org.apache.meecrowave.cxf.Cxfs;
import org.apache.meecrowave.io.IO;
import org.apache.meecrowave.lang.Substitutor;
import org.apache.meecrowave.logging.jul.Log4j2Logger;
import org.apache.meecrowave.logging.log4j2.Log4j2Shutdown;
import org.apache.meecrowave.logging.log4j2.Log4j2s;
import org.apache.meecrowave.logging.openwebbeans.Log4j2LoggerFactory;
import org.apache.meecrowave.logging.tomcat.Log4j2Log;
import org.apache.meecrowave.logging.tomcat.LogFacade;
import org.apache.meecrowave.openwebbeans.OWBAutoSetup;
import org.apache.meecrowave.service.Priotities;
import org.apache.meecrowave.service.ValueTransformer;
import org.apache.meecrowave.tomcat.CDIInstanceManager;
import org.apache.meecrowave.tomcat.LoggingAccessLogPattern;
import org.apache.meecrowave.tomcat.MeecrowaveContextConfig;
import org.apache.meecrowave.tomcat.OWBJarScanner;
import org.apache.meecrowave.tomcat.ProvidedLoader;
import org.apache.meecrowave.tomcat.TomcatAutoInitializer;
import org.apache.tomcat.InstanceManager;
import org.apache.tomcat.JarScanFilter;
import org.apache.tomcat.JarScanner;
import org.apache.tomcat.util.descriptor.web.LoginConfig;
import org.apache.tomcat.util.descriptor.web.SecurityCollection;
import org.apache.tomcat.util.descriptor.web.SecurityConstraint;
import org.apache.tomcat.util.modeler.Registry;
import org.apache.tomcat.util.net.SSLHostConfig;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.xbean.finder.ResourceFinder;
import org.apache.xbean.recipe.ObjectRecipe;
import org.apache.xbean.recipe.Option;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class Meecrowave
implements AutoCloseable {
    private final Configuration configuration;
    protected ConfigurableBus clientBus;
    protected File base;
    protected final File ownedTempDir;
    protected File workDir;
    protected InternalTomcat tomcat;
    protected volatile Thread hook;
    private final Map<String, Runnable> contexts = new HashMap<String, Runnable>();
    private Runnable postTask;
    private boolean clearCatalinaSystemProperties;
    private boolean deleteBase;

    public Meecrowave() {
        this(new Builder());
    }

    public Meecrowave(Configuration configuration) {
        this.configuration = configuration;
        this.ownedTempDir = new File(this.configuration.getTempDir(), "meecrowave_" + System.nanoTime());
    }

    public Builder getConfiguration() {
        return Builder.class.isInstance(this.configuration) ? (Builder)Builder.class.cast(this.configuration) : new Builder(this.configuration);
    }

    public File getBase() {
        return this.base;
    }

    public Tomcat getTomcat() {
        return this.tomcat;
    }

    public boolean isServing() {
        return this.tomcat != null && this.tomcat.getHost().getState() == LifecycleState.STARTED;
    }

    public void undeploy(String root) {
        Optional.ofNullable(this.contexts.remove(root)).ifPresent(Runnable::run);
    }

    public Meecrowave deployClasspath(DeploymentMeta meta) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        ClassLoader parentLoader = this.tomcat.getServer().getParentClassLoader();
        if (parentLoader.getParent() == classLoader) {
            classLoader = parentLoader;
        }
        ProvidedLoader loader = new ProvidedLoader(classLoader, this.configuration.isTomcatWrapLoader());
        Consumer<Context> builtInCustomizer = c -> c.setLoader((Loader)loader);
        return this.deployWebapp(new DeploymentMeta(meta.context, meta.docBase, Optional.ofNullable(meta.consumer).map(c -> ctx -> {
            builtInCustomizer.accept((Context)ctx);
            c.accept(ctx);
        }).orElse(builtInCustomizer), meta.redeployCallback));
    }

    public Meecrowave deployClasspath() {
        return this.deployClasspath("");
    }

    public Meecrowave bake(Consumer<Context> customizer) {
        this.start();
        return this.deployClasspath(new DeploymentMeta("", null, customizer, null));
    }

    public Meecrowave deployClasspath(String context) {
        return this.deployClasspath(new DeploymentMeta(context, null, null, null));
    }

    public Meecrowave deployWebapp(File warOrDir) {
        return this.deployWebapp("", warOrDir);
    }

    public Meecrowave deployWebapp(String context, File warOrDir) {
        return this.deployWebapp(new DeploymentMeta(context, warOrDir, null, null));
    }

    public Meecrowave deployWebapp(DeploymentMeta meta) {
        if (this.contexts.containsKey(meta.context)) {
            throw new IllegalArgumentException("Already deployed: '" + meta.context + "'");
        }
        String base = this.tomcat.getService().findConnectors().length > 0 ? this.configuration.getActiveProtocol() + "://" + this.tomcat.getHost().getName() + ':' + this.configuration.getActivePort() : "";
        new LogFacade(Meecrowave.class.getName()).info("--------------- " + base + meta.context);
        OWBJarScanner scanner = new OWBJarScanner();
        StandardContext ctx = new StandardContext(){

            public void setApplicationEventListeners(Object[] listeners) {
                if (listeners == null) {
                    super.setApplicationEventListeners(null);
                    return;
                }
                for (int i = 1; i < listeners.length; ++i) {
                    if (!OWBAutoSetup.EagerBootListener.class.isInstance(listeners[i])) continue;
                    Object first = listeners[0];
                    listeners[0] = listeners[i];
                    listeners[i] = first;
                    break;
                }
                super.setApplicationEventListeners(listeners);
            }
        };
        ctx.setPath(meta.context);
        ctx.setName(meta.context);
        ctx.setJarScanner((JarScanner)scanner);
        ctx.setInstanceManager((InstanceManager)new CDIInstanceManager());
        Optional.ofNullable(meta.docBase).ifPresent(d -> {
            try {
                ctx.setDocBase(meta.docBase.getCanonicalPath());
            }
            catch (IOException e) {
                ctx.setDocBase(meta.docBase.getAbsolutePath());
            }
        });
        Optional.ofNullable(this.configuration.getTomcatFilter()).ifPresent(filter -> {
            try {
                scanner.setJarScanFilter((JarScanFilter)JarScanFilter.class.cast(Thread.currentThread().getContextClassLoader().loadClass((String)filter).newInstance()));
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                throw new IllegalArgumentException(e);
            }
        });
        AtomicReference releaseSCI = new AtomicReference();
        ServletContainerInitializer meecrowaveInitializer = (c, ctx1) -> {
            ctx1.setAttribute("meecrowave.configuration", (Object)this.getConfiguration());
            ctx1.setAttribute("meecrowave.instance", (Object)this);
            new OWBAutoSetup().onStartup(c, ctx1);
            if (Cxfs.IS_PRESENT) {
                new CxfCdiAutoSetup().onStartup(c, ctx1);
            }
            new TomcatAutoInitializer().onStartup(c, ctx1);
            if (this.configuration.isInjectServletContainerInitializer()) {
                List cc;
                Field f;
                try {
                    f = StandardContext.class.getDeclaredField("initializers");
                    if (!f.isAccessible()) {
                        f.setAccessible(true);
                    }
                }
                catch (Exception e) {
                    throw new IllegalStateException("Bad tomcat version", e);
                }
                try {
                    cc = ((Map)f.get(ctx)).keySet().stream().filter(i -> !i.getClass().getName().startsWith(Meecrowave.class.getName())).map(i -> {
                        try {
                            return this.inject(i);
                        }
                        catch (IllegalArgumentException iae) {
                            return null;
                        }
                    }).filter(Objects::nonNull).collect(Collectors.toList());
                }
                catch (IllegalAccessException e) {
                    throw new IllegalStateException("Can't read initializers", e);
                }
                releaseSCI.set(() -> cc.forEach(closeable -> {
                    try {
                        closeable.close();
                    }
                    catch (Exception e) {
                        throw new IllegalStateException(e);
                    }
                }));
            }
        };
        ctx.addLifecycleListener((LifecycleListener)new MeecrowaveContextConfig(this.configuration, meta.docBase != null, meecrowaveInitializer, meta.redeployCallback));
        ctx.addLifecycleListener(event -> {
            switch (event.getType()) {
                case "before_start": {
                    if (this.configuration.getWebSessionCookieConfig() == null) break;
                    Properties p = new Properties();
                    try {
                        p.load(new StringReader(this.configuration.getWebSessionCookieConfig()));
                    }
                    catch (IOException e) {
                        throw new IllegalArgumentException(e);
                    }
                    if (p.containsKey("domain")) {
                        ctx.setSessionCookieDomain(p.getProperty("domain"));
                    }
                    if (p.containsKey("path")) {
                        ctx.setSessionCookiePath(p.getProperty("path"));
                    }
                    if (p.containsKey("name")) {
                        ctx.setSessionCookieName(p.getProperty("name"));
                    }
                    if (p.containsKey("use-trailing-slash")) {
                        ctx.setSessionCookiePathUsesTrailingSlash(Boolean.parseBoolean(p.getProperty("use-trailing-slash")));
                    }
                    if (p.containsKey("http-only")) {
                        ctx.setUseHttpOnly(Boolean.parseBoolean(p.getProperty("http-only")));
                    }
                    if (!p.containsKey("secured")) break;
                    SessionCookieConfig sessionCookieConfig = ctx.getServletContext().getSessionCookieConfig();
                    sessionCookieConfig.setSecure(Boolean.parseBoolean(p.getProperty("secured")));
                    break;
                }
                case "after_start": {
                    ctx.getResources().setCachingAllowed(this.configuration.isWebResourceCached());
                    break;
                }
                case "before_init": {
                    if (this.configuration.getLoginConfig() != null) {
                        ctx.setLoginConfig(this.configuration.getLoginConfig().build());
                    }
                    for (SecurityConstaintBuilder sc : this.configuration.getSecurityConstraints()) {
                        ctx.addConstraint(sc.build());
                    }
                    if (this.configuration.getWebXml() == null) break;
                    ctx.getServletContext().setAttribute("org.apache.catalina.deploy.alt_dd", (Object)this.configuration.getWebXml());
                    break;
                }
            }
        });
        ctx.addLifecycleListener((LifecycleListener)new Tomcat.FixContextListener());
        ctx.addServletContainerInitializer(meecrowaveInitializer, Collections.emptySet());
        if (this.configuration.isUseTomcatDefaults()) {
            ctx.setSessionTimeout(this.configuration.getWebSessionTimeout() != null ? this.configuration.getWebSessionTimeout() : 30);
            ctx.addWelcomeFile("index.html");
            ctx.addWelcomeFile("index.htm");
            Tomcat.addDefaultMimeTypeMappings((Context)ctx);
        } else if (this.configuration.getWebSessionTimeout() != null) {
            ctx.setSessionTimeout(this.configuration.getWebSessionTimeout().intValue());
        }
        Optional.ofNullable(meta.consumer).ifPresent(c -> c.accept(ctx));
        if (this.configuration.isQuickSession() && ctx.getManager() == null) {
            StandardManager manager = new StandardManager();
            manager.setSessionIdGenerator((SessionIdGenerator)new StandardSessionIdGenerator(){

                protected void getRandomBytes(byte[] bytes) {
                    ThreadLocalRandom.current().nextBytes(bytes);
                }

                public String toString() {
                    return "MeecrowaveSessionIdGenerator@" + System.identityHashCode((Object)this);
                }
            });
            ctx.setManager((Manager)manager);
        }
        if (this.configuration.isAntiResourceLocking() && StandardContext.class.isInstance(ctx)) {
            ((StandardContext)StandardContext.class.cast(ctx)).setAntiResourceLocking(true);
        }
        this.configuration.getInitializers().forEach(i -> ctx.addServletContainerInitializer(i, Collections.emptySet()));
        this.configuration.getGlobalContextConfigurers().forEach(it -> it.accept(ctx));
        Host host = this.tomcat.getHost();
        host.addChild((Container)ctx);
        ClassLoader classLoader = ctx.getLoader().getClassLoader();
        if (host.getState().isAvailable()) {
            this.fire(new StartListening(this.findFirstConnector(), host, (Context)ctx), classLoader);
        }
        this.contexts.put(meta.context, () -> {
            if (host.getState().isAvailable()) {
                this.fire(new StopListening(this.findFirstConnector(), host, (Context)ctx), classLoader);
            }
            Optional.ofNullable(releaseSCI.get()).ifPresent(Runnable::run);
            this.tomcat.getHost().removeChild((Container)ctx);
        });
        return this;
    }

    public Meecrowave bake() {
        return this.bake("");
    }

    public Meecrowave bake(String ctx) {
        this.start();
        return this.deployClasspath(ctx);
    }

    public Meecrowave start() {
        boolean initialized;
        File tempDir;
        HashMap<String, String> systemPropsToRestore = new HashMap<String, String>();
        if (this.configuration.getMeecrowaveProperties() != null && !"meecrowave.properties".equals(this.configuration.getMeecrowaveProperties())) {
            this.configuration.loadFrom(this.configuration.getMeecrowaveProperties());
        }
        if (this.configuration.isUseLog4j2JulLogManager() && Log4j2s.IS_PRESENT) {
            System.setProperty("java.util.logging.manager", "org.apache.logging.log4j.jul.LogManager");
        }
        if (this.configuration.isLoggingGlobalSetup() && Log4j2s.IS_PRESENT) {
            this.setSystemProperty(systemPropsToRestore, "log4j.shutdownHookEnabled", "false");
            this.setSystemProperty(systemPropsToRestore, "openwebbeans.logging.factory", Log4j2LoggerFactory.class.getName());
            this.setSystemProperty(systemPropsToRestore, "org.apache.cxf.Logger", Log4j2Logger.class.getName());
            this.setSystemProperty(systemPropsToRestore, "org.apache.tomcat.Logger", Log4j2Log.class.getName());
            this.postTask = () -> {
                if (Log4j2s.IS_PRESENT) {
                    new Log4j2Shutdown().shutdown();
                }
                systemPropsToRestore.forEach((key, value) -> {
                    if (value == null) {
                        System.clearProperty(key);
                    } else {
                        System.setProperty(key, value);
                    }
                });
            };
        }
        this.setupJmx(this.configuration.isTomcatNoJmx());
        this.clearCatalinaSystemProperties = System.getProperty("catalina.base") == null && System.getProperty("catalina.home") == null;
        this.tomcat = new InternalTomcat();
        this.base = new File(this.newBaseDir());
        if (this.configuration.getTempDir() == null || this.configuration.getTempDir().length() == 0) {
            tempDir = this.createDirectory(this.base, "temp");
        } else {
            tempDir = new File(this.configuration.getTempDir());
            if (!tempDir.exists()) {
                tempDir.mkdirs();
            }
        }
        try {
            this.workDir = this.createDirectory(this.base, "work");
        }
        catch (IllegalStateException ise) {
            this.workDir = this.createDirectory(tempDir, "work");
        }
        this.synchronize(new File(this.base, "conf"), this.configuration.getConf());
        Properties props = this.configuration.getProperties();
        Substitutor substitutor = null;
        for (String s : props.stringPropertyNames()) {
            String v = props.getProperty(s);
            if (v == null || !v.contains("${")) continue;
            if (substitutor == null) {
                HashMap<String, String> placeHolders = new HashMap<String, String>();
                placeHolders.put("meecrowave.embedded.http", Integer.toString(this.configuration.getHttpPort()));
                placeHolders.put("meecrowave.embedded.https", Integer.toString(this.configuration.getHttpsPort()));
                placeHolders.put("meecrowave.embedded.stop", Integer.toString(this.configuration.getStopPort()));
                substitutor = new Substitutor(placeHolders);
            }
            props.put(s, substitutor.replace(v));
        }
        File conf = new File(this.base, "conf");
        this.tomcat.setBaseDir(this.base.getAbsolutePath());
        this.tomcat.setHostname(this.configuration.getHost());
        if (this.configuration.getServerXml() != null) {
            File file = new File(conf, "server.xml");
            if (!file.equals(this.configuration.getServerXml())) {
                try {
                    Throwable throwable = null;
                    try (FileInputStream is = new FileInputStream(this.configuration.getServerXml());
                         FileOutputStream fos2 = new FileOutputStream(file);){
                        IO.copy(is, fos2);
                    }
                    catch (Throwable fos2) {
                        Throwable throwable2 = fos2;
                        throw fos2;
                    }
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
            }
            QuickServerXmlParser ports = QuickServerXmlParser.parse(file);
            if (this.configuration.isKeepServerXmlAsThis()) {
                this.configuration.setHttpPort(Integer.parseInt(ports.http()));
                this.configuration.setStopPort(Integer.parseInt(ports.stop()));
            } else {
                String serverXmlContent;
                Throwable throwable;
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put(ports.http(), String.valueOf(this.configuration.getHttpPort()));
                hashMap.put(ports.https(), String.valueOf(this.configuration.getHttpsPort()));
                hashMap.put(ports.stop(), String.valueOf(this.configuration.getStopPort()));
                try {
                    throwable = null;
                    try (FileInputStream stream = new FileInputStream(file);){
                        serverXmlContent = IO.toString(stream);
                        for (Map.Entry pair : hashMap.entrySet()) {
                            serverXmlContent = serverXmlContent.replace((CharSequence)pair.getKey(), (CharSequence)pair.getValue());
                        }
                    }
                    catch (Throwable throwable3) {
                        throwable = throwable3;
                        throw throwable3;
                    }
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
                try {
                    throwable = null;
                    try (FileOutputStream os = new FileOutputStream(file);){
                        ((OutputStream)os).write(serverXmlContent.getBytes(StandardCharsets.UTF_8));
                    }
                    catch (Throwable throwable4) {
                        throwable = throwable4;
                        throw throwable4;
                    }
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
            }
            this.tomcat.server(Meecrowave.createServer(file.getAbsolutePath()));
            initialized = true;
        } else {
            this.tomcat.getServer().setPort(this.configuration.getStopPort());
            initialized = false;
        }
        Optional.ofNullable(this.configuration.getSharedLibraries()).map(File::new).filter(File::isDirectory).ifPresent(libRoot -> {
            ArrayList<URL> libs = new ArrayList<URL>();
            try {
                libs.add(libRoot.toURI().toURL());
            }
            catch (MalformedURLException e) {
                throw new IllegalStateException(e);
            }
            libs.addAll(Optional.ofNullable(libRoot.listFiles((dir, name) -> name.endsWith(".jar") || name.endsWith(".zip"))).map(Stream::of).map(s -> s.map(f -> {
                try {
                    return f.toURI().toURL();
                }
                catch (MalformedURLException e) {
                    throw new IllegalStateException(e);
                }
            }).collect(Collectors.toList())).orElse(Collections.emptyList()));
            this.tomcat.getServer().setParentClassLoader((ClassLoader)new MeecrowaveContainerLoader(libs.toArray(new URL[libs.size()]), Thread.currentThread().getContextClassLoader()));
        });
        if (!initialized) {
            this.tomcat.setHostname(this.configuration.getHost());
            this.tomcat.getEngine().setDefaultHost(this.configuration.getHost());
            StandardHost host = new StandardHost();
            host.setName(this.configuration.getHost());
            try {
                File webapps = this.createDirectory(this.base, "webapps");
                host.setAppBase(webapps.getAbsolutePath());
            }
            catch (IllegalStateException webapps) {
                // empty catch block
            }
            host.setUnpackWARs(true);
            try {
                host.setWorkDir(this.workDir.getCanonicalPath());
            }
            catch (IOException e) {
                host.setWorkDir(this.workDir.getAbsolutePath());
            }
            this.tomcat.setHost((Host)host);
        }
        Optional.ofNullable(this.configuration.getTomcatAccessLogPattern()).ifPresent(pattern -> this.tomcat.getHost().getPipeline().addValve((Valve)new LoggingAccessLogPattern((String)pattern)));
        List<Valve> valves = this.buildValves();
        if (!valves.isEmpty()) {
            Pipeline pipeline = this.tomcat.getHost().getPipeline();
            valves.forEach(arg_0 -> ((Pipeline)pipeline).addValve(arg_0));
        }
        if (this.configuration.getRealm() != null) {
            this.tomcat.getEngine().setRealm(this.configuration.getRealm());
        }
        if (this.tomcat.getRawConnector() == null && !this.configuration.isSkipHttp()) {
            Connector connector = this.createConnector();
            connector.setPort(this.configuration.getHttpPort());
            if (connector.getProperty("connectionTimeout") == null) {
                connector.setProperty("connectionTimeout", "3000");
            }
            this.tomcat.getService().addConnector(connector);
            this.tomcat.setConnector(connector);
        }
        if (this.configuration.isSsl()) {
            List<SSLHostConfig> list;
            Connector httpsConnector = this.createConnector();
            httpsConnector.setPort(this.configuration.getHttpsPort());
            httpsConnector.setSecure(true);
            httpsConnector.setScheme("https");
            httpsConnector.setProperty("SSLEnabled", "true");
            if (this.configuration.getSslProtocol() != null) {
                this.configuration.getProperties().setProperty("connector.sslhostconfig.sslProtocol", this.configuration.getSslProtocol());
            }
            if (this.configuration.getProperties().getProperty("connector.sslhostconfig.hostName") != null) {
                httpsConnector.setProperty("defaultSSLHostConfigName", this.configuration.getProperties().getProperty("connector.sslhostconfig.hostName"));
            }
            if (this.configuration.getKeystoreFile() != null) {
                this.configuration.getProperties().setProperty("connector.sslhostconfig.certificateKeystoreFile", this.configuration.getKeystoreFile());
            }
            if (this.configuration.getKeystorePass() != null) {
                this.configuration.getProperties().setProperty("connector.sslhostconfig.certificateKeystorePassword", this.configuration.getKeystorePass());
            }
            this.configuration.getProperties().setProperty("connector.sslhostconfig.certificateKeystoreType", this.configuration.getKeystoreType());
            if (this.configuration.getClientAuth() != null) {
                httpsConnector.setProperty("clientAuth", this.configuration.getClientAuth());
            }
            if (this.configuration.getKeyAlias() != null) {
                this.configuration.getProperties().setProperty("connector.sslhostconfig.certificateKeyAlias", this.configuration.getKeyAlias());
            }
            if (this.configuration.isHttp2()) {
                httpsConnector.addUpgradeProtocol((UpgradeProtocol)new Http2Protocol());
            }
            if (!(list = this.buildSslHostConfig()).isEmpty()) {
                this.createDirectory(this.base, "conf");
            }
            list.forEach(sslHostConf -> {
                if (this.isCertificateFromClasspath(sslHostConf.getCertificateKeystoreFile())) {
                    this.copyCertificateToConfDir(sslHostConf.getCertificateKeystoreFile());
                    sslHostConf.setCertificateKeystoreFile(this.base.getAbsolutePath() + "/conf/" + sslHostConf.getCertificateKeystoreFile());
                }
                if (this.isCertificateFromClasspath(sslHostConf.getCertificateKeyFile())) {
                    this.copyCertificateToConfDir(sslHostConf.getCertificateKeyFile());
                    sslHostConf.setCertificateKeyFile(this.base.getAbsolutePath() + "/conf/" + sslHostConf.getCertificateKeyFile());
                    this.copyCertificateToConfDir(sslHostConf.getCertificateFile());
                    sslHostConf.setCertificateFile(this.base.getAbsolutePath() + "/conf/" + sslHostConf.getCertificateFile());
                }
                if (this.isCertificateFromClasspath(sslHostConf.getTruststoreFile())) {
                    this.copyCertificateToConfDir(sslHostConf.getTruststoreFile());
                    sslHostConf.setTruststoreFile(this.base.getAbsolutePath() + "/conf/" + sslHostConf.getTruststoreFile());
                }
                if (this.isCertificateFromClasspath(sslHostConf.getCertificateChainFile())) {
                    this.copyCertificateToConfDir(sslHostConf.getCertificateChainFile());
                    sslHostConf.setCertificateChainFile(this.base.getAbsolutePath() + "/conf/" + sslHostConf.getCertificateChainFile());
                }
            });
            list.forEach(arg_0 -> ((Connector)httpsConnector).addSslHostConfig(arg_0));
            if (this.configuration.getDefaultSSLHostConfigName() != null) {
                httpsConnector.setProperty("defaultSSLHostConfigName", this.configuration.getDefaultSSLHostConfigName());
            }
            this.tomcat.getService().addConnector(httpsConnector);
            if (this.configuration.isSkipHttp()) {
                this.tomcat.setConnector(httpsConnector);
            }
        }
        for (Connector connector : this.configuration.getConnectors()) {
            this.tomcat.getService().addConnector(connector);
        }
        if (!(this.configuration.isSkipHttp() || this.configuration.isSsl() || this.configuration.getConnectors().isEmpty())) {
            this.tomcat.setConnector(this.configuration.getConnectors().iterator().next());
        }
        if (this.configuration.getUsers() != null) {
            for (Map.Entry entry : this.configuration.getUsers().entrySet()) {
                this.tomcat.addUser((String)entry.getKey(), (String)entry.getValue());
            }
        }
        if (this.configuration.getRoles() != null) {
            for (Map.Entry entry : this.configuration.getRoles().entrySet()) {
                for (String role : ((String)entry.getValue()).split(" *, *")) {
                    this.tomcat.addRole((String)entry.getKey(), role);
                }
            }
        }
        StreamSupport.stream(ServiceLoader.load(InstanceCustomizer.class).spliterator(), false).peek(i -> {
            if (MeecrowaveAwareInstanceCustomizer.class.isInstance(i)) {
                ((MeecrowaveAwareInstanceCustomizer)MeecrowaveAwareInstanceCustomizer.class.cast(i)).setMeecrowave(this);
            }
        }).sorted(Priotities::sortByPriority).forEach(c -> c.accept(this.tomcat));
        this.configuration.getInstanceCustomizers().forEach(c -> c.accept(this.tomcat));
        StreamSupport.stream(ServiceLoader.load(ContextCustomizer.class).spliterator(), false).peek(i -> {
            if (MeecrowaveAwareContextCustomizer.class.isInstance(i)) {
                ((MeecrowaveAwareContextCustomizer)MeecrowaveAwareContextCustomizer.class.cast(i)).setMeecrowave(this);
            }
        }).sorted(Priotities::sortByPriority).forEach(this.configuration::addGlobalContextCustomizer);
        this.beforeStart();
        if (this.configuration.isInitializeClientBus() && Cxfs.IS_PRESENT && !Cxfs.hasDefaultBus()) {
            this.clientBus = new ConfigurableBus();
            this.clientBus.initProviders(this.configuration, Optional.ofNullable(Thread.currentThread().getContextClassLoader()).orElseGet(ClassLoader::getSystemClassLoader));
            this.clientBus.addClientLifecycleListener();
        }
        try {
            if (!initialized) {
                this.tomcat.init();
            }
            this.tomcat.getHost().addLifecycleListener(event -> {
                if (!Host.class.isInstance(event.getSource())) {
                    return;
                }
                this.broadcastHostEvent(event.getType(), (Host)Host.class.cast(event.getSource()));
            });
            this.tomcat.start();
        }
        catch (LifecycleException e) {
            throw new IllegalStateException(e);
        }
        Optional.ofNullable(this.configuration.getPidFile()).ifPresent(pidFile -> {
            if (pidFile.getParentFile() != null && !pidFile.getParentFile().isDirectory() && !pidFile.getParentFile().mkdirs()) {
                throw new IllegalArgumentException("Can't create " + pidFile);
            }
            String pid = ManagementFactory.getRuntimeMXBean().getName();
            int at = pid.indexOf(64);
            try (FileWriter w = new FileWriter((File)pidFile);){
                w.write(at > 0 ? pid.substring(0, at) : pid);
            }
            catch (IOException e) {
                throw new IllegalStateException("Can't write the pid in " + pid, e);
            }
        });
        if (this.configuration.isUseShutdownHook()) {
            this.hook = new Thread(() -> {
                this.hook = null;
                this.close();
            }, "meecrowave-stop-hook");
            Runtime.getRuntime().addShutdownHook(this.hook);
        }
        return this;
    }

    private boolean isCertificateFromClasspath(String certificate) {
        BiPredicate<String, String> equals = System.getProperty("os.name", "ignore").toLowerCase(Locale.ROOT).contains("win") ? String::equalsIgnoreCase : String::equals;
        return certificate != null && !new File(certificate).exists() && !equals.test(Paths.get(System.getProperty("user.home"), new String[0]).resolve(".keystore").toAbsolutePath().normalize().toString(), Paths.get(certificate, new String[0]).toAbsolutePath().normalize().toString());
    }

    private void copyCertificateToConfDir(String certificate) {
        InputStream resourceAsStream = null;
        try {
            Path dstFile = Paths.get(this.base.getAbsolutePath() + "/conf/" + certificate, new String[0]);
            resourceAsStream = Thread.currentThread().getContextClassLoader().getResourceAsStream(certificate);
            if (resourceAsStream == null) {
                resourceAsStream = new FileInputStream(new File(this.getClass().getResource("/").toString().replaceAll("file:", "") + "/" + certificate));
            }
            Files.copy(resourceAsStream, dstFile, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        finally {
            if (resourceAsStream != null) {
                try {
                    resourceAsStream.close();
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
            }
        }
    }

    public ConfigurableBus getClientBus() {
        return this.clientBus;
    }

    private void setSystemProperty(Map<String, String> backupPropertyMap, String propertyKey, String newValue) {
        backupPropertyMap.put(propertyKey, System.getProperty(propertyKey));
        System.setProperty(propertyKey, newValue);
    }

    private void broadcastHostEvent(String event, Host host) {
        switch (event) {
            case "after_start": {
                Connector connector = this.findFirstConnector();
                this.findContexts(host).forEach(ctx -> this.fire(new StartListening(connector, host, (Context)ctx), ctx.getLoader().getClassLoader()));
                break;
            }
            case "before_stop": {
                Connector connector = this.findFirstConnector();
                this.findContexts(host).forEach(ctx -> this.fire(new StopListening(connector, host, (Context)ctx), ctx.getLoader().getClassLoader()));
                break;
            }
        }
    }

    private Connector findFirstConnector() {
        return Stream.of(this.tomcat.getServer().findServices()).flatMap(s -> Stream.of(s.findConnectors())).findFirst().orElse(null);
    }

    private Stream<Context> findContexts(Host host) {
        return Stream.of(host.findChildren()).filter(Context.class::isInstance).map(Context.class::cast).filter(ctx -> ctx.getState().isAvailable());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> void fire(T event, ClassLoader classLoader) {
        Thread thread = Thread.currentThread();
        ClassLoader loader = thread.getContextClassLoader();
        thread.setContextClassLoader(classLoader);
        try {
            WebBeansContext.currentInstance().getBeanManagerImpl().getEvent().select((Class)Class.class.cast(event.getClass()), new Annotation[0]).fire(event);
        }
        finally {
            thread.setContextClassLoader(loader);
        }
    }

    private void setupJmx(boolean skip) {
        if (skip) {
            Registry.disableRegistry();
        }
    }

    private List<Valve> buildValves() {
        ArrayList<Valve> valves = new ArrayList<Valve>();
        this.configuration.getProperties().stringPropertyNames().stream().filter(key -> key.startsWith("valves.") && key.endsWith("._className")).sorted(Comparator.comparing(key -> Integer.parseInt(this.configuration.getProperties().getProperty(key.replaceFirst("\\._className$", "._order"), "0")))).map(key -> key.split("\\.")).filter(parts -> ((String[])parts).length == 3).forEach(key -> {
            String prefix = key[0] + '.' + key[1] + '.';
            ObjectRecipe recipe = Meecrowave.newRecipe(this.configuration.getProperties().getProperty(prefix + key[2]));
            this.configuration.getProperties().stringPropertyNames().stream().filter(it -> it.startsWith(prefix) && !it.endsWith("._order") && !it.endsWith("._className")).forEach(propKey -> {
                String value = this.configuration.getProperties().getProperty((String)propKey);
                recipe.setProperty(propKey.substring(prefix.length()), (Object)value);
            });
            valves.add((Valve)Valve.class.cast(recipe.create(Thread.currentThread().getContextClassLoader())));
        });
        return valves;
    }

    private List<SSLHostConfig> buildSslHostConfig() {
        ArrayList<SSLHostConfig> sslHostConfigs = new ArrayList<SSLHostConfig>();
        ObjectRecipe defaultSslHostConfig = Meecrowave.newRecipe(SSLHostConfig.class.getName());
        for (String key2 : this.configuration.getProperties().stringPropertyNames()) {
            if (!key2.startsWith("connector.sslhostconfig.") || key2.split("\\.").length != 3) continue;
            String substring = key2.substring("connector.sslhostconfig.".length());
            defaultSslHostConfig.setProperty(substring, (Object)this.configuration.getProperties().getProperty(key2));
        }
        if (!defaultSslHostConfig.getProperties().isEmpty()) {
            sslHostConfigs.add((SSLHostConfig)SSLHostConfig.class.cast(defaultSslHostConfig.create()));
        }
        Collection itemNumbers = this.configuration.getProperties().stringPropertyNames().stream().filter(key -> key.startsWith("connector.sslhostconfig.") && key.split("\\.").length == 4).map(key -> Integer.parseInt(key.split("\\.")[2])).collect(Collectors.toSet());
        itemNumbers.stream().sorted().forEach(itemNumber -> {
            ObjectRecipe recipe = Meecrowave.newRecipe(SSLHostConfig.class.getName());
            String prefix = "connector.sslhostconfig." + itemNumber + '.';
            this.configuration.getProperties().stringPropertyNames().stream().filter(k -> k.startsWith(prefix)).forEach(key -> {
                String keyName = key.split("\\.")[3];
                recipe.setProperty(keyName, (Object)this.configuration.getProperties().getProperty((String)key));
            });
            if (!recipe.getProperties().isEmpty()) {
                SSLHostConfig sslHostConfig = (SSLHostConfig)SSLHostConfig.class.cast(recipe.create());
                sslHostConfigs.add(sslHostConfig);
                new LogFacade(Meecrowave.class.getName()).info("Created SSLHostConfig #" + itemNumber + " (" + sslHostConfig.getHostName() + ")");
            }
        });
        return sslHostConfigs;
    }

    protected void beforeStart() {
    }

    protected void beforeStop() {
    }

    public <T> AutoCloseable inject(T instance) {
        BeanManager bm = CDI.current().getBeanManager();
        AnnotatedType annotatedType = bm.createAnnotatedType(instance.getClass());
        InjectionTarget injectionTarget = bm.createInjectionTarget(annotatedType);
        CreationalContext creationalContext = bm.createCreationalContext(null);
        injectionTarget.inject(instance, creationalContext);
        return () -> ((CreationalContext)creationalContext).release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public synchronized void close() {
        if (this.tomcat == null) {
            return;
        }
        if (this.hook != null) {
            Runtime.getRuntime().removeShutdownHook(this.hook);
            this.hook = null;
        }
        this.beforeStop();
        if (MeecrowaveContainerLoader.class.isInstance(this.tomcat.getServer().getParentClassLoader())) {
            try {
                ((MeecrowaveContainerLoader)MeecrowaveContainerLoader.class.cast(this.tomcat.getServer().getParentClassLoader())).close();
            }
            catch (IOException e) {
                new LogFacade(Meecrowave.class.getName()).error(e.getMessage(), e);
            }
        }
        try {
            this.contexts.values().forEach(Runnable::run);
        }
        catch (Throwable throwable) {
            this.tomcat.stop();
            this.tomcat.destroy();
            Cxfs.resetDefaultBusIfEquals(this.clientBus);
            this.tomcat = null;
            this.contexts.clear();
            if (this.clearCatalinaSystemProperties) {
                Stream.of("catalina.base", "catalina.home").forEach(System::clearProperty);
            }
            if (this.configuration.isUseLog4j2JulLogManager()) {
                System.clearProperty("java.util.logging.manager");
            }
            Optional.ofNullable(this.postTask).ifPresent(Runnable::run);
            this.postTask = null;
            try {
                if (this.deleteBase && this.base != null) {
                    IO.delete(this.base);
                }
                if (this.ownedTempDir == null) throw throwable;
                IO.delete(this.ownedTempDir);
                throw throwable;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw throwable;
            }
            finally {
                this.base = null;
                Optional.ofNullable(this.configuration.getPidFile()).ifPresent(File::delete);
            }
            catch (LifecycleException e) {
                try {
                    throw new IllegalStateException(e);
                }
                catch (Throwable throwable2) {
                    Cxfs.resetDefaultBusIfEquals(this.clientBus);
                    this.tomcat = null;
                    this.contexts.clear();
                    if (this.clearCatalinaSystemProperties) {
                        Stream.of("catalina.base", "catalina.home").forEach(System::clearProperty);
                    }
                    if (this.configuration.isUseLog4j2JulLogManager()) {
                        System.clearProperty("java.util.logging.manager");
                    }
                    Optional.ofNullable(this.postTask).ifPresent(Runnable::run);
                    this.postTask = null;
                    try {
                        if (this.deleteBase && this.base != null) {
                            IO.delete(this.base);
                        }
                        if (this.ownedTempDir == null) throw throwable2;
                        IO.delete(this.ownedTempDir);
                        throw throwable2;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw throwable2;
                    }
                    finally {
                        this.base = null;
                        Optional.ofNullable(this.configuration.getPidFile()).ifPresent(File::delete);
                    }
                }
            }
        }
        this.tomcat.stop();
        this.tomcat.destroy();
        Cxfs.resetDefaultBusIfEquals(this.clientBus);
        this.tomcat = null;
        this.contexts.clear();
        if (this.clearCatalinaSystemProperties) {
            Stream.of("catalina.base", "catalina.home").forEach(System::clearProperty);
        }
        if (this.configuration.isUseLog4j2JulLogManager()) {
            System.clearProperty("java.util.logging.manager");
        }
        Optional.ofNullable(this.postTask).ifPresent(Runnable::run);
        this.postTask = null;
        try {
            if (this.deleteBase && this.base != null) {
                IO.delete(this.base);
            }
            if (this.ownedTempDir == null) return;
            IO.delete(this.ownedTempDir);
            return;
        }
        catch (IllegalArgumentException e) {
            return;
        }
        finally {
            this.base = null;
            Optional.ofNullable(this.configuration.getPidFile()).ifPresent(File::delete);
        }
        catch (LifecycleException e) {
            try {
                throw new IllegalStateException(e);
            }
            catch (Throwable throwable) {
                Cxfs.resetDefaultBusIfEquals(this.clientBus);
                this.tomcat = null;
                this.contexts.clear();
                if (this.clearCatalinaSystemProperties) {
                    Stream.of("catalina.base", "catalina.home").forEach(System::clearProperty);
                }
                if (this.configuration.isUseLog4j2JulLogManager()) {
                    System.clearProperty("java.util.logging.manager");
                }
                Optional.ofNullable(this.postTask).ifPresent(Runnable::run);
                this.postTask = null;
                try {
                    if (this.deleteBase && this.base != null) {
                        IO.delete(this.base);
                    }
                    if (this.ownedTempDir == null) throw throwable;
                    IO.delete(this.ownedTempDir);
                    throw throwable;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw throwable;
                }
                finally {
                    this.base = null;
                    Optional.ofNullable(this.configuration.getPidFile()).ifPresent(File::delete);
                }
            }
        }
    }

    protected Connector createConnector() {
        Connector connector;
        Properties properties = this.configuration.getProperties();
        if (properties != null) {
            HashMap<String, String> attributes = new HashMap<String, String>();
            ObjectRecipe recipe = Meecrowave.newRecipe(Connector.class.getName());
            for (String string : properties.stringPropertyNames()) {
                String substring;
                if (!string.startsWith("connector.") || (substring = string.substring("connector.".length())).startsWith("sslhostconfig.")) continue;
                if (!substring.startsWith("attributes.")) {
                    recipe.setProperty(substring, (Object)properties.getProperty(string));
                    continue;
                }
                attributes.put(substring.substring("attributes.".length()), properties.getProperty(string));
            }
            connector = recipe.getProperties().isEmpty() ? new Connector() : (Connector)Connector.class.cast(recipe.create());
            for (Map.Entry entry : attributes.entrySet()) {
                connector.setProperty((String)entry.getKey(), (String)entry.getValue());
            }
        } else {
            connector = new Connector();
        }
        return connector;
    }

    private static Server createServer(String serverXml) {
        Catalina catalina = new Catalina(){

            protected void initStreams() {
            }

            protected void initNaming() {
            }
        };
        catalina.setConfigFile(serverXml);
        catalina.load();
        return catalina.getServer();
    }

    private File createDirectory(File parent, String directory) {
        File dir = new File(parent, directory);
        IO.mkdirs(dir);
        return dir;
    }

    private void synchronize(File base, String resourceBase) {
        if (resourceBase == null) {
            return;
        }
        try {
            Map urls = new ResourceFinder("").getResourcesMap(resourceBase);
            for (Map.Entry u : urls.entrySet()) {
                InputStream is = ((URL)u.getValue()).openStream();
                Throwable throwable = null;
                try {
                    File to = new File(base, (String)u.getKey());
                    File parentFile = to.getParentFile();
                    this.createDirectory(parentFile.getParentFile(), parentFile.getName());
                    try (FileOutputStream os = new FileOutputStream(to);){
                        IO.copy(is, os);
                    }
                    if (!"server.xml".equals(u.getKey())) continue;
                    this.configuration.setServerXml(to.getAbsolutePath());
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (is == null) continue;
                    if (throwable != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    is.close();
                }
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private String newBaseDir() {
        this.deleteBase = false;
        String dir = this.configuration.getDir();
        if (dir != null) {
            File dirFile = new File(dir);
            if (dirFile.exists()) {
                if (this.base != null && this.base.exists() && this.configuration.isDeleteBaseOnStartup()) {
                    IO.delete(this.base);
                }
                return dir;
            }
            IO.mkdirs(dirFile);
            return dirFile.getAbsolutePath();
        }
        String base = System.getProperty("meecrowave.base");
        if (base != null && new File(base).exists()) {
            return new File(base).getAbsolutePath();
        }
        this.deleteBase = true;
        ArrayList<String> lookupPaths = new ArrayList<String>();
        lookupPaths.add("target");
        lookupPaths.add("build");
        File file = lookupPaths.stream().map(File::new).filter(File::isDirectory).findFirst().map(file1 -> new File((File)file1, "meecrowave-" + System.nanoTime())).orElse(this.ownedTempDir);
        IO.mkdirs(file);
        return file.getAbsolutePath();
    }

    public void await() {
        this.tomcat.getServer().await();
    }

    private static ObjectRecipe newRecipe(String clazz) {
        ObjectRecipe recipe = new ObjectRecipe(clazz);
        recipe.allow(Option.FIELD_INJECTION);
        recipe.allow(Option.PRIVATE_PROPERTIES);
        return recipe;
    }

    private static final class MeecrowaveContainerLoader
    extends URLClassLoader {
        private MeecrowaveContainerLoader(URL[] urls, ClassLoader parent) {
            super(urls, parent);
        }
    }

    public static interface MeecrowaveAwareInstanceCustomizer
    extends InstanceCustomizer {
        public void setMeecrowave(Meecrowave var1);
    }

    public static interface MeecrowaveAwareContextCustomizer
    extends ContextCustomizer {
        public void setMeecrowave(Meecrowave var1);
    }

    public static interface ContextCustomizer
    extends Consumer<Context> {
    }

    public static interface InstanceCustomizer
    extends Consumer<Tomcat> {
    }

    public static interface ConfigurationCustomizer
    extends Consumer<Configuration> {
    }

    public static class DeploymentMeta {
        private final String context;
        private final File docBase;
        private final Consumer<Context> consumer;
        private final Consumer<Context> redeployCallback;

        public DeploymentMeta(String context, File docBase, Consumer<Context> consumer, Consumer<Context> redeployCallback) {
            this.context = context;
            this.docBase = docBase;
            this.consumer = consumer;
            this.redeployCallback = redeployCallback;
        }
    }

    private static class QuickServerXmlParser
    extends DefaultHandler {
        private static final SAXParserFactory FACTORY = SAXParserFactory.newInstance();
        private static final String STOP_KEY = "STOP";
        private static final String HTTP_KEY = "HTTP";
        private static final String SECURED_SUFFIX = "S";
        private static final String HOST_KEY = "host";
        private static final String DEFAULT_CONNECTOR_KEY = "HTTP";
        private static final String DEFAULT_HTTP_PORT = "8080";
        private static final String DEFAULT_HTTPS_PORT = "8443";
        private static final String DEFAULT_STOP_PORT = "8005";
        private static final String DEFAULT_HOST = "localhost";
        private final Map<String, String> values = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);

        private QuickServerXmlParser(boolean useDefaults) {
            if (useDefaults) {
                this.values.put(STOP_KEY, DEFAULT_STOP_PORT);
                this.values.put("HTTP", DEFAULT_HTTP_PORT);
                this.values.put(HOST_KEY, DEFAULT_HOST);
            }
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            String host;
            if ("Server".equalsIgnoreCase(localName)) {
                String port = attributes.getValue("port");
                if (port != null) {
                    this.values.put(STOP_KEY, port);
                } else {
                    this.values.put(STOP_KEY, DEFAULT_STOP_PORT);
                }
            } else if ("Connector".equalsIgnoreCase(localName)) {
                String protocol = attributes.getValue("protocol");
                if (protocol == null) {
                    protocol = "HTTP";
                } else if (protocol.contains("/")) {
                    protocol = protocol.substring(0, protocol.indexOf("/"));
                }
                String port = attributes.getValue("port");
                String ssl = attributes.getValue("secure");
                if (ssl == null || "false".equalsIgnoreCase(ssl)) {
                    this.values.put(protocol.toUpperCase(), port);
                } else {
                    this.values.put(protocol.toUpperCase() + SECURED_SUFFIX, port);
                }
            } else if ("Host".equalsIgnoreCase(localName) && (host = attributes.getValue("name")) != null) {
                this.values.put(HOST_KEY, host);
            }
        }

        private static QuickServerXmlParser parse(File serverXml) {
            return QuickServerXmlParser.parse(serverXml, true);
        }

        private static QuickServerXmlParser parse(File serverXml, boolean defaults) {
            QuickServerXmlParser handler = new QuickServerXmlParser(defaults);
            try {
                SAXParser parser = FACTORY.newSAXParser();
                parser.parse(serverXml, (DefaultHandler)handler);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return handler;
        }

        public String http() {
            return this.value("HTTP", DEFAULT_HTTP_PORT);
        }

        private String https() {
            return this.securedValue("HTTP", DEFAULT_HTTPS_PORT);
        }

        private String stop() {
            return this.value(STOP_KEY, DEFAULT_STOP_PORT);
        }

        private String value(String key, String defaultValue) {
            String val = this.values.get(key);
            if (val == null) {
                return defaultValue;
            }
            return val;
        }

        private String securedValue(String key, String defaultValue) {
            return this.value(key + SECURED_SUFFIX, defaultValue);
        }

        static {
            FACTORY.setNamespaceAware(true);
            FACTORY.setValidating(false);
        }
    }

    private static class InternalTomcat
    extends Tomcat {
        private Connector connector;

        private InternalTomcat() {
        }

        private void server(Server s) {
            this.server = s;
            this.connector = this.server != null && this.server.findServices().length > 0 && this.server.findServices()[0].findConnectors().length > 0 ? this.server.findServices()[0].findConnectors()[0] : null;
        }

        Connector getRawConnector() {
            return this.connector;
        }
    }

    public static class SecurityConstaintBuilder {
        private final SecurityConstraint securityConstraint = new SecurityConstraint();

        public SecurityConstaintBuilder authConstraint(boolean authConstraint) {
            this.securityConstraint.setAuthConstraint(authConstraint);
            return this;
        }

        public SecurityConstaintBuilder displayName(String displayName) {
            this.securityConstraint.setDisplayName(displayName);
            return this;
        }

        public SecurityConstaintBuilder userConstraint(String constraint) {
            this.securityConstraint.setUserConstraint(constraint);
            return this;
        }

        public SecurityConstaintBuilder addAuthRole(String authRole) {
            this.securityConstraint.addAuthRole(authRole);
            return this;
        }

        public SecurityConstaintBuilder addCollection(String name, String pattern, String ... methods) {
            SecurityCollection collection = new SecurityCollection();
            collection.setName(name);
            collection.addPattern(pattern);
            for (String httpMethod : methods) {
                collection.addMethod(httpMethod);
            }
            this.securityConstraint.addCollection(collection);
            return this;
        }

        public void setAuthConstraint(boolean authConstraint) {
            this.securityConstraint.setAuthConstraint(authConstraint);
        }

        public void setDisplayName(String displayName) {
            this.securityConstraint.setDisplayName(displayName);
        }

        public void setUserConstraint(String userConstraint) {
            this.securityConstraint.setUserConstraint(userConstraint);
        }

        public void setAuthRole(String authRole) {
            this.addAuthRole(authRole);
        }

        public void setCollection(String value) {
            String[] split = value.split(":");
            if (split.length != 3 && split.length != 2) {
                throw new IllegalArgumentException("Can't parse " + value + ", syntax is: name:pattern:method1/method2");
            }
            this.addCollection(split[0], split[1], split.length == 2 ? new String[]{} : split[2].split("/"));
        }

        public SecurityConstraint build() {
            return this.securityConstraint;
        }
    }

    public static class LoginConfigBuilder {
        private final LoginConfig loginConfig = new LoginConfig();

        public void setErrorPage(String errorPage) {
            this.loginConfig.setErrorPage(errorPage);
        }

        public void setLoginPage(String loginPage) {
            this.loginConfig.setLoginPage(loginPage);
        }

        public void setRealmName(String realmName) {
            this.loginConfig.setRealmName(realmName);
        }

        public void setAuthMethod(String authMethod) {
            this.loginConfig.setAuthMethod(authMethod);
        }

        public LoginConfigBuilder errorPage(String errorPage) {
            this.loginConfig.setErrorPage(errorPage);
            return this;
        }

        public LoginConfigBuilder loginPage(String loginPage) {
            this.loginConfig.setLoginPage(loginPage);
            return this;
        }

        public LoginConfigBuilder realmName(String realmName) {
            this.loginConfig.setRealmName(realmName);
            return this;
        }

        public LoginConfigBuilder authMethod(String authMethod) {
            this.loginConfig.setAuthMethod(authMethod);
            return this;
        }

        public LoginConfig build() {
            return this.loginConfig;
        }

        public LoginConfigBuilder basic() {
            return this.authMethod("BASIC");
        }

        public LoginConfigBuilder digest() {
            return this.authMethod("DIGEST");
        }

        public LoginConfigBuilder clientCert() {
            return this.authMethod("CLIENT-CERT");
        }

        public LoginConfigBuilder form() {
            return this.authMethod("FORM");
        }
    }

    public static class ValueTransformers
    implements Function<String, String> {
        private final Map<String, ValueTransformer> transformers = new HashMap<String, ValueTransformer>();

        @Override
        public String apply(String value) {
            if (value.startsWith("decode:")) {
                String substring;
                int sep;
                if (this.transformers.isEmpty()) {
                    this.transformers.put("Static3DES", new ValueTransformer(){
                        private final SecretKeySpec key = new SecretKeySpec(new byte[]{118, 111, -70, 57, 49, 47, 13, 74, -93, -112, 85, -2, 85, 101, 97, 19, 52, -126, 18, 23, -84, 119, 57, 25}, "DESede");

                        @Override
                        public String name() {
                            return "Static3DES";
                        }

                        @Override
                        public String apply(String encodedPassword) {
                            Objects.requireNonNull(encodedPassword, "value can't be null");
                            try {
                                byte[] cipherText = Base64.getDecoder().decode(encodedPassword);
                                Cipher cipher = Cipher.getInstance("DESede");
                                cipher.init(2, this.key);
                                return new String(cipher.doFinal(cipherText), StandardCharsets.UTF_8);
                            }
                            catch (Exception e) {
                                throw new IllegalArgumentException(e);
                            }
                        }
                    });
                    for (ValueTransformer t : ServiceLoader.load(ValueTransformer.class)) {
                        this.transformers.put(t.name(), t);
                    }
                }
                if ((sep = (substring = value.substring("decode:".length())).indexOf(58)) < 0) {
                    throw new IllegalArgumentException("No transformer algorithm for " + value);
                }
                String algo = substring.substring(0, sep);
                return (String)Objects.requireNonNull(this.transformers.get(algo), "No ValueTransformer for value '" + value + "'").apply(substring.substring(sep + 1));
            }
            return value;
        }
    }

    public static class Builder
    extends Configuration {
        public Builder() {
        }

        public Builder(Configuration configuration) {
            super(configuration);
        }

        @Override
        public Builder loadFrom(String resource) {
            super.loadFrom(resource);
            return this;
        }

        public Builder excludePackages(String packages) {
            this.setScanningPackageExcludes(packages);
            return this;
        }

        public Builder includePackages(String packages) {
            this.setScanningPackageIncludes(packages);
            this.setScanningPackageExcludes("*");
            return this;
        }

        public Builder withPackages(String packages) {
            this.setScanningPackageIncludes(packages);
            return this;
        }

        public Builder sharedLibraries(String sharedLibraries) {
            this.setSharedLibraries(sharedLibraries);
            return this;
        }

        public Builder securityConstraints(SecurityConstaintBuilder securityConstraint) {
            if (this.getSecurityConstraints() == null) {
                this.setSecurityConstraints(new ArrayList<SecurityConstaintBuilder>());
            }
            this.getSecurityConstraints().add(securityConstraint);
            return this;
        }

        public Builder randomHttpPort() {
            try (ServerSocket serverSocket = new ServerSocket(0);){
                this.setHttpPort(serverSocket.getLocalPort());
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
            return this;
        }

        public Builder randomHttpsPort() {
            try (ServerSocket serverSocket = new ServerSocket(0);){
                this.setHttpsPort(serverSocket.getLocalPort());
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
            return this;
        }

        public Builder property(String key, String value) {
            this.getProperties().setProperty(key, value);
            return this;
        }

        public Builder user(String name, String pwd) {
            if (this.getUsers() == null) {
                this.setUsers(new HashMap<String, String>());
            }
            this.getUsers().put(name, pwd);
            return this;
        }

        public Builder role(String user, String roles) {
            if (this.getRoles() == null) {
                this.setRoles(new HashMap<String, String>());
            }
            this.getRoles().put(user, roles);
            return this;
        }

        public Builder cxfServletParam(String key, String value) {
            if (this.getCxfServletParams() == null) {
                this.setCxfServletParams(new HashMap<String, String>());
            }
            this.getCxfServletParams().put(key, value);
            return this;
        }

        @Deprecated
        public Builder withJsonpBufferStrategy(String jsonpBufferStrategy) {
            this.setJsonpBufferStrategy(jsonpBufferStrategy);
            return this;
        }

        public Builder noShutdownHook() {
            this.setUseShutdownHook(false);
            return this;
        }

        public Builder instanceCustomizer(Consumer<Tomcat> customizer) {
            this.addInstanceCustomizer(customizer);
            return this;
        }

        public Builder pidFile(Path pidFile) {
            this.setPidFile(pidFile.toFile());
            return this;
        }

        public Builder watcherBouncing(int watcherBouncing) {
            this.setWatcherBouncing(watcherBouncing);
            return this;
        }

        public Builder httpPort(int httpPort) {
            if (httpPort <= 0) {
                this.randomHttpPort();
            } else {
                this.setHttpPort(httpPort);
            }
            return this;
        }

        public Builder httpsPort(int httpsPort) {
            if (httpsPort <= 0) {
                this.randomHttpsPort();
            } else {
                this.setHttpsPort(httpsPort);
            }
            return this;
        }

        public Builder stopPort(int stopPort) {
            this.setStopPort(stopPort);
            return this;
        }

        public Builder host(String host) {
            this.setHost(host);
            return this;
        }

        public Builder dir(String dir) {
            this.setDir(dir);
            return this;
        }

        public Builder serverXml(Path serverXml) {
            this.setServerXml(serverXml.toFile());
            return this;
        }

        public Builder keepServerXmlAsThis(boolean keepServerXmlAsThis) {
            this.setKeepServerXmlAsThis(keepServerXmlAsThis);
            return this;
        }

        public Builder properties(Properties properties) {
            this.getProperties().putAll((Map<?, ?>)properties);
            return this;
        }

        public Builder quickSession(boolean quickSession) {
            this.setQuickSession(quickSession);
            return this;
        }

        public Builder skipHttp(boolean skipHttp) {
            this.setSkipHttp(skipHttp);
            return this;
        }

        public Builder ssl(boolean ssl) {
            this.setSsl(ssl);
            return this;
        }

        public Builder keystoreFile(String keystoreFile) {
            this.setKeystoreFile(keystoreFile);
            return this;
        }

        public Builder keystorePass(String keystorePass) {
            this.setKeystorePass(keystorePass);
            return this;
        }

        public Builder keystoreType(String keystoreType) {
            this.setKeystoreType(keystoreType);
            return this;
        }

        public Builder clientAuth(String clientAuth) {
            this.setClientAuth(clientAuth);
            return this;
        }

        public Builder keyAlias(String keyAlias) {
            this.setKeyAlias(keyAlias);
            return this;
        }

        public Builder sslProtocol(String sslProtocol) {
            this.setSslProtocol(sslProtocol);
            return this;
        }

        public Builder webXml(String webXml) {
            this.setWebXml(webXml);
            return this;
        }

        public Builder loginConfig(LoginConfigBuilder loginConfig) {
            this.setLoginConfig(loginConfig);
            return this;
        }

        public Builder securityConstraint(SecurityConstaintBuilder securityConstraint) {
            if (this.getSecurityConstraints() == null) {
                this.setSecurityConstraints(new ArrayList<SecurityConstaintBuilder>());
            }
            this.getSecurityConstraints().add(securityConstraint);
            return this;
        }

        public Builder realm(Realm realm) {
            this.setRealm(realm);
            return this;
        }

        public Builder users(Map<String, String> users) {
            if (this.getUsers() == null) {
                this.setUsers(new HashMap<String, String>());
            }
            this.getUsers().putAll(users);
            return this;
        }

        public Builder roles(Map<String, String> roles) {
            if (this.getRoles() == null) {
                this.setRoles(new HashMap<String, String>());
            }
            this.getRoles().putAll(roles);
            return this;
        }

        public Builder http2(boolean http2) {
            this.setHttp2(http2);
            return this;
        }

        public Builder connector(Connector connector) {
            this.getConnectors().add(connector);
            return this;
        }

        public Builder tempDir(String tempDir) {
            this.setTempDir(tempDir);
            return this;
        }

        public Builder webResourceCached(boolean webResourceCached) {
            this.setWebResourceCached(webResourceCached);
            return this;
        }

        public Builder conf(String conf) {
            this.setConf(conf);
            return this;
        }

        public Builder deleteBaseOnStartup(boolean deleteBaseOnStartup) {
            this.setDeleteBaseOnStartup(deleteBaseOnStartup);
            return this;
        }

        public Builder jaxrsMapping(String jaxrsMapping) {
            this.setJaxrsMapping(jaxrsMapping);
            return this;
        }

        public Builder cdiConversation(boolean cdiConversation) {
            this.setCdiConversation(cdiConversation);
            return this;
        }

        public Builder jaxrsProviderSetup(boolean jaxrsProviderSetup) {
            this.setJaxrsProviderSetup(jaxrsProviderSetup);
            return this;
        }

        public Builder jaxrsDefaultProviders(String jaxrsDefaultProviders) {
            this.setJaxrsDefaultProviders(jaxrsDefaultProviders);
            return this;
        }

        public Builder jaxrsAutoActivateBeanValidation(boolean jaxrsAutoActivateBeanValidation) {
            this.setJaxrsAutoActivateBeanValidation(jaxrsAutoActivateBeanValidation);
            return this;
        }

        public Builder jaxrsLogProviders(boolean jaxrsLogProviders) {
            this.setJaxrsLogProviders(jaxrsLogProviders);
            return this;
        }

        public Builder jsonpBufferStrategy(String jsonpBufferStrategy) {
            this.setJsonpBufferStrategy(jsonpBufferStrategy);
            return this;
        }

        public Builder jsonpMaxStringLen(int jsonpMaxStringLen) {
            this.setJsonpMaxStringLen(jsonpMaxStringLen);
            return this;
        }

        public Builder jsonpMaxReadBufferLen(int jsonpMaxReadBufferLen) {
            this.setJsonpMaxReadBufferLen(jsonpMaxReadBufferLen);
            return this;
        }

        public Builder jsonpMaxWriteBufferLen(int jsonpMaxWriteBufferLen) {
            this.setJsonpMaxWriteBufferLen(jsonpMaxWriteBufferLen);
            return this;
        }

        public Builder jsonpSupportsComment(boolean jsonpSupportsComment) {
            this.setJsonpSupportsComment(jsonpSupportsComment);
            return this;
        }

        public Builder jsonpPrettify(boolean jsonpPrettify) {
            this.setJsonpPrettify(jsonpPrettify);
            return this;
        }

        public Builder jsonbEncoding(String jsonbEncoding) {
            this.setJsonbEncoding(jsonbEncoding);
            return this;
        }

        public Builder jsonbNulls(boolean jsonbNulls) {
            this.setJsonbNulls(jsonbNulls);
            return this;
        }

        public Builder jsonbIJson(boolean jsonbIJson) {
            this.setJsonbIJson(jsonbIJson);
            return this;
        }

        public Builder jsonbPrettify(boolean jsonbPrettify) {
            this.setJsonbPrettify(jsonbPrettify);
            return this;
        }

        public Builder jsonbBinaryStrategy(String jsonbBinaryStrategy) {
            this.setJsonbBinaryStrategy(jsonbBinaryStrategy);
            return this;
        }

        public Builder jsonbNamingStrategy(String jsonbNamingStrategy) {
            this.setJsonbNamingStrategy(jsonbNamingStrategy);
            return this;
        }

        public Builder jsonbOrderStrategy(String jsonbOrderStrategy) {
            this.setJsonbOrderStrategy(jsonbOrderStrategy);
            return this;
        }

        public Builder loggingGlobalSetup(boolean loggingGlobalSetup) {
            this.setLoggingGlobalSetup(loggingGlobalSetup);
            return this;
        }

        public Builder tomcatScanning(boolean tomcatScanning) {
            this.setTomcatScanning(tomcatScanning);
            return this;
        }

        public Builder tomcatAutoSetup(boolean tomcatAutoSetup) {
            this.setTomcatAutoSetup(tomcatAutoSetup);
            return this;
        }

        public Builder tomcatJspDevelopment(boolean tomcatJspDevelopment) {
            this.setTomcatJspDevelopment(tomcatJspDevelopment);
            return this;
        }

        public Builder useShutdownHook(boolean useShutdownHook) {
            this.setUseShutdownHook(useShutdownHook);
            return this;
        }

        public Builder tomcatFilter(String tomcatFilter) {
            this.setTomcatFilter(tomcatFilter);
            return this;
        }

        public Builder scanningIncludes(String scanningIncludes) {
            this.setScanningIncludes(scanningIncludes);
            return this;
        }

        public Builder scanningExcludes(String scanningExcludes) {
            this.setScanningExcludes(scanningExcludes);
            return this;
        }

        public Builder scanningPackageIncludes(String scanningPackageIncludes) {
            this.setScanningPackageIncludes(scanningPackageIncludes);
            return this;
        }

        public Builder scanningPackageIncludes(Collection<String> scanningPackageIncludes) {
            this.setScanningPackageIncludes(String.join((CharSequence)",", scanningPackageIncludes));
            return this;
        }

        public Builder scanningPackageExcludes(String scanningPackageExcludes) {
            this.setScanningPackageExcludes(scanningPackageExcludes);
            return this;
        }

        public Builder scanningPackageExcludes(Collection<String> scanningPackageExcludes) {
            this.setScanningPackageExcludes(String.join((CharSequence)",", scanningPackageExcludes));
            return this;
        }

        public Builder webSessionTimeout(int webSessionTimeout) {
            this.setWebSessionTimeout(webSessionTimeout);
            return this;
        }

        public Builder webSessionCookieConfig(String webSessionCookieConfig) {
            this.setWebSessionCookieConfig(webSessionCookieConfig);
            return this;
        }

        public Builder useTomcatDefaults(boolean useTomcatDefaults) {
            this.setUseTomcatDefaults(useTomcatDefaults);
            return this;
        }

        public Builder tomcatWrapLoader(boolean tomcatWrapLoader) {
            this.setTomcatWrapLoader(tomcatWrapLoader);
            return this;
        }

        public Builder tomcatNoJmx(boolean tomcatNoJmx) {
            this.setTomcatNoJmx(tomcatNoJmx);
            return this;
        }

        public Builder useLog4j2JulLogManager(boolean useLog4j2JulLogManager) {
            this.setUseLog4j2JulLogManager(useLog4j2JulLogManager);
            return this;
        }

        public Builder injectServletContainerInitializer(boolean injectServletContainerInitializer) {
            this.setInjectServletContainerInitializer(injectServletContainerInitializer);
            return this;
        }

        public Builder tomcatAccessLogPattern(String tomcatAccessLogPattern) {
            this.setTomcatAccessLogPattern(tomcatAccessLogPattern);
            return this;
        }

        public Builder meecrowaveProperties(String meecrowaveProperties) {
            this.setMeecrowaveProperties(meecrowaveProperties);
            return this;
        }

        public Builder jaxwsSupportIfAvailable(boolean jaxwsSupportIfAvailable) {
            this.setJaxwsSupportIfAvailable(jaxwsSupportIfAvailable);
            return this;
        }

        public Builder defaultSSLHostConfigName(String defaultSSLHostConfigName) {
            this.setDefaultSSLHostConfigName(defaultSSLHostConfigName);
            return this;
        }

        public Builder initializeClientBus(boolean initializeClientBus) {
            this.setInitializeClientBus(initializeClientBus);
            return this;
        }

        public Builder instanceCustomizers(Consumer<Tomcat> instanceCustomizer) {
            this.addInstanceCustomizer(instanceCustomizer);
            return this;
        }

        public Builder initializer(ServletContainerInitializer initializer) {
            this.addServletContextInitializer(initializer);
            return this;
        }

        public Builder antiResourceLocking(boolean antiResourceLocking) {
            this.setAntiResourceLocking(antiResourceLocking);
            return this;
        }

        public Builder contextConfigurer(Consumer<Context> contextConfigurers) {
            this.addGlobalContextCustomizer(contextConfigurers);
            return this;
        }
    }
}

