/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.microprofile.opentracing.microprofile.cdi;

import io.opentracing.ScopeManager;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.BeforeBeanDiscovery;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.enterprise.inject.spi.WithAnnotations;
import javax.enterprise.inject.spi.configurator.AnnotatedTypeConfigurator;
import javax.ws.rs.HttpMethod;
import javax.ws.rs.Path;
import org.apache.geronimo.microprofile.opentracing.common.config.GeronimoOpenTracingConfig;
import org.apache.geronimo.microprofile.opentracing.common.impl.IdGenerator;
import org.apache.geronimo.microprofile.opentracing.common.microprofile.client.OpenTracingClientRequestFilter;
import org.apache.geronimo.microprofile.opentracing.common.microprofile.client.OpenTracingClientResponseFilter;
import org.apache.geronimo.microprofile.opentracing.common.microprofile.thread.OpenTracingExecutorService;
import org.apache.geronimo.microprofile.opentracing.microprofile.cdi.TracedExecutorService;
import org.apache.geronimo.microprofile.opentracing.microprofile.zipkin.CdiZipkinConverter;
import org.apache.geronimo.microprofile.opentracing.microprofile.zipkin.CdiZipkinHttp;
import org.apache.geronimo.microprofile.opentracing.microprofile.zipkin.CdiZipkinLogger;
import org.eclipse.microprofile.opentracing.Traced;

public class OpenTracingExtension
implements Extension {
    private GeronimoOpenTracingConfig config;
    private boolean useZipkin;
    private String zipkinSender;

    void onStart(@Observes BeforeBeanDiscovery beforeBeanDiscovery) {
        this.config = GeronimoOpenTracingConfig.create();
        this.useZipkin = Boolean.parseBoolean(this.config.read("span.converter.zipkin.active", "true"));
        this.zipkinSender = this.config.read("span.converter.zipkin.sender", "logger");
    }

    void vetoDefaultConfigIfScanned(@Observes ProcessAnnotatedType<GeronimoOpenTracingConfig> config) {
        if (config.getAnnotatedType().getJavaClass().getName().equals("org.apache.geronimo.microprofile.opentracing.common.config.DefaultOpenTracingConfig")) {
            config.veto();
        }
    }

    void vetoDefaultScopeManagerIfScanned(@Observes ProcessAnnotatedType<ScopeManager> manager) {
        if (manager.getAnnotatedType().getJavaClass().getName().equals("org.apache.geronimo.microprofile.opentracing.common.impl.ScopeManagerImpl")) {
            manager.veto();
        }
    }

    void vetoDefaultIdGeneratorIfScanned(@Observes ProcessAnnotatedType<IdGenerator> generator) {
        if (generator.getAnnotatedType().getJavaClass().getName().equals("org.apache.geronimo.microprofile.opentracing.common.impl.IdGenerator")) {
            generator.veto();
        }
    }

    void vetoClientRequestTracingIfScanned(@Observes ProcessAnnotatedType<OpenTracingClientRequestFilter> clientFilter) {
        if (clientFilter.getAnnotatedType().getJavaClass().getName().equals("org.apache.geronimo.microprofile.opentracing.common.microprofile.client.OpenTracingClientRequestFilter")) {
            clientFilter.veto();
        }
    }

    void vetoClientResponseTracingIfScanned(@Observes ProcessAnnotatedType<OpenTracingClientResponseFilter> clientFilter) {
        if (clientFilter.getAnnotatedType().getJavaClass().getName().equals("org.apache.geronimo.microprofile.opentracing.common.microprofile.client.OpenTracingClientResponseFilter")) {
            clientFilter.veto();
        }
    }

    void zipkinConverterToggle(@Observes ProcessAnnotatedType<CdiZipkinConverter> onZipkinConverter) {
        if (!this.useZipkin) {
            onZipkinConverter.veto();
        }
    }

    void zipkinLoggerToggle(@Observes ProcessAnnotatedType<CdiZipkinLogger> onZipkinLogger) {
        if (!"logger".equalsIgnoreCase(this.zipkinSender) || !Boolean.parseBoolean(this.config.read("span.converter.zipkin.logger.active", "true"))) {
            onZipkinLogger.veto();
        }
    }

    void zipkinHttpToggle(@Observes ProcessAnnotatedType<CdiZipkinHttp> onZipkinHttp) {
        if (!"http".equalsIgnoreCase(this.zipkinSender) || !Boolean.parseBoolean(this.config.read("span.converter.zipkin.http.active", "true"))) {
            onZipkinHttp.veto();
        }
    }

    <T> void removeTracedFromJaxRsEndpoints(@Observes @WithAnnotations(value={Traced.class}) ProcessAnnotatedType<T> pat) {
        if (this.isJaxRs(pat.getAnnotatedType())) {
            AnnotatedTypeConfigurator configurator = pat.configureAnnotatedType();
            configurator.remove(it -> it.annotationType() == Traced.class);
            configurator.methods().stream().filter(m -> this.isJaxRs(m.getAnnotated())).forEach(m -> m.remove(it -> it.annotationType() == Traced.class));
        }
    }

    <T> void instrumentExecutorServices(@Observes ProcessAnnotatedType<T> pat) {
        Set typeClosure = pat.getAnnotatedType().getTypeClosure();
        if (typeClosure.contains(ExecutorService.class) && !typeClosure.contains(OpenTracingExecutorService.class)) {
            pat.configureAnnotatedType().add((Annotation)TracedExecutorService.Literal.INSTANCE);
        }
    }

    void addConfigAsBean(@Observes AfterBeanDiscovery afterBeanDiscovery) {
        afterBeanDiscovery.addBean().id(OpenTracingExtension.class.getName() + "#" + GeronimoOpenTracingConfig.class.getName()).beanClass(GeronimoOpenTracingConfig.class).types(new Type[]{GeronimoOpenTracingConfig.class, Object.class}).qualifiers(new Annotation[]{Default.Literal.INSTANCE, Any.Literal.INSTANCE}).scope(ApplicationScoped.class).createWith(ctx -> this.config);
    }

    private <T> boolean isJaxRs(AnnotatedType<T> annotatedType) {
        return annotatedType.getAnnotations().stream().anyMatch(it -> it.annotationType() == Path.class) || annotatedType.getMethods().stream().anyMatch(this::isJaxRs);
    }

    private <T> boolean isJaxRs(AnnotatedMethod<? super T> m) {
        return m.getAnnotations().stream().anyMatch(it -> it.annotationType().isAnnotationPresent(HttpMethod.class));
    }
}

