/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.microprofile.opentracing.common.microprofile.zipkin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import java.util.stream.Stream;
import javax.json.bind.Jsonb;
import javax.json.bind.JsonbBuilder;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.geronimo.microprofile.opentracing.common.config.GeronimoOpenTracingConfig;
import org.apache.geronimo.microprofile.opentracing.common.microprofile.zipkin.ZipkinSpan;
import org.apache.geronimo.microprofile.opentracing.common.spi.Listener;
import org.eclipse.microprofile.opentracing.ClientTracingRegistrar;

public class ZipkinHttp
implements Listener<ZipkinSpan> {
    private GeronimoOpenTracingConfig config;
    private Jsonb jsonb;
    private BlockingQueue<ZipkinSpan> spans;
    private Client client;
    private String collector;
    private ScheduledExecutorService executor;
    private ScheduledFuture<?> scheduledTask;
    private int maxSpansPerBulk;
    private int maxSpansIteration;

    public void setConfig(GeronimoOpenTracingConfig config) {
        this.config = config;
    }

    public void setJsonb(Jsonb jsonb) {
        this.jsonb = jsonb;
    }

    public void init() {
        if (this.jsonb == null) {
            this.jsonb = JsonbBuilder.create();
        }
        int capacity = Integer.parseInt(this.config.read("span.converter.zipkin.http.bufferSize", "1000000"));
        this.maxSpansPerBulk = Integer.parseInt(this.config.read("span.converter.zipkin.http.maxSpansPerBulk", "250"));
        this.maxSpansIteration = Integer.parseInt(this.config.read("span.converter.zipkin.http.maxSpansIteration", "-1"));
        this.collector = this.config.read("span.converter.zipkin.http.collector", null);
        if (this.collector == null) {
            return;
        }
        long delay = Long.parseLong(this.config.read("span.converter.zipkin.http.bulkSendInterval", "60000"));
        if (delay < 0L) {
            this.logger().severe("No span.converter.zipkin.http.bulkSendInterval configured, skipping");
            this.collector = null;
            return;
        }
        if (delay > 0L) {
            this.executor = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

                @Override
                public Thread newThread(Runnable r) {
                    Thread thread = new Thread(r, this.getClass().getName() + "-executor");
                    thread.setPriority(5);
                    thread.setDaemon(false);
                    return thread;
                }
            });
            this.scheduledTask = this.executor.scheduleAtFixedRate(this::onEmit, delay, delay, TimeUnit.MILLISECONDS);
            this.spans = new ArrayBlockingQueue<ZipkinSpan>(capacity);
        } else {
            this.spans = null;
        }
        ClientBuilder clientBuilder = ClientBuilder.newBuilder().connectTimeout(Long.parseLong(this.config.read("span.converter.zipkin.http.connectTimeout", "30000")), TimeUnit.MILLISECONDS).readTimeout(Long.parseLong(this.config.read("span.converter.zipkin.http.readTimeout", "30000")), TimeUnit.MILLISECONDS);
        Optional.ofNullable(this.config.read("span.converter.zipkin.http.providers", null)).ifPresent(providers -> Stream.of(providers.split(",")).map(String::trim).map(it -> {
            try {
                return Thread.currentThread().getContextClassLoader().loadClass((String)it).getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e);
            }
        }).forEach(arg_0 -> ((ClientBuilder)clientBuilder).register(arg_0)));
        if (Boolean.parseBoolean(this.config.read("span.converter.zipkin.http.selfTrace", "false"))) {
            ClientTracingRegistrar.configure((ClientBuilder)clientBuilder);
        }
        this.client = clientBuilder.build();
        this.logger().severe("Zipkin http sender configured");
    }

    private Logger logger() {
        return Logger.getLogger("org.apache.geronimo.opentracing.zipkin.http");
    }

    public Jsonb getJsonb() {
        return this.jsonb;
    }

    public void destroy() {
        try {
            this.jsonb.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.scheduledTask.cancel(true);
        this.executor.shutdownNow();
        try {
            this.executor.awaitTermination(1L, TimeUnit.MINUTES);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    @Override
    public void onEvent(ZipkinSpan zipkinSpan) {
        if (this.collector != null) {
            if (this.spans == null) {
                this.doSend(Collections.singletonList(zipkinSpan));
            } else {
                this.spans.add(zipkinSpan);
            }
        }
    }

    private void onEmit() {
        int toSend;
        int size = this.spans.size();
        ArrayList<ZipkinSpan> copy = new ArrayList<ZipkinSpan>(size <= 0 ? this.maxSpansPerBulk : Math.min(size, this.maxSpansPerBulk));
        int n = toSend = this.maxSpansIteration <= 0 ? size : Math.min(size, this.maxSpansIteration);
        while (toSend > 0) {
            this.spans.drainTo(copy, Math.min(toSend, this.maxSpansPerBulk));
            if (copy.isEmpty()) break;
            this.doSend(copy);
            toSend -= copy.size();
            copy.clear();
        }
    }

    private void doSend(List<ZipkinSpan> copy) {
        Response result = this.client.target(this.collector).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(Entity.entity(copy, (MediaType)MediaType.APPLICATION_JSON_TYPE));
        if (result.getStatus() >= 300) {
            throw new IllegalStateException("Can't send to zipkin: " + copy);
        }
    }
}

