/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.config.configsource;

import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.enterprise.inject.Typed;
import javax.enterprise.inject.Vetoed;
import org.apache.geronimo.config.cdi.configsource.Reloadable;
import org.apache.geronimo.config.configsource.BaseConfigSource;

@Typed
@Vetoed
public class SystemPropertyConfigSource
extends BaseConfigSource
implements Reloadable {
    private static final String COPY_PROPERTY = "org.apache.geronimo.config.configsource.SystemPropertyConfigSource.copy";
    private final Map<String, String> instance;
    private final boolean shouldReload;

    public SystemPropertyConfigSource() {
        this(Boolean.valueOf(System.getProperty(COPY_PROPERTY, "true")));
    }

    public SystemPropertyConfigSource(boolean copy) {
        this.instance = this.load(copy);
        this.shouldReload = copy;
        this.initOrdinal(400);
    }

    public Map<String, String> getProperties() {
        return this.instance;
    }

    public String getValue(String key) {
        return this.instance.get(key);
    }

    public String getName() {
        return "system-properties";
    }

    @Override
    public void reload() {
        if (!this.shouldReload) {
            return;
        }
        this.instance.clear();
        this.instance.putAll(this.load(true));
    }

    private Map<String, String> load(boolean copy) {
        return copy ? System.getProperties().stringPropertyNames().stream().collect(Collectors.toMap(Function.identity(), System::getProperty)) : (Map)Map.class.cast(System.getProperties());
    }
}

