/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.proxy;

import java.lang.reflect.Method;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.talend.sdk.component.lang.UnsafeFunction;
import org.talend.sdk.component.lang.UnsafeSupplier;
import org.talend.sdk.component.proxy.DelegateHandler;

public class ApiHandler
extends DelegateHandler {
    private final Map<Method, Method> methodMapping;
    private final UnsafeFunction<UnsafeSupplier<Object>, Object> context;

    public ApiHandler(Object delegate, Class<?> api, UnsafeFunction<UnsafeSupplier<Object>, Object> executionWrapper) {
        super(delegate);
        this.methodMapping = Stream.of(api.getMethods()).collect(Collectors.toMap(Function.identity(), m -> {
            try {
                return delegate.getClass().getMethod(m.getName(), m.getParameterTypes());
            }
            catch (NoSuchMethodException e) {
                throw new IllegalStateException("Invalid proxy type: " + delegate + ", for api: " + api);
            }
        }));
        this.context = executionWrapper;
    }

    @Override
    protected Object doInvoke(Method method, Object[] args) throws Throwable {
        Method targetMethod = Optional.ofNullable(this.methodMapping.get(method)).orElse(method);
        return this.context.apply(() -> targetMethod.invoke(this.delegate, args));
    }
}

