/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.jmx;

import java.util.Optional;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.sdk.component.container.Container;
import org.talend.sdk.component.container.ContainerListener;
import org.talend.sdk.component.container.ContainerManager;
import org.talend.sdk.component.jmx.ContainerMBean;

public class JmxManager
implements ContainerListener {
    private static final Logger log = LoggerFactory.getLogger(JmxManager.class);
    private final ContainerManager manager;
    private final String namePattern;
    private final MBeanServer server;

    @Override
    public void onCreate(Container container) {
        try {
            ObjectName name = new ObjectName(String.format(this.namePattern, container.getId()));
            this.server.registerMBean(new ContainerMBean(this.manager, container), name);
            container.set(JmxData.class, new JmxData(name));
        }
        catch (InstanceAlreadyExistsException | MBeanRegistrationException | MalformedObjectNameException | NotCompliantMBeanException e) {
            log.warn("{}: {}", (Object)e.getClass().getSimpleName(), (Object)e.getMessage());
        }
    }

    @Override
    public void onClose(Container container) {
        Optional.ofNullable(container.get(JmxData.class)).ifPresent(d -> {
            try {
                this.server.unregisterMBean(((JmxData)d).name);
            }
            catch (InstanceNotFoundException | MBeanRegistrationException e) {
                log.warn(e.getMessage(), (Throwable)e);
            }
        });
    }

    public JmxManager(ContainerManager manager, String namePattern, MBeanServer server) {
        this.manager = manager;
        this.namePattern = namePattern;
        this.server = server;
    }

    private static class JmxData {
        private final ObjectName name;

        public JmxData(ObjectName name) {
            this.name = name;
        }
    }
}

