/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.dependencies.maven;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.talend.sdk.component.dependencies.maven.Artifact;

public class MvnCoordinateToFileConverter {
    private static final Logger log = LoggerFactory.getLogger(MvnCoordinateToFileConverter.class);
    private static final Set<String> SCOPES = new HashSet<String>(Arrays.asList("compile", "provided", "runtime", "test", "system"));

    public Artifact toArtifact(String coordinates) {
        String[] segments;
        String trim = coordinates.trim().replaceAll(" -- module.*", "");
        if (trim.isEmpty()) {
            return null;
        }
        int endOfTreePrefix = Math.max(trim.indexOf("\u2500 "), trim.indexOf("- "));
        if (endOfTreePrefix > 0) {
            trim = trim.substring(endOfTreePrefix + "\u2500 ".length());
        }
        if ((segments = trim.split(":")).length < 3) {
            throw new IllegalArgumentException("Invalid coordinate: " + trim);
        }
        switch (segments.length) {
            case 3: {
                segments = new String[]{segments[0], segments[1], "jar", null, segments[2], "compile"};
                break;
            }
            case 4: {
                segments = new String[]{segments[0], segments[1], segments[2], null, segments[3], "compile"};
                break;
            }
            case 5: {
                if (SCOPES.contains(segments[4])) {
                    segments = new String[]{segments[0], segments[1], segments[2], null, segments[3], segments[4]};
                    break;
                }
                segments = new String[]{segments[0], segments[1], segments[2], segments[3], segments[4], "compile"};
                break;
            }
        }
        return new Artifact(segments[0], segments[1], segments[2], segments[3], segments[4], segments[5]);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MvnCoordinateToFileConverter)) {
            return false;
        }
        MvnCoordinateToFileConverter other = (MvnCoordinateToFileConverter)o;
        return other.canEqual(this);
    }

    protected boolean canEqual(Object other) {
        return other instanceof MvnCoordinateToFileConverter;
    }

    public int hashCode() {
        boolean result = true;
        return 1;
    }

    public String toString() {
        return "MvnCoordinateToFileConverter()";
    }
}

