/*
 * Decompiled with CFR 0.152.
 */
package org.talend.sdk.component.dependencies.maven;

import java.util.Optional;

public class Artifact {
    private final String group;
    private final String artifact;
    private final String type;
    private final String classifier;
    private final String version;
    private final String scope;
    private volatile String pathCache;

    public Artifact(String group, String artifact, String type, String classifier, String version, String scope) {
        this.group = group;
        this.artifact = artifact;
        this.type = type;
        this.classifier = classifier != null && classifier.isEmpty() ? null : classifier;
        this.version = version;
        this.scope = scope;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toPath() {
        if (this.pathCache == null) {
            Artifact artifact = this;
            synchronized (artifact) {
                if (this.pathCache == null) {
                    this.pathCache = String.format("%s/%s/%s/%s-%s%s.%s", this.group.replace(".", "/"), this.artifact, this.version, this.artifact, this.version, Optional.ofNullable(this.classifier).filter(it -> !it.isEmpty()).map(c -> '-' + c).orElse(""), this.type);
                }
            }
        }
        return this.pathCache;
    }

    public String toCoordinate() {
        return this.group + ':' + this.artifact + ':' + this.type + (this.classifier != null && !this.classifier.isEmpty() ? ':' + this.classifier : "") + ':' + this.version;
    }

    public static Artifact from(String id) {
        String[] split = id.split(":");
        return new Artifact(split[0], split.length >= 2 ? split[1] : null, split.length >= 3 ? split[2] : "jar", split.length == 5 ? split[3] : null, split.length == 4 ? split[3] : (split.length == 5 ? split[4] : null), "compile");
    }

    public String getGroup() {
        return this.group;
    }

    public String getArtifact() {
        return this.artifact;
    }

    public String getType() {
        return this.type;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public String getVersion() {
        return this.version;
    }

    public String getScope() {
        return this.scope;
    }

    public String getPathCache() {
        return this.pathCache;
    }

    public void setPathCache(String pathCache) {
        this.pathCache = pathCache;
    }

    public String toString() {
        return "Artifact(group=" + this.getGroup() + ", artifact=" + this.getArtifact() + ", type=" + this.getType() + ", classifier=" + this.getClassifier() + ", version=" + this.getVersion() + ", scope=" + this.getScope() + ", pathCache=" + this.getPathCache() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Artifact)) {
            return false;
        }
        Artifact other = (Artifact)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$group = this.getGroup();
        String other$group = other.getGroup();
        if (this$group == null ? other$group != null : !this$group.equals(other$group)) {
            return false;
        }
        String this$artifact = this.getArtifact();
        String other$artifact = other.getArtifact();
        if (this$artifact == null ? other$artifact != null : !this$artifact.equals(other$artifact)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$classifier = this.getClassifier();
        String other$classifier = other.getClassifier();
        if (this$classifier == null ? other$classifier != null : !this$classifier.equals(other$classifier)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        String this$scope = this.getScope();
        String other$scope = other.getScope();
        return !(this$scope == null ? other$scope != null : !this$scope.equals(other$scope));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Artifact;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $group = this.getGroup();
        result = result * 59 + ($group == null ? 43 : $group.hashCode());
        String $artifact = this.getArtifact();
        result = result * 59 + ($artifact == null ? 43 : $artifact.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $classifier = this.getClassifier();
        result = result * 59 + ($classifier == null ? 43 : $classifier.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        String $scope = this.getScope();
        result = result * 59 + ($scope == null ? 43 : $scope.hashCode());
        return result;
    }
}

