/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.jcache.simple.osgi;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Objects;
import java.util.stream.Stream;
import javax.cache.spi.CachingProvider;
import javax.enterprise.inject.spi.Extension;
import org.apache.geronimo.jcache.simple.SimpleProvider;
import org.apache.geronimo.jcache.simple.cdi.MakeJCacheCDIInterceptorFriendly;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.PrototypeServiceFactory;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceRegistration;

public class JCacheActivator
implements BundleActivator {
    private ServiceRegistration<?> cacheProviderRegistration;
    private ServiceRegistration<?> jcacheExtensionRegistration;

    public void start(BundleContext context) {
        Hashtable<String, String> cachingProvider = new Hashtable<String, String>();
        ((Dictionary)cachingProvider).put("javax.cache.provider", CachingProvider.class.getName());
        this.cacheProviderRegistration = context.registerService(CachingProvider.class, (Object)new SimpleProvider(), cachingProvider);
        Hashtable<String, String> jcacheExtension = new Hashtable<String, String>();
        ((Dictionary)jcacheExtension).put("osgi.cdi.extension", "geronimo-jcache-simple");
        ((Dictionary)jcacheExtension).put("aries.cdi.extension.mode", "implicit");
        this.jcacheExtensionRegistration = context.registerService(Extension.class, (ServiceFactory)new PrototypeServiceFactory<Extension>(){

            public Extension getService(Bundle bundle, ServiceRegistration<Extension> registration) {
                return new MakeJCacheCDIInterceptorFriendly();
            }

            public void ungetService(Bundle bundle, ServiceRegistration<Extension> registration, Extension service) {
            }
        }, jcacheExtension);
    }

    public void stop(BundleContext context) {
        Stream.of(this.cacheProviderRegistration, this.jcacheExtensionRegistration).filter(Objects::nonNull).forEach(it -> {
            try {
                it.unregister();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        });
    }
}

