/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.jcache.simple.cdi;

import java.io.Serializable;
import java.util.concurrent.CompletionStage;
import javax.annotation.Priority;
import javax.cache.Cache;
import javax.cache.annotation.CacheInvocationContext;
import javax.cache.annotation.CacheMethodDetails;
import javax.cache.annotation.CacheResolver;
import javax.cache.annotation.CacheResolverFactory;
import javax.cache.annotation.CacheResult;
import javax.cache.annotation.GeneratedCacheKey;
import javax.inject.Inject;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import org.apache.geronimo.jcache.simple.cdi.CDIJCacheHelper;
import org.apache.geronimo.jcache.simple.cdi.CacheKeyInvocationContextImpl;

@CacheResult
@Interceptor
@Priority(value=1000)
public class CacheResultInterceptor
implements Serializable {
    @Inject
    private CDIJCacheHelper helper;

    @AroundInvoke
    public Object cache(InvocationContext ic) throws Throwable {
        Object result;
        CDIJCacheHelper.MethodMeta methodMeta = this.helper.findMeta(ic);
        String cacheName = methodMeta.getCacheResultCacheName();
        CacheResult cacheResult = methodMeta.getCacheResult();
        CacheKeyInvocationContextImpl<CacheResult> context = new CacheKeyInvocationContextImpl<CacheResult>(ic, cacheResult, cacheName, methodMeta);
        CacheResolverFactory cacheResolverFactory = methodMeta.getCacheResultResolverFactory();
        CacheResolver cacheResolver = cacheResolverFactory.getCacheResolver(context);
        Cache cache = cacheResolver.resolveCache(context);
        GeneratedCacheKey cacheKey = methodMeta.getCacheResultKeyGenerator().generateCacheKey(context);
        Cache exceptionCache = null;
        if (!cacheResult.skipGet()) {
            Object exception;
            result = cache.get((Object)cacheKey);
            if (result != null) {
                return result;
            }
            if (!cacheResult.exceptionCacheName().isEmpty() && (exception = (exceptionCache = cacheResolverFactory.getExceptionCacheResolver(context).resolveCache(context)).get((Object)cacheKey)) != null) {
                if (methodMeta.isCompletionStage()) {
                    return exception;
                }
                throw (Throwable)Throwable.class.cast(exception);
            }
        }
        try {
            result = ic.proceed();
            if (result != null) {
                cache.put((Object)cacheKey, result);
                if (CompletionStage.class.isInstance(result)) {
                    CompletionStage completionStage = (CompletionStage)CompletionStage.class.cast(result);
                    completionStage.exceptionally(t -> {
                        if (this.helper.isIncluded(t.getClass(), cacheResult.cachedExceptions(), cacheResult.nonCachedExceptions())) {
                            cacheResolverFactory.getExceptionCacheResolver((CacheMethodDetails)context).resolveCache((CacheInvocationContext)context).put((Object)cacheKey, (Object)completionStage);
                        } else {
                            cache.remove((Object)cacheKey);
                        }
                        if (RuntimeException.class.isInstance(t)) {
                            throw (RuntimeException)RuntimeException.class.cast(t);
                        }
                        throw new IllegalStateException((Throwable)t);
                    });
                }
            }
            return result;
        }
        catch (Throwable t2) {
            if (this.helper.isIncluded(t2.getClass(), cacheResult.cachedExceptions(), cacheResult.nonCachedExceptions())) {
                if (exceptionCache == null) {
                    exceptionCache = cacheResolverFactory.getExceptionCacheResolver(context).resolveCache(context);
                }
                exceptionCache.put((Object)cacheKey, (Object)t2);
            }
            throw t2;
        }
    }
}

