/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.jcache.simple.cdi;

import java.lang.annotation.Annotation;
import javax.cache.Cache;
import javax.cache.CacheManager;
import javax.cache.Caching;
import javax.cache.annotation.CacheMethodDetails;
import javax.cache.annotation.CacheResolver;
import javax.cache.annotation.CacheResolverFactory;
import javax.cache.annotation.CacheResult;
import javax.cache.configuration.Configuration;
import javax.cache.configuration.MutableConfiguration;
import javax.cache.spi.CachingProvider;
import org.apache.geronimo.jcache.simple.cdi.CacheResolverImpl;

public class CacheResolverFactoryImpl
implements CacheResolverFactory {
    private final CacheManager cacheManager;
    private final CachingProvider provider = Caching.getCachingProvider();

    public CacheResolverFactoryImpl() {
        this.cacheManager = this.provider.getCacheManager(this.provider.getDefaultURI(), this.provider.getDefaultClassLoader());
    }

    public CacheResolver getCacheResolver(CacheMethodDetails<? extends Annotation> cacheMethodDetails) {
        return this.findCacheResolver(cacheMethodDetails.getCacheName());
    }

    public CacheResolver getExceptionCacheResolver(CacheMethodDetails<CacheResult> cacheMethodDetails) {
        String exceptionCacheName = ((CacheResult)cacheMethodDetails.getCacheAnnotation()).exceptionCacheName();
        if (exceptionCacheName == null || exceptionCacheName.isEmpty()) {
            throw new IllegalArgumentException("CacheResult.exceptionCacheName() not specified");
        }
        return this.findCacheResolver(exceptionCacheName);
    }

    private CacheResolver findCacheResolver(String exceptionCacheName) {
        Cache<?, ?> cache = this.cacheManager.getCache(exceptionCacheName);
        if (cache == null) {
            cache = this.createCache(exceptionCacheName);
        }
        return new CacheResolverImpl(cache);
    }

    private Cache<?, ?> createCache(String exceptionCacheName) {
        this.cacheManager.createCache(exceptionCacheName, (Configuration)new MutableConfiguration().setStoreByValue(false));
        return this.cacheManager.getCache(exceptionCacheName);
    }

    public void release() {
        this.cacheManager.close();
        this.provider.close();
    }

    public CacheManager getCacheManager() {
        return this.cacheManager;
    }

    public CachingProvider getProvider() {
        return this.provider;
    }
}

