/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.jcache.simple.cdi;

import java.io.Serializable;
import java.util.concurrent.CompletionStage;
import javax.annotation.Priority;
import javax.cache.Cache;
import javax.cache.annotation.CacheRemoveAll;
import javax.cache.annotation.CacheResolver;
import javax.cache.annotation.CacheResolverFactory;
import javax.inject.Inject;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import org.apache.geronimo.jcache.simple.cdi.CDIJCacheHelper;
import org.apache.geronimo.jcache.simple.cdi.CacheKeyInvocationContextImpl;

@CacheRemoveAll
@Interceptor
@Priority(value=1000)
public class CacheRemoveAllInterceptor
implements Serializable {
    @Inject
    private CDIJCacheHelper helper;

    @AroundInvoke
    public Object cache(InvocationContext ic) throws Throwable {
        Object result;
        CDIJCacheHelper.MethodMeta methodMeta = this.helper.findMeta(ic);
        String cacheName = methodMeta.getCacheRemoveAllCacheName();
        CacheResolverFactory cacheResolverFactory = methodMeta.getCacheRemoveAllResolverFactory();
        CacheKeyInvocationContextImpl<CacheRemoveAll> context = new CacheKeyInvocationContextImpl<CacheRemoveAll>(ic, methodMeta.getCacheRemoveAll(), cacheName, methodMeta);
        CacheResolver cacheResolver = cacheResolverFactory.getCacheResolver(context);
        Cache cache = cacheResolver.resolveCache(context);
        boolean afterInvocation = methodMeta.isCachePutAfter();
        if (!afterInvocation) {
            cache.removeAll();
        }
        try {
            result = ic.proceed();
            if (CompletionStage.class.isInstance(result)) {
                CompletionStage completionStage = (CompletionStage)CompletionStage.class.cast(result);
                completionStage.exceptionally(t -> {
                    if (afterInvocation && this.helper.isIncluded(t.getClass(), methodMeta.getCacheRemoveAll().evictFor(), methodMeta.getCacheRemoveAll().noEvictFor())) {
                        cache.removeAll();
                    }
                    if (RuntimeException.class.isInstance(t)) {
                        throw (RuntimeException)RuntimeException.class.cast(t);
                    }
                    throw new IllegalStateException((Throwable)t);
                });
            }
        }
        catch (Throwable t2) {
            if (afterInvocation && this.helper.isIncluded(t2.getClass(), methodMeta.getCacheRemoveAll().evictFor(), methodMeta.getCacheRemoveAll().noEvictFor())) {
                cache.removeAll();
            }
            throw t2;
        }
        if (afterInvocation) {
            cache.removeAll();
        }
        return result;
    }
}

