/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.jcache.simple;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.cache.Cache;
import javax.cache.CacheException;
import javax.cache.CacheManager;
import javax.cache.configuration.Configuration;
import javax.cache.spi.CachingProvider;
import org.apache.geronimo.jcache.simple.Asserts;
import org.apache.geronimo.jcache.simple.ClassLoaderAwareCache;
import org.apache.geronimo.jcache.simple.SimpleCache;
import org.apache.geronimo.jcache.simple.SimpleConfiguration;
import org.apache.geronimo.jcache.simple.SimpleProvider;
import org.apache.geronimo.jcache.simple.SimpleThreadFactory;

public class SimpleManager
implements CacheManager {
    private final CachingProvider provider;
    private final URI uri;
    private final ClassLoader loader;
    private final Properties properties;
    private final ConcurrentMap<String, Cache<?, ?>> caches = new ConcurrentHashMap();
    private final Properties configProperties;
    private final ExecutorService executorService;
    private volatile boolean closed = false;

    SimpleManager(CachingProvider provider, URI uri, ClassLoader loader, Properties properties) {
        this.provider = provider;
        this.uri = uri;
        this.loader = loader;
        this.properties = this.readConfig(uri, loader, properties);
        this.configProperties = properties;
        ExecutorService executorService = (ExecutorService)this.rawProperty("geronimo.pool");
        if (executorService == null) {
            int poolSize = Integer.parseInt(this.properties.getProperty("pool.size", "16"));
            SimpleThreadFactory threadFactory = new SimpleThreadFactory("geronimo-simple-jcache-[" + uri.toASCIIString() + "]-");
            executorService = poolSize > 0 ? Executors.newFixedThreadPool(poolSize, threadFactory) : Executors.newCachedThreadPool(threadFactory);
        }
        this.executorService = executorService;
    }

    private <T> T rawProperty(String name) {
        Object value = this.properties.get(name);
        if (value == null) {
            return (T)this.properties.get(name);
        }
        return (T)value;
    }

    private Properties readConfig(URI uri, ClassLoader loader, Properties properties) {
        Properties props = new Properties();
        try {
            if (SimpleProvider.DEFAULT_URI.toString().equals(uri.toString()) || uri.getScheme().equals("geronimo") || uri.getScheme().equals("classpath")) {
                Enumeration<URL> resources = loader.getResources(uri.toASCIIString().substring((uri.getScheme() + "://").length()));
                while (resources.hasMoreElements()) {
                    do {
                        this.addProperties(resources.nextElement(), props);
                    } while (resources.hasMoreElements());
                }
            } else {
                props.load(uri.toURL().openStream());
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        if (properties != null) {
            props.putAll((Map<?, ?>)properties);
        }
        return props;
    }

    private void addProperties(URL url, Properties aggregator) {
        try (InputStream inputStream = url.openStream();){
            aggregator.load(inputStream);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private void assertNotClosed() {
        if (this.isClosed()) {
            throw new IllegalStateException("cache manager closed");
        }
    }

    public <K, V, C extends Configuration<K, V>> Cache<K, V> createCache(String cacheName, C configuration) throws IllegalArgumentException {
        this.assertNotClosed();
        Asserts.assertNotNull(cacheName, "cacheName");
        Asserts.assertNotNull(configuration, "configuration");
        Class keyType = configuration.getKeyType();
        Class valueType = configuration.getValueType();
        if (this.caches.containsKey(cacheName)) {
            throw new CacheException("cache " + cacheName + " already exists");
        }
        Cache cache = ClassLoaderAwareCache.wrap(this.loader, new SimpleCache(this.loader, this, cacheName, new SimpleConfiguration(configuration, keyType, valueType), this.properties, this.executorService));
        this.caches.putIfAbsent(cacheName, cache);
        return this.getCache(cacheName, keyType, valueType);
    }

    public void destroyCache(String cacheName) {
        this.assertNotClosed();
        Asserts.assertNotNull(cacheName, "cacheName");
        Cache cache = (Cache)this.caches.remove(cacheName);
        if (cache != null && !cache.isClosed()) {
            cache.clear();
            cache.close();
        }
    }

    public void enableManagement(String cacheName, boolean enabled) {
        this.assertNotClosed();
        Asserts.assertNotNull(cacheName, "cacheName");
        SimpleCache<?, ?> cache = this.of(cacheName);
        if (cache != null) {
            if (enabled) {
                cache.enableManagement();
            } else {
                cache.disableManagement();
            }
        }
    }

    private SimpleCache<?, ?> of(String cacheName) {
        return (SimpleCache)SimpleCache.class.cast(ClassLoaderAwareCache.getDelegate((Cache)this.caches.get(cacheName)));
    }

    public void enableStatistics(String cacheName, boolean enabled) {
        this.assertNotClosed();
        Asserts.assertNotNull(cacheName, "cacheName");
        SimpleCache<?, ?> cache = this.of(cacheName);
        if (cache != null) {
            if (enabled) {
                cache.enableStatistics();
            } else {
                cache.disableStatistics();
            }
        }
    }

    public synchronized void close() {
        if (this.isClosed()) {
            return;
        }
        this.assertNotClosed();
        for (Cache c : this.caches.values()) {
            c.close();
        }
        this.caches.clear();
        for (Runnable task : this.executorService.shutdownNow()) {
            task.run();
        }
        this.closed = true;
        if (SimpleProvider.class.isInstance(this.provider)) {
            ((SimpleProvider)SimpleProvider.class.cast(this.provider)).remove(this);
        }
    }

    public <T> T unwrap(Class<T> clazz) {
        if (clazz.isInstance(this)) {
            return clazz.cast(this);
        }
        throw new IllegalArgumentException(clazz.getName() + " not supported in unwrap");
    }

    public boolean isClosed() {
        return this.closed;
    }

    public <K, V> Cache<K, V> getCache(String cacheName) {
        this.assertNotClosed();
        Asserts.assertNotNull(cacheName, "cacheName");
        return this.doGetCache(cacheName, null, null);
    }

    public Iterable<String> getCacheNames() {
        this.assertNotClosed();
        return Collections.unmodifiableSet(new HashSet(this.caches.keySet()));
    }

    public <K, V> Cache<K, V> getCache(String cacheName, Class<K> keyType, Class<V> valueType) {
        this.assertNotClosed();
        Asserts.assertNotNull(cacheName, "cacheName");
        Asserts.assertNotNull(keyType, "keyType");
        Asserts.assertNotNull(valueType, "valueType");
        try {
            return this.doGetCache(cacheName, keyType, valueType);
        }
        catch (IllegalArgumentException iae) {
            throw new ClassCastException(iae.getMessage());
        }
    }

    private <K, V> Cache<K, V> doGetCache(String cacheName, Class<K> keyType, Class<V> valueType) {
        Cache cache = (Cache)this.caches.get(cacheName);
        if (keyType == null && valueType == null) {
            return cache;
        }
        if (cache == null) {
            return null;
        }
        Configuration config = cache.getConfiguration(Configuration.class);
        if (keyType != null && !config.getKeyType().isAssignableFrom(keyType) || valueType != null && !config.getValueType().isAssignableFrom(valueType)) {
            throw new IllegalArgumentException("this cache is <" + config.getKeyType().getName() + ", " + config.getValueType().getName() + ">  and not <" + keyType.getName() + ", " + valueType.getName() + ">");
        }
        return cache;
    }

    public CachingProvider getCachingProvider() {
        return this.provider;
    }

    public URI getURI() {
        return this.uri;
    }

    public ClassLoader getClassLoader() {
        return this.loader;
    }

    public Properties getProperties() {
        return this.configProperties;
    }

    public void release(String name) {
        this.caches.remove(name);
    }
}

