/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.jcache.simple;

import java.util.ArrayList;
import java.util.List;
import javax.cache.configuration.CacheEntryListenerConfiguration;
import javax.cache.configuration.Factory;
import javax.cache.event.CacheEntryCreatedListener;
import javax.cache.event.CacheEntryEvent;
import javax.cache.event.CacheEntryEventFilter;
import javax.cache.event.CacheEntryExpiredListener;
import javax.cache.event.CacheEntryListener;
import javax.cache.event.CacheEntryListenerException;
import javax.cache.event.CacheEntryRemovedListener;
import javax.cache.event.CacheEntryUpdatedListener;

public class SimpleListener<K, V>
implements AutoCloseable {
    private final CacheEntryEventFilter<? super K, ? super V> filter;
    private final CacheEntryListener<? super K, ? super V> delegate;
    private final boolean remove;
    private final boolean expire;
    private final boolean update;
    private final boolean create;

    public SimpleListener(CacheEntryListenerConfiguration<K, V> cacheEntryListenerConfiguration) {
        CacheEntryEventFilter filter;
        Factory filterFactory = cacheEntryListenerConfiguration.getCacheEntryEventFilterFactory();
        this.filter = filterFactory == null ? NoFilter.INSTANCE : ((filter = (CacheEntryEventFilter)filterFactory.create()) == null ? NoFilter.INSTANCE : filter);
        this.delegate = (CacheEntryListener)cacheEntryListenerConfiguration.getCacheEntryListenerFactory().create();
        this.remove = CacheEntryRemovedListener.class.isInstance(this.delegate);
        this.expire = CacheEntryExpiredListener.class.isInstance(this.delegate);
        this.update = CacheEntryUpdatedListener.class.isInstance(this.delegate);
        this.create = CacheEntryCreatedListener.class.isInstance(this.delegate);
    }

    public void onRemoved(List<CacheEntryEvent<? extends K, ? extends V>> events) throws CacheEntryListenerException {
        if (this.remove) {
            ((CacheEntryRemovedListener)CacheEntryRemovedListener.class.cast(this.delegate)).onRemoved(this.filter(events));
        }
    }

    public void onExpired(List<CacheEntryEvent<? extends K, ? extends V>> events) throws CacheEntryListenerException {
        if (this.expire) {
            ((CacheEntryExpiredListener)CacheEntryExpiredListener.class.cast(this.delegate)).onExpired(this.filter(events));
        }
    }

    public void onUpdated(List<CacheEntryEvent<? extends K, ? extends V>> events) throws CacheEntryListenerException {
        if (this.update) {
            ((CacheEntryUpdatedListener)CacheEntryUpdatedListener.class.cast(this.delegate)).onUpdated(this.filter(events));
        }
    }

    public void onCreated(List<CacheEntryEvent<? extends K, ? extends V>> events) throws CacheEntryListenerException {
        if (this.create) {
            ((CacheEntryCreatedListener)CacheEntryCreatedListener.class.cast(this.delegate)).onCreated(this.filter(events));
        }
    }

    private Iterable<CacheEntryEvent<? extends K, ? extends V>> filter(List<CacheEntryEvent<? extends K, ? extends V>> events) {
        if (this.filter == NoFilter.INSTANCE) {
            return events;
        }
        ArrayList<CacheEntryEvent<K, V>> filtered = new ArrayList<CacheEntryEvent<K, V>>(events.size());
        for (CacheEntryEvent<? extends K, ? extends V> cacheEntryEvent : events) {
            if (!this.filter.evaluate(cacheEntryEvent)) continue;
            filtered.add(cacheEntryEvent);
        }
        return filtered;
    }

    @Override
    public void close() throws Exception {
        if (AutoCloseable.class.isInstance(this.delegate)) {
            ((AutoCloseable)AutoCloseable.class.cast(this.delegate)).close();
        }
    }

    public static class NoFilter
    implements CacheEntryEventFilter<Object, Object> {
        public static final CacheEntryEventFilter<Object, Object> INSTANCE = new NoFilter();

        private NoFilter() {
        }

        public boolean evaluate(CacheEntryEvent<?, ?> event) throws CacheEntryListenerException {
            return true;
        }
    }
}

