/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.jcache.simple;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;
import javax.cache.Cache;
import javax.cache.CacheException;
import javax.cache.CacheManager;
import javax.cache.configuration.CacheEntryListenerConfiguration;
import javax.cache.configuration.Configuration;
import javax.cache.configuration.Factory;
import javax.cache.event.EventType;
import javax.cache.expiry.Duration;
import javax.cache.expiry.EternalExpiryPolicy;
import javax.cache.expiry.ExpiryPolicy;
import javax.cache.integration.CacheLoader;
import javax.cache.integration.CacheLoaderException;
import javax.cache.integration.CacheWriter;
import javax.cache.integration.CacheWriterException;
import javax.cache.integration.CompletionListener;
import javax.cache.processor.EntryProcessor;
import javax.cache.processor.EntryProcessorException;
import javax.cache.processor.EntryProcessorResult;
import javax.management.ObjectName;
import org.apache.geronimo.jcache.simple.Asserts;
import org.apache.geronimo.jcache.simple.ExceptionWrapperHandler;
import org.apache.geronimo.jcache.simple.JMXs;
import org.apache.geronimo.jcache.simple.NoLoader;
import org.apache.geronimo.jcache.simple.NoWriter;
import org.apache.geronimo.jcache.simple.Serializations;
import org.apache.geronimo.jcache.simple.SimpleCacheMXBean;
import org.apache.geronimo.jcache.simple.SimpleCacheStatisticsMXBean;
import org.apache.geronimo.jcache.simple.SimpleConfiguration;
import org.apache.geronimo.jcache.simple.SimpleElement;
import org.apache.geronimo.jcache.simple.SimpleEntry;
import org.apache.geronimo.jcache.simple.SimpleEvent;
import org.apache.geronimo.jcache.simple.SimpleKey;
import org.apache.geronimo.jcache.simple.SimpleListener;
import org.apache.geronimo.jcache.simple.SimpleManager;
import org.apache.geronimo.jcache.simple.SimpleMutableEntry;
import org.apache.geronimo.jcache.simple.Statistics;
import org.apache.geronimo.jcache.simple.TempStateCacheView;
import org.apache.geronimo.jcache.simple.Times;

public class SimpleCache<K, V>
implements Cache<K, V> {
    private final SimpleManager manager;
    private final SimpleConfiguration<K, V> config;
    private final CacheLoader<K, V> loader;
    private final CacheWriter<? super K, ? super V> writer;
    private final ExpiryPolicy expiryPolicy;
    private final ObjectName cacheConfigObjectName;
    private final ObjectName cacheStatsObjectName;
    private final String name;
    private final ConcurrentHashMap<SimpleKey<K>, SimpleElement<V>> delegate;
    private final Map<CacheEntryListenerConfiguration<K, V>, SimpleListener<K, V>> listeners = new ConcurrentHashMap<CacheEntryListenerConfiguration<K, V>, SimpleListener<K, V>>();
    private final Statistics statistics = new Statistics();
    private final ExecutorService pool;
    private final Serializations serializations;
    private final Collection<Future<?>> poolTasks = new CopyOnWriteArraySet();
    private volatile boolean closed = false;

    public SimpleCache(ClassLoader classLoader, SimpleManager mgr, String cacheName, SimpleConfiguration<K, V> configuration, Properties properties, ExecutorService executorService) {
        this.manager = mgr;
        this.name = cacheName;
        int capacity = Integer.parseInt(SimpleCache.property(properties, cacheName, "capacity", "1000"));
        float loadFactor = Float.parseFloat(SimpleCache.property(properties, cacheName, "loadFactor", "0.75"));
        int concurrencyLevel = Integer.parseInt(SimpleCache.property(properties, cacheName, "concurrencyLevel", "16"));
        this.delegate = new ConcurrentHashMap(capacity, loadFactor, concurrencyLevel);
        this.config = configuration;
        this.pool = executorService;
        long evictionPause = Long.parseLong(properties.getProperty(cacheName + ".evictionPause", properties.getProperty("evictionPause", "30000")));
        if (evictionPause > 0L) {
            long maxDeleteByEvictionRun = Long.parseLong(SimpleCache.property(properties, cacheName, "maxDeleteByEvictionRun", "100"));
            this.addPoolTask(new EvictionThread(evictionPause, maxDeleteByEvictionRun));
        }
        this.serializations = new Serializations(SimpleCache.property(properties, cacheName, "serialization.whitelist", null));
        Factory<CacheLoader<K, V>> cacheLoaderFactory = configuration.getCacheLoaderFactory();
        this.loader = cacheLoaderFactory == null ? NoLoader.INSTANCE : ExceptionWrapperHandler.newProxy(classLoader, cacheLoaderFactory.create(), CacheLoaderException.class, CacheLoader.class);
        Factory<CacheWriter<K, V>> cacheWriterFactory = configuration.getCacheWriterFactory();
        this.writer = cacheWriterFactory == null ? NoWriter.INSTANCE : ExceptionWrapperHandler.newProxy(classLoader, cacheWriterFactory.create(), CacheWriterException.class, CacheWriter.class);
        Factory<ExpiryPolicy> expiryPolicyFactory = configuration.getExpiryPolicyFactory();
        this.expiryPolicy = expiryPolicyFactory == null ? new EternalExpiryPolicy() : (ExpiryPolicy)expiryPolicyFactory.create();
        for (CacheEntryListenerConfiguration<K, V> listener : this.config.getCacheEntryListenerConfigurations()) {
            this.listeners.put(listener, new SimpleListener<K, V>(listener));
        }
        this.statistics.setActive(this.config.isStatisticsEnabled());
        String mgrStr = this.manager.getURI().toString().replaceAll(",|:|=|\n", ".");
        String cacheStr = this.name.replaceAll(",|:|=|\n", ".");
        try {
            this.cacheConfigObjectName = new ObjectName("javax.cache:type=CacheConfiguration,CacheManager=" + mgrStr + ",Cache=" + cacheStr);
            this.cacheStatsObjectName = new ObjectName("javax.cache:type=CacheStatistics,CacheManager=" + mgrStr + ",Cache=" + cacheStr);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
        if (this.config.isManagementEnabled()) {
            JMXs.register(this.cacheConfigObjectName, new SimpleCacheMXBean(this));
        }
        if (this.config.isStatisticsEnabled()) {
            JMXs.register(this.cacheStatsObjectName, new SimpleCacheStatisticsMXBean(this.statistics));
        }
    }

    private void assertNotClosed() {
        if (this.isClosed()) {
            throw new IllegalStateException("cache closed");
        }
    }

    public V get(K key) {
        this.assertNotClosed();
        Asserts.assertNotNull(key, "key");
        long getStart = Times.now(false);
        return this.doGetControllingExpiry(getStart, key, true, false, false, true, this.loader);
    }

    private V doLoad(K key, boolean update, boolean propagateLoadException, CacheLoader<K, V> loader) {
        Object v;
        block4: {
            v = null;
            try {
                v = loader.load(key);
            }
            catch (CacheLoaderException e) {
                if (!propagateLoadException) break block4;
                throw e;
            }
        }
        if (v != null) {
            Duration duration;
            Duration duration2 = duration = update ? this.expiryPolicy.getExpiryForUpdate() : this.expiryPolicy.getExpiryForCreation();
            if (SimpleCache.isNotZero(duration)) {
                this.delegate.put(new SimpleKey<K>(key), new SimpleElement<Object>(v, duration));
            }
        }
        return (V)v;
    }

    private void touch(SimpleKey<K> key, SimpleElement<V> element) {
        if (this.config.isStoreByValue()) {
            this.delegate.put(new SimpleKey<K>(this.serializations.copy(this.manager.getClassLoader(), key.getKey())), element);
        }
    }

    public Map<K, V> getAll(Set<? extends K> keys) {
        this.assertNotClosed();
        for (K k : keys) {
            Asserts.assertNotNull(k, "key");
        }
        HashMap<K, Object> result = new HashMap<K, Object>();
        for (K key : keys) {
            Object val;
            Asserts.assertNotNull(key, "key");
            SimpleKey<K> simpleKey = new SimpleKey<K>(key);
            SimpleElement<V> elt = this.delegate.get(simpleKey);
            Object v = val = elt != null ? (Object)elt.getElement() : null;
            if (val == null && this.config.isReadThrough()) {
                val = this.doLoad(key, false, false, this.loader);
                if (val == null) continue;
                result.put(key, val);
                continue;
            }
            if (elt == null) continue;
            Duration expiryForAccess = this.expiryPolicy.getExpiryForAccess();
            if (SimpleCache.isNotZero(expiryForAccess)) {
                this.touch(simpleKey, elt);
                result.put(key, val);
                continue;
            }
            this.expires(simpleKey);
        }
        return result;
    }

    public boolean containsKey(K key) {
        this.assertNotClosed();
        Asserts.assertNotNull(key, "key");
        return this.delegate.get(new SimpleKey<K>(key)) != null;
    }

    public void put(K key, V rawValue) {
        Duration duration;
        this.assertNotClosed();
        Asserts.assertNotNull(key, "key");
        Asserts.assertNotNull(rawValue, "value");
        boolean storeByValue = this.config.isStoreByValue();
        SimpleKey<K> simpleKey = new SimpleKey<K>(storeByValue ? this.serializations.copy(this.manager.getClassLoader(), key) : key);
        SimpleElement<V> oldElt = this.delegate.get(simpleKey);
        Object old = oldElt != null ? (Object)oldElt.getElement() : null;
        V value = storeByValue ? this.serializations.copy(this.manager.getClassLoader(), rawValue) : rawValue;
        boolean created = old == null;
        Duration duration2 = duration = created ? this.expiryPolicy.getExpiryForCreation() : this.expiryPolicy.getExpiryForUpdate();
        if (SimpleCache.isNotZero(duration)) {
            boolean statisticsEnabled = this.config.isStatisticsEnabled();
            long start = Times.now(false);
            this.writer.write(new SimpleEntry<K, V>(key, value));
            this.delegate.put(simpleKey, new SimpleElement<V>(value, duration));
            if (!this.listeners.isEmpty()) {
                for (SimpleListener<Object, Object> simpleListener : this.listeners.values()) {
                    if (created) {
                        simpleListener.onCreated(Collections.singletonList(new SimpleEvent<K, Object>(this, EventType.CREATED, null, key, value)));
                        continue;
                    }
                    simpleListener.onUpdated(Collections.singletonList(new SimpleEvent<K, Object>(this, EventType.UPDATED, old, key, value)));
                }
            }
            if (statisticsEnabled) {
                this.statistics.increasePuts(1L);
                this.statistics.addPutTime(Times.now(false) - start);
            }
        } else if (!created) {
            this.expires(simpleKey);
        }
    }

    private void expires(SimpleKey<K> cacheKey) {
        SimpleElement<V> elt = this.delegate.get(cacheKey);
        this.delegate.remove(cacheKey);
        this.onExpired(cacheKey, elt);
    }

    private void onExpired(SimpleKey<K> cacheKey, SimpleElement<V> elt) {
        for (SimpleListener simpleListener : this.listeners.values()) {
            simpleListener.onExpired(Collections.singletonList(new SimpleEvent<K, Object>(this, EventType.REMOVED, null, cacheKey.getKey(), elt.getElement())));
        }
    }

    public V getAndPut(K key, V value) {
        this.assertNotClosed();
        Asserts.assertNotNull(key, "key");
        Asserts.assertNotNull(value, "value");
        long getStart = Times.now(false);
        V v = this.doGetControllingExpiry(getStart, key, false, false, true, false, this.loader);
        this.put(key, value);
        return v;
    }

    public void putAll(Map<? extends K, ? extends V> map) {
        this.assertNotClosed();
        TempStateCacheView<K, V> view = new TempStateCacheView<K, V>(this);
        for (Map.Entry<K, V> e : map.entrySet()) {
            view.put(e.getKey(), e.getValue());
        }
        view.merge();
    }

    public boolean putIfAbsent(K key, V value) {
        boolean statisticsEnabled = this.config.isStatisticsEnabled();
        if (!this.containsKey(key)) {
            if (statisticsEnabled) {
                this.statistics.increaseMisses(1L);
            }
            this.put(key, value);
            return true;
        }
        if (statisticsEnabled) {
            this.statistics.increaseHits(1L);
        }
        return false;
    }

    public boolean remove(K key) {
        this.assertNotClosed();
        Asserts.assertNotNull(key, "key");
        boolean statisticsEnabled = this.config.isStatisticsEnabled();
        long start = Times.now(!statisticsEnabled);
        this.writer.delete(key);
        SimpleKey<K> cacheKey = new SimpleKey<K>(key);
        SimpleElement<V> v = this.delegate.remove(cacheKey);
        if (v == null || v.isExpired()) {
            return false;
        }
        V value = v.getElement();
        for (SimpleListener simpleListener : this.listeners.values()) {
            simpleListener.onRemoved(Collections.singletonList(new SimpleEvent<K, V>(this, EventType.REMOVED, value, key, value)));
        }
        if (statisticsEnabled) {
            this.statistics.increaseRemovals(1L);
            this.statistics.addRemoveTime(Times.now(false) - start);
        }
        return true;
    }

    public boolean remove(K key, V oldValue) {
        this.assertNotClosed();
        Asserts.assertNotNull(key, "key");
        Asserts.assertNotNull(oldValue, "oldValue");
        long getStart = Times.now(false);
        V v = this.doGetControllingExpiry(getStart, key, false, false, false, false, this.loader);
        if (oldValue.equals(v)) {
            this.remove(key);
            return true;
        }
        if (v != null) {
            this.expiryPolicy.getExpiryForAccess();
        }
        return false;
    }

    public V getAndRemove(K key) {
        this.assertNotClosed();
        Asserts.assertNotNull(key, "key");
        long getStart = Times.now(false);
        V v = this.doGetControllingExpiry(getStart, key, false, false, true, false, this.loader);
        this.remove(key);
        return v;
    }

    private V doGetControllingExpiry(long getStart, K key, boolean updateAcess, boolean forceDoLoad, boolean skipLoad, boolean propagateLoadException, CacheLoader<K, V> loader) {
        Duration expiryForAccess;
        V v;
        boolean statisticsEnabled = this.config.isStatisticsEnabled();
        SimpleKey<K> simpleKey = new SimpleKey<K>(key);
        SimpleElement<V> elt = this.delegate.get(simpleKey);
        V v2 = v = elt != null ? (V)elt.getElement() : null;
        if (v == null && (this.config.isReadThrough() || forceDoLoad)) {
            if (!skipLoad) {
                v = this.doLoad(key, false, propagateLoadException, loader);
            }
        } else if (statisticsEnabled) {
            if (v != null) {
                this.statistics.increaseHits(1L);
            } else {
                this.statistics.increaseMisses(1L);
            }
        }
        if (updateAcess && elt != null && !SimpleCache.isNotZero(expiryForAccess = this.expiryPolicy.getExpiryForAccess())) {
            this.expires(simpleKey);
        }
        if (statisticsEnabled && v != null) {
            this.statistics.addGetTime(Times.now(false) - getStart);
        }
        return v;
    }

    public boolean replace(K key, V oldValue, V newValue) {
        this.assertNotClosed();
        Asserts.assertNotNull(key, "key");
        Asserts.assertNotNull(oldValue, "oldValue");
        Asserts.assertNotNull(newValue, "newValue");
        V value = this.doGetControllingExpiry(Times.now(this.config.isStatisticsEnabled()), key, false, this.config.isReadThrough(), false, true, this.loader);
        if (value != null && value.equals(oldValue)) {
            this.put(key, newValue);
            return true;
        }
        if (value != null) {
            this.expiryPolicy.getExpiryForAccess();
        }
        return false;
    }

    public boolean replace(K key, V value) {
        this.assertNotClosed();
        Asserts.assertNotNull(key, "key");
        Asserts.assertNotNull(value, "value");
        boolean statisticsEnabled = this.config.isStatisticsEnabled();
        if (this.containsKey(key)) {
            if (statisticsEnabled) {
                this.statistics.increaseHits(1L);
            }
            this.put(key, value);
            return true;
        }
        if (statisticsEnabled) {
            this.statistics.increaseMisses(1L);
        }
        return false;
    }

    public V getAndReplace(K key, V value) {
        this.assertNotClosed();
        Asserts.assertNotNull(key, "key");
        Asserts.assertNotNull(value, "value");
        boolean statisticsEnabled = this.config.isStatisticsEnabled();
        SimpleElement<V> elt = this.delegate.get(new SimpleKey<K>(key));
        if (elt != null) {
            V oldValue = elt.getElement();
            if (oldValue == null && this.config.isReadThrough()) {
                oldValue = this.doLoad(key, false, false, this.loader);
            } else if (statisticsEnabled) {
                this.statistics.increaseHits(1L);
            }
            this.put(key, value);
            return oldValue;
        }
        if (statisticsEnabled) {
            this.statistics.increaseMisses(1L);
        }
        return null;
    }

    public void removeAll(Set<? extends K> keys) {
        this.assertNotClosed();
        Asserts.assertNotNull(keys, "keys");
        for (K k : keys) {
            this.remove(k);
        }
    }

    public void removeAll() {
        this.assertNotClosed();
        for (SimpleKey k : this.delegate.keySet()) {
            this.remove(k.getKey());
        }
    }

    public void clear() {
        this.assertNotClosed();
        this.delegate.clear();
    }

    public <C2 extends Configuration<K, V>> C2 getConfiguration(Class<C2> clazz) {
        this.assertNotClosed();
        return (C2)((Configuration)clazz.cast(this.config));
    }

    public void loadAll(final Set<? extends K> keys, final boolean replaceExistingValues, final CompletionListener completionListener) {
        this.assertNotClosed();
        Asserts.assertNotNull(keys, "keys");
        if (this.loader == null) {
            if (completionListener != null) {
                completionListener.onCompletion();
            }
            return;
        }
        for (K k : keys) {
            Asserts.assertNotNull(k, "a key");
        }
        this.addPoolTask(new Runnable(){

            @Override
            public void run() {
                SimpleCache.this.doLoadAll(keys, replaceExistingValues, completionListener);
            }
        });
    }

    private void addPoolTask(final Runnable runnable) {
        final AtomicReference ref = new AtomicReference();
        final CountDownLatch refIsSet = new CountDownLatch(1);
        ref.set(this.pool.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    runnable.run();
                }
                finally {
                    try {
                        refIsSet.await();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                    SimpleCache.this.poolTasks.remove(ref.get());
                }
            }
        }));
        refIsSet.countDown();
        this.poolTasks.add((Future<?>)ref.get());
    }

    private void doLoadAll(Set<? extends K> keys, boolean replaceExistingValues, CompletionListener completionListener) {
        block6: {
            try {
                long now = Times.now(false);
                Map kvMap = this.loader.loadAll(keys);
                if (kvMap == null) {
                    return;
                }
                MapLoader preloaded = new MapLoader(kvMap);
                for (K k : keys) {
                    if (replaceExistingValues) {
                        this.doLoad(k, this.containsKey(k), completionListener != null, preloaded);
                        continue;
                    }
                    if (this.containsKey(k)) continue;
                    this.doGetControllingExpiry(now, k, true, true, false, completionListener != null, preloaded);
                }
            }
            catch (RuntimeException e) {
                if (completionListener == null) break block6;
                completionListener.onException((Exception)e);
                return;
            }
        }
        if (completionListener != null) {
            completionListener.onCompletion();
        }
    }

    public <T> T invoke(K key, EntryProcessor<K, V, T> entryProcessor, Object ... arguments) throws EntryProcessorException {
        TempStateCacheView view = new TempStateCacheView(this);
        T t = this.doInvoke(view, key, entryProcessor, arguments);
        view.merge();
        return t;
    }

    private <T> T doInvoke(TempStateCacheView<K, V> view, K key, EntryProcessor<K, V, T> entryProcessor, Object ... arguments) {
        this.assertNotClosed();
        Asserts.assertNotNull(entryProcessor, "entryProcessor");
        Asserts.assertNotNull(key, "key");
        try {
            if (this.config.isStatisticsEnabled()) {
                if (this.containsKey(key)) {
                    this.statistics.increaseHits(1L);
                } else {
                    this.statistics.increaseMisses(1L);
                }
            }
            return (T)entryProcessor.process(new SimpleMutableEntry<K, V>(view, key), arguments);
        }
        catch (Exception ex) {
            return SimpleCache.throwEntryProcessorException(ex);
        }
    }

    public <T> Map<K, EntryProcessorResult<T>> invokeAll(Set<? extends K> keys, EntryProcessor<K, V, T> entryProcessor, Object ... arguments) {
        this.assertNotClosed();
        Asserts.assertNotNull(entryProcessor, "entryProcessor");
        HashMap<K, Object> results = new HashMap<K, Object>();
        for (K k : keys) {
            try {
                final T invoke = this.invoke(k, entryProcessor, arguments);
                if (invoke == null) continue;
                results.put(k, new EntryProcessorResult<T>(){

                    public T get() throws EntryProcessorException {
                        return invoke;
                    }
                });
            }
            catch (Exception e) {
                results.put(k, new EntryProcessorResult<T>(){

                    public T get() throws EntryProcessorException {
                        return SimpleCache.throwEntryProcessorException(e);
                    }
                });
            }
        }
        return results;
    }

    public void registerCacheEntryListener(CacheEntryListenerConfiguration<K, V> cacheEntryListenerConfiguration) {
        this.assertNotClosed();
        if (this.listeners.containsKey(cacheEntryListenerConfiguration)) {
            throw new IllegalArgumentException(cacheEntryListenerConfiguration + " already registered");
        }
        this.listeners.put(cacheEntryListenerConfiguration, new SimpleListener<K, V>(cacheEntryListenerConfiguration));
        this.config.addListener(cacheEntryListenerConfiguration);
    }

    public void deregisterCacheEntryListener(CacheEntryListenerConfiguration<K, V> cacheEntryListenerConfiguration) {
        this.assertNotClosed();
        this.listeners.remove(cacheEntryListenerConfiguration);
        this.config.removeListener(cacheEntryListenerConfiguration);
    }

    public Iterator<Cache.Entry<K, V>> iterator() {
        this.assertNotClosed();
        final Iterator keys = new HashSet(this.delegate.keySet()).iterator();
        return new Iterator<Cache.Entry<K, V>>(){
            private K lastKey = null;

            @Override
            public boolean hasNext() {
                return keys.hasNext();
            }

            @Override
            public Cache.Entry<K, V> next() {
                this.lastKey = ((SimpleKey)keys.next()).getKey();
                return new SimpleEntry(this.lastKey, SimpleCache.this.get(this.lastKey));
            }

            @Override
            public void remove() {
                if (SimpleCache.this.isClosed() || this.lastKey == null) {
                    throw new IllegalStateException(SimpleCache.this.isClosed() ? "cache closed" : "call next() before remove()");
                }
                SimpleCache.this.remove(this.lastKey);
            }
        };
    }

    public String getName() {
        this.assertNotClosed();
        return this.name;
    }

    public CacheManager getCacheManager() {
        this.assertNotClosed();
        return this.manager;
    }

    public synchronized void close() {
        if (this.isClosed()) {
            return;
        }
        for (Future<?> task : this.poolTasks) {
            task.cancel(true);
        }
        CacheException ce = new CacheException();
        this.manager.release(this.getName());
        this.closed = true;
        SimpleCache.close(this.loader, ce);
        SimpleCache.close(this.writer, ce);
        SimpleCache.close(this.expiryPolicy, ce);
        for (SimpleListener<K, V> listener : this.listeners.values()) {
            try {
                listener.close();
            }
            catch (Exception e) {
                ce.addSuppressed((Throwable)e);
            }
        }
        this.listeners.clear();
        JMXs.unregister(this.cacheConfigObjectName);
        JMXs.unregister(this.cacheStatsObjectName);
        this.delegate.clear();
        if (ce.getSuppressed().length > 0) {
            throw ce;
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    public <T> T unwrap(Class<T> clazz) {
        this.assertNotClosed();
        if (clazz.isInstance(this)) {
            return clazz.cast(this);
        }
        if (clazz.isAssignableFrom(Map.class) || clazz.isAssignableFrom(ConcurrentMap.class)) {
            return clazz.cast(this.delegate);
        }
        throw new IllegalArgumentException(clazz.getName() + " not supported in unwrap");
    }

    public Statistics getStatistics() {
        return this.statistics;
    }

    public void enableManagement() {
        this.config.managementEnabled();
        JMXs.register(this.cacheConfigObjectName, new SimpleCacheMXBean(this));
    }

    public void disableManagement() {
        this.config.managementDisabled();
        JMXs.unregister(this.cacheConfigObjectName);
    }

    public void enableStatistics() {
        this.config.statisticsEnabled();
        this.statistics.setActive(true);
        JMXs.register(this.cacheStatsObjectName, new SimpleCacheStatisticsMXBean(this.statistics));
    }

    public void disableStatistics() {
        this.config.statisticsDisabled();
        this.statistics.setActive(false);
        JMXs.unregister(this.cacheStatsObjectName);
    }

    private static String property(Properties properties, String cacheName, String name, String defaultValue) {
        return properties.getProperty(cacheName + "." + name, properties.getProperty(name, defaultValue));
    }

    private static boolean isNotZero(Duration duration) {
        return duration == null || !duration.isZero();
    }

    private static <T> T throwEntryProcessorException(Exception ex) {
        if (EntryProcessorException.class.isInstance(ex)) {
            throw (EntryProcessorException)EntryProcessorException.class.cast(ex);
        }
        throw new EntryProcessorException((Throwable)ex);
    }

    private static void close(Object potentiallyCloseable, CacheException wrapper) {
        if (AutoCloseable.class.isInstance(potentiallyCloseable)) {
            try {
                ((AutoCloseable)AutoCloseable.class.cast(potentiallyCloseable)).close();
            }
            catch (Exception re) {
                wrapper.addSuppressed((Throwable)re);
            }
        }
    }

    private static class MapLoader<K, V>
    implements CacheLoader<K, V> {
        private final Map<K, V> loaded;

        private MapLoader(Map<K, V> loaded) {
            this.loaded = loaded;
        }

        public V load(K key) throws CacheLoaderException {
            return this.loaded.get(key);
        }

        public Map<K, V> loadAll(Iterable<? extends K> keys) throws CacheLoaderException {
            throw new UnsupportedOperationException();
        }
    }

    private class EvictionThread
    implements Runnable {
        private final long pause;
        private final long maxDelete;

        private EvictionThread(long evictionPause, long maxDelete) {
            this.pause = evictionPause;
            this.maxDelete = maxDelete;
        }

        @Override
        public void run() {
            while (!SimpleCache.this.isClosed()) {
                try {
                    Thread.sleep(this.pause);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    break;
                }
                if (SimpleCache.this.delegate.isEmpty()) continue;
                try {
                    final ArrayList keys = new ArrayList(SimpleCache.this.delegate.keySet());
                    Collections.sort(keys, new Comparator<SimpleKey<K>>(){

                        @Override
                        public int compare(SimpleKey<K> o1, SimpleKey<K> o2) {
                            long l = o1.lastAccess() - o2.lastAccess();
                            if (l == 0L) {
                                return keys.indexOf(o1) - keys.indexOf(o2);
                            }
                            return (int)l;
                        }
                    });
                    int delete = 0;
                    for (SimpleKey key : keys) {
                        SimpleElement elt = (SimpleElement)SimpleCache.this.delegate.get(key);
                        if (elt == null || !elt.isExpired()) continue;
                        SimpleCache.this.delegate.remove(key);
                        SimpleCache.this.statistics.increaseEvictions(1L);
                        SimpleCache.this.onExpired(key, elt);
                        if ((long)(++delete) < this.maxDelete) continue;
                    }
                }
                catch (Exception exception) {}
            }
        }
    }
}

